/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import java.io.Serializable;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ShortBlob
implements Serializable,
Comparable<ShortBlob> {
    public static final long serialVersionUID = -3427166602866836472L;
    private byte[] bytes;

    private ShortBlob() {
        this.bytes = new byte[0];
    }

    public ShortBlob(byte[] bytes) {
        this.bytes = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof ShortBlob) {
            ShortBlob other = (ShortBlob)object;
            return Arrays.equals(this.bytes, other.bytes);
        }
        return false;
    }

    public String toString() {
        return "<ShortBlob: " + this.bytes.length + " bytes>";
    }

    @Override
    public int compareTo(ShortBlob other) {
        DataTypeTranslator.ComparableByteArray cba1 = new DataTypeTranslator.ComparableByteArray(this.bytes);
        DataTypeTranslator.ComparableByteArray cba2 = new DataTypeTranslator.ComparableByteArray(other.bytes);
        return cba1.compareTo(cba2);
    }
}

