/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.IndexComponent;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedSet;

class UnorderedIndexComponent
implements IndexComponent {
    private final SortedSet<String> matcherProperties;

    public UnorderedIndexComponent(Set<String> unorderedGroup) {
        this.matcherProperties = Sets.newTreeSet(unorderedGroup);
    }

    @Override
    public boolean matches(List<OnestoreEntity.Index.Property> indexProperties) {
        HashSet<String> unorderedProps = Sets.newHashSet(this.matcherProperties);
        ListIterator<OnestoreEntity.Index.Property> indexItr = indexProperties.listIterator(indexProperties.size());
        while (!unorderedProps.isEmpty() && indexItr.hasPrevious()) {
            if (unorderedProps.remove(indexItr.previous().getName())) continue;
            return false;
        }
        return unorderedProps.isEmpty();
    }

    @Override
    public List<OnestoreEntity.Index.Property> preferredIndexProperties() {
        ArrayList<OnestoreEntity.Index.Property> indexProps = Lists.newArrayListWithExpectedSize(this.matcherProperties.size());
        for (String name : this.matcherProperties) {
            OnestoreEntity.Index.Property indexProperty = new OnestoreEntity.Index.Property();
            indexProperty.setName(name);
            indexProperty.setDirection(OnestoreEntity.Index.Property.Direction.ASCENDING);
            indexProps.add(indexProperty);
        }
        return indexProps;
    }

    @Override
    public int size() {
        return this.matcherProperties.size();
    }

    public String toString() {
        return "UnorderedIndexComponent: " + this.matcherProperties;
    }
}

