/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.NormalizedQuery;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.HashSet;
import org.checkerframework.checker.nullness.qual.Nullable;

class ValidatedQuery
extends NormalizedQuery {
    static final ImmutableSet<DatastoreV3Pb.Query.Filter.Operator> UNSUPPORTED_OPERATORS = ImmutableSet.of(DatastoreV3Pb.Query.Filter.Operator.IN);
    private boolean isGeo;

    ValidatedQuery(DatastoreV3Pb.Query query) {
        super(query);
        this.validateQuery();
    }

    /*
     * WARNING - void declaration
     */
    private void validateQuery() {
        void var4_14;
        if (this.query.propertyNameSize() > 0 && this.query.isKeysOnly()) {
            throw new IllegalQueryException("projection and keys_only cannot both be set", IllegalQueryType.ILLEGAL_PROJECTION);
        }
        HashSet<String> projectionProperties = new HashSet<String>(this.query.propertyNameSize());
        for (String string : this.query.propertyNames()) {
            if (projectionProperties.add(string)) continue;
            throw new IllegalQueryException("cannot project a property multiple times", IllegalQueryType.ILLEGAL_PROJECTION);
        }
        HashSet<String> groupBySet = Sets.newHashSetWithExpectedSize(this.query.groupByPropertyNameSize());
        for (String string : this.query.groupByPropertyNames()) {
            if (!groupBySet.add(string)) {
                throw new IllegalQueryException("cannot group by a property multiple times", IllegalQueryType.ILLEGAL_GROUPBY);
            }
            if (!Entity.RESERVED_NAME.matcher(string).matches()) continue;
            throw new IllegalQueryException("group by is not supported for the property: " + string, IllegalQueryType.ILLEGAL_GROUPBY);
        }
        HashSet<String> hashSet = Sets.newHashSetWithExpectedSize(this.query.groupByPropertyNameSize());
        for (DatastoreV3Pb.Query.Order order : this.query.orders()) {
            if (groupBySet.contains(order.getProperty())) {
                hashSet.add(order.getProperty());
                continue;
            }
            if (hashSet.size() == groupBySet.size()) continue;
            throw new IllegalQueryException("must specify all group by orderings before any non group by orderings", IllegalQueryType.ILLEGAL_GROUPBY);
        }
        if (this.query.hasTransaction() && !this.query.hasAncestor()) {
            throw new IllegalQueryException("Only ancestor queries are allowed inside transactions.", IllegalQueryType.TRANSACTION_REQUIRES_ANCESTOR);
        }
        if (!this.query.hasKind()) {
            for (DatastoreV3Pb.Query.Filter filter : this.query.filters()) {
                if (filter.getProperty(0).getName().equals("__key__")) continue;
                throw new IllegalQueryException("kind is required for non-__key__ filters", IllegalQueryType.KIND_REQUIRED);
            }
            for (DatastoreV3Pb.Query.Order order : this.query.orders()) {
                if (order.getProperty().equals("__key__") && order.getDirection() == DatastoreV3Pb.Query.Order.Direction.ASCENDING.getValue()) continue;
                throw new IllegalQueryException("kind is required for all orders except __key__ ascending", IllegalQueryType.KIND_REQUIRED);
            }
        }
        if (this.query.hasAncestor()) {
            OnestoreEntity.Reference reference = this.query.getAncestor();
            if (!reference.getApp().equals(this.query.getApp())) {
                throw new IllegalQueryException("The query app is " + this.query.getApp() + " but ancestor app is " + reference.getApp(), IllegalQueryType.ILLEGAL_VALUE);
            }
            if (!reference.getNameSpace().equals(this.query.getNameSpace())) {
                throw new IllegalQueryException("The query namespace is " + this.query.getNameSpace() + " but ancestor namespace is " + reference.getNameSpace(), IllegalQueryType.ILLEGAL_VALUE);
            }
        }
        Object var4_13 = null;
        this.isGeo = false;
        for (DatastoreV3Pb.Query.Filter filter : this.query.filters()) {
            int numProps = filter.propertySize();
            if (numProps != 1) {
                throw new IllegalQueryException(String.format("Filter has %s properties, expected 1", numProps), IllegalQueryType.FILTER_WITH_MULTIPLE_PROPS);
            }
            OnestoreEntity.Property prop = filter.getProperty(0);
            String propName = prop.getName();
            if ("__key__".equals(propName)) {
                OnestoreEntity.PropertyValue value = prop.getValue();
                if (!value.hasReferenceValue()) {
                    throw new IllegalQueryException("__key__ filter value must be a Key", IllegalQueryType.ILLEGAL_VALUE);
                }
                OnestoreEntity.PropertyValue.ReferenceValue refVal = value.getReferenceValue();
                if (!refVal.getApp().equals(this.query.getApp())) {
                    throw new IllegalQueryException("__key__ filter app is " + refVal.getApp() + " but query app is " + this.query.getApp(), IllegalQueryType.ILLEGAL_VALUE);
                }
                if (!refVal.getNameSpace().equals(this.query.getNameSpace())) {
                    throw new IllegalQueryException("__key__ filter namespace is " + refVal.getNameSpace() + " but query namespace is " + this.query.getNameSpace(), IllegalQueryType.ILLEGAL_VALUE);
                }
            }
            if (INEQUALITY_OPERATORS.contains(filter.getOpEnum())) {
                if (var4_14 == null) {
                    String string = propName;
                    continue;
                }
                if (var4_14.equals(propName)) continue;
                throw new IllegalQueryException(String.format("Only one inequality filter per query is supported.  Encountered both %s and %s", var4_14, propName), IllegalQueryType.MULTIPLE_INEQ_FILTERS);
            }
            if (filter.getOpEnum() == DatastoreV3Pb.Query.Filter.Operator.EQUAL) {
                if (projectionProperties.contains(propName)) {
                    throw new IllegalQueryException("cannot use projection on a property with an equality filter", IllegalQueryType.ILLEGAL_PROJECTION);
                }
                if (!groupBySet.contains(propName)) continue;
                throw new IllegalQueryException("cannot use group by on a property with an equality filter", IllegalQueryType.ILLEGAL_GROUPBY);
            }
            if (filter.getOpEnum() == DatastoreV3Pb.Query.Filter.Operator.CONTAINED_IN_REGION) {
                this.isGeo = true;
                if (!filter.hasGeoRegion() || prop.getValue().hasPointValue()) {
                    throw new IllegalQueryException(String.format("Geo-spatial filter on %s should specify GeoRegion rather than Property Value", propName), IllegalQueryType.UNSUPPORTED_FILTER);
                }
                DatastoreV3Pb.GeoRegion region = filter.getGeoRegion();
                if ((!region.hasCircle() || !region.hasRectangle()) && (region.hasCircle() || region.hasRectangle())) continue;
                throw new IllegalQueryException(String.format("Geo-spatial filter on %s should specify Circle or Rectangle, but not both", propName), IllegalQueryType.UNSUPPORTED_FILTER);
            }
            if (!UNSUPPORTED_OPERATORS.contains(filter.getOpEnum())) continue;
            throw new IllegalQueryException(String.format("Unsupported filter operator: %s", filter.getOp()), IllegalQueryType.UNSUPPORTED_FILTER);
        }
        if (this.isGeo) {
            if (var4_14 != null) {
                throw new IllegalQueryException("Inequality filter with geo-spatial query is not supported.", IllegalQueryType.UNSUPPORTED_FILTER);
            }
            if (this.query.hasAncestor()) {
                throw new IllegalQueryException("Geo-spatial filter on ancestor query is not supported.", IllegalQueryType.UNSUPPORTED_FILTER);
            }
            if (this.query.hasCompiledCursor() || this.query.hasEndCompiledCursor()) {
                throw new IllegalQueryException("Start and end cursors are not supported on geo-spatial queries.", IllegalQueryType.CURSOR_NOT_SUPPORTED);
            }
        }
        if (var4_14 != null && this.query.groupByPropertyNameSize() > 0 && !groupBySet.contains(var4_14)) {
            throw new IllegalQueryException(String.format("Inequality filter on %s must also be a group by property when group by properties are set.", var4_14), IllegalQueryType.ILLEGAL_GROUPBY);
        }
        if (var4_14 != null && this.query.orderSize() > 0 && !var4_14.equals(this.query.getOrder(0).getProperty())) {
            throw new IllegalQueryException(String.format("The first sort property must be the same as the property to which the inequality filter is applied.  In your query the first sort property is %s but the inequality filter is on %s", this.query.getOrder(0).getProperty(), var4_14), IllegalQueryType.FIRST_SORT_NEQ_INEQ_PROP);
        }
    }

    public boolean isGeo() {
        return this.isGeo;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatedQuery that = (ValidatedQuery)o;
        return this.query.equals(that.query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    static class IllegalQueryException
    extends ApiProxy.ApplicationException {
        private static final long serialVersionUID = -2398830747594327420L;
        private final IllegalQueryType illegalQueryType;

        IllegalQueryException(String errorDetail, IllegalQueryType illegalQueryType) {
            super(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST.getValue(), errorDetail);
            this.illegalQueryType = illegalQueryType;
        }

        IllegalQueryType getIllegalQueryType() {
            return this.illegalQueryType;
        }
    }

    static enum IllegalQueryType {
        KIND_REQUIRED,
        UNSUPPORTED_FILTER,
        FILTER_WITH_MULTIPLE_PROPS,
        MULTIPLE_INEQ_FILTERS,
        FIRST_SORT_NEQ_INEQ_PROP,
        TRANSACTION_REQUIRES_ANCESTOR,
        ILLEGAL_VALUE,
        ILLEGAL_PROJECTION,
        ILLEGAL_GROUPBY,
        CURSOR_NOT_SUPPORTED;

    }
}

