/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.base;

import com.google.async.threadsafety.annotations.ThreadSafe;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.net.HostAndPort;
import com.google.errorprone.annotations.Immutable;
import java.net.URL;
import java.util.List;

@Immutable
@ThreadSafe
public final class ServerAddress {
    static final int NO_PORT = -1;
    private final String host;
    private final int port;
    private static final CharMatcher IPV6_CHARS = CharMatcher.anyOf(":.").or(CharMatcher.inRange('0', '9')).or(CharMatcher.inRange('a', 'f')).or(CharMatcher.inRange('A', 'F')).precomputed();
    private static final Splitter SPLIT_HOST_PAIRS = Splitter.on(',').trimResults(CharMatcher.inRange('\u0000', ' ')).omitEmptyStrings();

    private ServerAddress(String host, int port) {
        this.host = Preconditions.checkNotNull(host, "host cannot be null");
        Preconditions.checkArgument(port >= -1, "port (%s) must be >= -1", port);
        Preconditions.checkArgument(port <= 65535, "port (%s) must be <= 65535", port);
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        Preconditions.checkState(this.hasPort());
        return this.port;
    }

    public int getPortOrDefault(int defaultPort) {
        return this.hasPort() ? this.port : defaultPort;
    }

    public boolean hasPort() {
        return this.port >= 0;
    }

    public HostAndPort toHostAndPort() {
        return this.port == -1 ? HostAndPort.fromHost(this.host) : HostAndPort.fromParts(this.host, this.port);
    }

    public boolean equals(Object other) {
        if (other instanceof ServerAddress) {
            ServerAddress that = (ServerAddress)other;
            return this.port == that.port && this.host.equals(that.host);
        }
        return false;
    }

    public int hashCode() {
        return this.host.hashCode() + this.port;
    }

    public String toString() {
        boolean needsBrackets = ServerAddress.looksLikeIpv6Address(this.host);
        if (this.port == -1) {
            if (needsBrackets) {
                return '[' + this.host + ']';
            }
            return this.host;
        }
        StringBuilder builder = new StringBuilder(this.host.length() + 8);
        if (needsBrackets) {
            builder.append('[').append(this.host).append(']');
        } else {
            builder.append(this.host);
        }
        return builder.append(':').append(this.port).toString();
    }

    private static boolean looksLikeIpv6Address(String host) {
        int colons = 0;
        for (int i = 0; i < host.length(); ++i) {
            char c = host.charAt(i);
            if (c == ':') {
                ++colons;
                continue;
            }
            if (IPV6_CHARS.matches(c)) continue;
            return false;
        }
        return colons >= 2;
    }

    public static ServerAddress[] parseServerAddresses(String spec) {
        List<String> hostPortPairs = SPLIT_HOST_PAIRS.splitToList(spec);
        ServerAddress[] servAddrs = new ServerAddress[hostPortPairs.size()];
        for (int i = 0; i < hostPortPairs.size(); ++i) {
            servAddrs[i] = ServerAddress.fromString(hostPortPairs.get(i));
        }
        return servAddrs;
    }

    public static ServerAddress fromHostAndPort(HostAndPort hostAndPort) {
        return hostAndPort.hasPort() ? ServerAddress.fromParts(hostAndPort.getHost(), hostAndPort.getPort()) : ServerAddress.fromHost(hostAndPort.getHost());
    }

    public static ServerAddress fromURL(URL url) {
        String host = url.getHost();
        int port = url.getPort();
        return port == -1 ? ServerAddress.fromHost(host) : ServerAddress.fromParts(host, port);
    }

    public static ServerAddress fromString(String spec) {
        HostAndPort hp = HostAndPort.fromString(spec);
        String host = hp.getHost();
        Preconditions.checkArgument(!host.isEmpty(), "no hostname: %s", (Object)spec);
        Preconditions.checkArgument(hp.hasPort(), "no port: %s", (Object)spec);
        int port = hp.getPort();
        return new ServerAddress(host, port);
    }

    public static ServerAddress fromHost(String host) {
        return new ServerAddress(host, -1);
    }

    public static ServerAddress fromParts(String host, int port) {
        Preconditions.checkArgument(port >= 0, "port (%s) must be >= 0", port);
        return new ServerAddress(host, port);
    }
}

