/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import java.util.HashMap;
import java.util.Map;

public class ApiDeadlineOracle {
    private final DeadlineMap deadlineMap;
    private final DeadlineMap offlineDeadlineMap;

    private ApiDeadlineOracle(DeadlineMap deadlineMap, DeadlineMap offlineDeadlineMap) {
        this.deadlineMap = deadlineMap;
        this.offlineDeadlineMap = offlineDeadlineMap;
    }

    public double getDeadline(String packageName, boolean isOffline, Number userDeadline) {
        if (isOffline) {
            return this.offlineDeadlineMap.getDeadline(packageName, userDeadline);
        }
        return this.deadlineMap.getDeadline(packageName, userDeadline);
    }

    public void addPackageDefaultDeadline(String packageName, double defaultDeadline) {
        this.deadlineMap.addDefaultDeadline(packageName, defaultDeadline);
    }

    public void addPackageMaxDeadline(String packageName, double maxDeadline) {
        this.deadlineMap.addMaxDeadline(packageName, maxDeadline);
    }

    public void addOfflinePackageDefaultDeadline(String packageName, double defaultDeadline) {
        this.offlineDeadlineMap.addDefaultDeadline(packageName, defaultDeadline);
    }

    public void addOfflinePackageMaxDeadline(String packageName, double maxDeadline) {
        this.offlineDeadlineMap.addMaxDeadline(packageName, maxDeadline);
    }

    public void addPackageMinContentSizeForBuffer(String packageName, long minContentSizeForBuffer) {
        this.deadlineMap.addMinContentSizeForBuffer(packageName, minContentSizeForBuffer);
    }

    public void addPackageMaxRequestSize(String packageName, long maxRequestSize) {
        this.deadlineMap.addMaxRequestSize(packageName, maxRequestSize);
    }

    public void addOfflinePackageMinContentSizeForBuffer(String packageName, long minContentSizeForBuffer) {
        this.offlineDeadlineMap.addMinContentSizeForBuffer(packageName, minContentSizeForBuffer);
    }

    public void addOfflinePackageMaxRequestSize(String packageName, long maxRequestSize) {
        this.offlineDeadlineMap.addMaxRequestSize(packageName, maxRequestSize);
    }

    public static class DeadlineMap {
        private final double defaultDeadline;
        private final Map<String, Double> defaultDeadlineMap;
        private final double maxDeadline;
        private final Map<String, Double> maxDeadlineMap;
        private final Map<String, Long> minContentSizeForBufferMap;
        private final Map<String, Long> maxRequestSizeMap;

        public DeadlineMap(double defaultDeadline, Map<String, Double> defaultDeadlineMap, double maxDeadline, Map<String, Double> maxDeadlineMap) {
            this.defaultDeadline = defaultDeadline;
            this.defaultDeadlineMap = defaultDeadlineMap;
            this.maxDeadline = maxDeadline;
            this.maxDeadlineMap = maxDeadlineMap;
            this.minContentSizeForBufferMap = new HashMap<String, Long>();
            this.maxRequestSizeMap = new HashMap<String, Long>();
        }

        private double getDeadline(String pkg, Number userDeadline) {
            double deadline = userDeadline == null ? this.getDoubleValue(pkg, this.defaultDeadlineMap, this.defaultDeadline) : userDeadline.doubleValue();
            return Math.min(deadline, this.getDoubleValue(pkg, this.maxDeadlineMap, this.maxDeadline));
        }

        private void addDefaultDeadline(String packageName, double defaultDeadline) {
            this.defaultDeadlineMap.put(packageName, defaultDeadline);
        }

        private void addMaxDeadline(String packageName, double maxDeadline) {
            this.maxDeadlineMap.put(packageName, maxDeadline);
        }

        private void addMinContentSizeForBuffer(String packageName, long minContentSizeForBuffer) {
            this.minContentSizeForBufferMap.put(packageName, minContentSizeForBuffer);
        }

        private void addMaxRequestSize(String packageName, long maxRequestSize) {
            this.maxRequestSizeMap.put(packageName, maxRequestSize);
        }

        private double getDoubleValue(String packageName, Map<String, Double> map, double fallthrough) {
            Double value = map.get(packageName);
            if (value == null) {
                value = fallthrough;
            }
            return value;
        }
    }

    public static class Builder {
        private DeadlineMap deadlineMap;
        private DeadlineMap offlineDeadlineMap;

        public Builder initDeadlineMap(double defaultDeadline, String defaultDeadlineMapString, double maxDeadline, String maxDeadlineMapString) {
            this.deadlineMap = new DeadlineMap(defaultDeadline, Builder.parseDoubleMap(defaultDeadlineMapString), maxDeadline, Builder.parseDoubleMap(maxDeadlineMapString));
            return this;
        }

        public Builder initDeadlineMap(DeadlineMap deadlineMap) {
            this.deadlineMap = deadlineMap;
            return this;
        }

        public Builder initOfflineDeadlineMap(double defaultDeadline, String defaultDeadlineMapString, double maxDeadline, String maxDeadlineMapString) {
            this.offlineDeadlineMap = new DeadlineMap(defaultDeadline, Builder.parseDoubleMap(defaultDeadlineMapString), maxDeadline, Builder.parseDoubleMap(maxDeadlineMapString));
            return this;
        }

        public Builder initOfflineDeadlineMap(DeadlineMap offlineDeadlineMap) {
            this.offlineDeadlineMap = offlineDeadlineMap;
            return this;
        }

        public ApiDeadlineOracle build() {
            if (this.deadlineMap == null || this.offlineDeadlineMap == null) {
                throw new IllegalStateException("All deadline maps must be initialized.");
            }
            return new ApiDeadlineOracle(this.deadlineMap, this.offlineDeadlineMap);
        }

        private static Map<String, Double> parseDoubleMap(String mapString) {
            HashMap<String, Double> map = new HashMap<String, Double>();
            if (mapString.length() > 0) {
                for (String entry : mapString.split(",")) {
                    int colon = entry.indexOf(58);
                    if (colon == -1) {
                        throw new IllegalArgumentException("Could not parse entry: " + entry);
                    }
                    map.put(entry.substring(0, colon), Double.parseDouble(entry.substring(colon + 1)));
                }
            }
            return map;
        }
    }
}

