/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.logservice.LogServicePb;
import com.google.apphosting.base.protos.AppLogsPb;
import com.google.apphosting.base.protos.SourcePb;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;

public class AppLogsWriter {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    static final String LOG_CONTINUATION_SUFFIX = "\n<continued in next message>";
    static final int LOG_CONTINUATION_SUFFIX_LENGTH = "\n<continued in next message>".length();
    static final String LOG_CONTINUATION_PREFIX = "<continued from previous message>\n";
    static final int LOG_CONTINUATION_PREFIX_LENGTH = "<continued from previous message>\n".length();
    static final int MIN_MAX_LOG_MESSAGE_LENGTH = 1024;
    static final String LOG_TRUNCATED_SUFFIX = "\n<truncated>";
    static final int LOG_TRUNCATED_SUFFIX_LENGTH = "\n<truncated>".length();
    private static final String PROTECTED_LOGS_CLASSES_REGEXP = "(com\\.google\\.apphosting\\.runtime\\.security|java\\.lang\\.reflect|java\\.lang\\.invoke|java\\.security|sun\\.reflect)\\..+";
    private final Object lock = new Object();
    private final int maxLogMessageLength;
    private final int logCutLength;
    private final int logCutLengthDiv10;
    @GuardedBy(value="lock")
    private final MutableUpResponse upResponse;
    private final long maxBytesToFlush;
    @GuardedBy(value="lock")
    private long currentByteCount;
    private final int maxSecondsBetweenFlush;
    @GuardedBy(value="lock")
    private Future<byte[]> currentFlush;
    @GuardedBy(value="lock")
    private Stopwatch stopwatch;
    private static final Pattern PROTECTED_LOGS_CLASSES = Pattern.compile("(com\\.google\\.apphosting\\.runtime\\.security|java\\.lang\\.reflect|java\\.lang\\.invoke|java\\.security|sun\\.reflect)\\..+");

    public AppLogsWriter(MutableUpResponse upResponse, long maxBytesToFlush, int maxLogMessageLength, int maxFlushSeconds) {
        String message;
        this.upResponse = upResponse;
        this.maxSecondsBetweenFlush = maxFlushSeconds;
        if (maxLogMessageLength < 1024) {
            message = String.format("maxLogMessageLength sillily small (%s); setting maxLogMessageLength to %s", maxLogMessageLength, 1024);
            ((GoogleLogger.Api)logger.atWarning()).log("%s", message);
            this.maxLogMessageLength = 1024;
        } else {
            this.maxLogMessageLength = maxLogMessageLength;
        }
        this.logCutLength = maxLogMessageLength - LOG_CONTINUATION_SUFFIX_LENGTH;
        this.logCutLengthDiv10 = this.logCutLength / 10;
        if (maxBytesToFlush < (long)this.maxLogMessageLength) {
            message = String.format("maxBytesToFlush (%s) smaller than  maxLogMessageLength (%s)", maxBytesToFlush, this.maxLogMessageLength);
            ((GoogleLogger.Api)logger.atWarning()).log("%s", message);
            this.maxBytesToFlush = this.maxLogMessageLength;
        } else {
            this.maxBytesToFlush = maxBytesToFlush;
        }
        this.stopwatch = Stopwatch.createUnstarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogRecordAndMaybeFlush(ApiProxy.LogRecord fullRecord) {
        ArrayList<AppLogsPb.AppLogLine> appLogLines = new ArrayList<AppLogsPb.AppLogLine>();
        for (ApiProxy.LogRecord record : this.split(fullRecord)) {
            SourcePb.SourceLocation sourceLocation;
            AppLogsPb.AppLogLine.Builder logLineBuilder = AppLogsPb.AppLogLine.newBuilder().setLevel(record.getLevel().ordinal()).setTimestampUsec(record.getTimestamp()).setMessage(record.getMessage());
            StackTraceElement frame = AppLogsWriter.stackFrameFor(record.getStackFrame(), record.getSourceLocation());
            if (frame != null && (sourceLocation = this.getSourceLocationProto(frame)) != null) {
                logLineBuilder.setSourceLocation(sourceLocation);
            }
            appLogLines.add(logLineBuilder.build());
        }
        Object object = this.lock;
        synchronized (object) {
            this.addLogLinesAndMaybeFlush(appLogLines);
        }
    }

    @GuardedBy(value="lock")
    private void addLogLinesAndMaybeFlush(Iterable<AppLogsPb.AppLogLine> appLogLines) {
        for (AppLogsPb.AppLogLine logLine : appLogLines) {
            int serializedSize = logLine.getSerializedSize();
            if (this.maxBytesToFlush > 0L && this.currentByteCount + (long)serializedSize > this.maxBytesToFlush) {
                ((GoogleLogger.Api)logger.atInfo()).log("%d bytes of app logs pending, starting flush...", this.currentByteCount);
                this.waitForCurrentFlushAndStartNewFlush();
            }
            if (!this.stopwatch.isRunning()) {
                this.stopwatch.start();
            }
            this.upResponse.addAppLog(logLine);
            this.currentByteCount += (long)serializedSize;
        }
        if (this.maxSecondsBetweenFlush > 0 && this.stopwatch.elapsed().getSeconds() >= (long)this.maxSecondsBetweenFlush) {
            this.waitForCurrentFlushAndStartNewFlush();
        }
    }

    @GuardedBy(value="lock")
    private void waitForCurrentFlushAndStartNewFlush() {
        this.waitForCurrentFlush();
        if (this.upResponse.getAppLogCount() > 0) {
            this.currentFlush = this.doFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAndWait() {
        Future<byte[]> flush = null;
        Object object = this.lock;
        synchronized (object) {
            this.waitForCurrentFlush();
            if (this.upResponse.getAppLogCount() > 0) {
                this.currentFlush = this.doFlush();
                flush = this.currentFlush;
            }
        }
        if (flush != null) {
            this.waitForFlush(flush);
        }
    }

    @GuardedBy(value="lock")
    private void waitForCurrentFlush() {
        if (this.currentFlush != null && !this.currentFlush.isDone() && !this.currentFlush.isCancelled()) {
            ((GoogleLogger.Api)logger.atInfo()).log("Previous flush has not yet completed, blocking.");
            this.waitForFlush(this.currentFlush);
        }
        this.currentFlush = null;
    }

    private void waitForFlush(Future<byte[]> flush) {
        try {
            flush.get();
        }
        catch (InterruptedException ex) {
            ((GoogleLogger.Api)logger.atWarning()).log("Interrupted while blocking on a log flush, setting interrupt bit and continuing.  Some logs may be lost or occur out of order!");
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("A log flush request failed.  Log messages may have been lost!");
        }
    }

    @GuardedBy(value="lock")
    private Future<byte[]> doFlush() {
        AppLogsPb.AppLogGroup.Builder group = AppLogsPb.AppLogGroup.newBuilder();
        for (AppLogsPb.AppLogLine logLine : this.upResponse.getAndClearAppLogList()) {
            group.addLogLine(logLine);
        }
        this.currentByteCount = 0L;
        this.stopwatch.reset();
        LogServicePb.FlushRequest request = LogServicePb.FlushRequest.newBuilder().setLogs(group.build().toByteString()).build();
        return ApiProxy.makeAsyncCall((String)"logservice", (String)"Flush", (byte[])request.toByteArray());
    }

    @VisibleForTesting
    List<ApiProxy.LogRecord> split(ApiProxy.LogRecord aRecord) {
        String message = aRecord.getMessage();
        if (null == message || message.length() <= this.maxLogMessageLength) {
            return ImmutableList.of(aRecord);
        }
        ArrayList<ApiProxy.LogRecord> theList = new ArrayList<ApiProxy.LogRecord>();
        String remaining = message;
        while (remaining.length() > 0) {
            String nextMessage;
            if (remaining.length() <= this.maxLogMessageLength) {
                nextMessage = remaining;
                remaining = "";
            } else {
                int cutLength = this.logCutLength;
                boolean cutAtNewline = false;
                int friendlyCutLength = remaining.lastIndexOf(10, this.logCutLength);
                if (friendlyCutLength > this.logCutLengthDiv10) {
                    cutLength = friendlyCutLength;
                    cutAtNewline = true;
                } else if (Character.isHighSurrogate(remaining.charAt(cutLength - 1))) {
                    --cutLength;
                }
                nextMessage = remaining.substring(0, cutLength) + LOG_CONTINUATION_SUFFIX;
                remaining = remaining.substring(cutLength + (cutAtNewline ? 1 : 0));
                if (remaining.length() > this.maxLogMessageLength || remaining.length() + LOG_CONTINUATION_PREFIX_LENGTH <= this.maxLogMessageLength) {
                    remaining = LOG_CONTINUATION_PREFIX + remaining;
                }
            }
            theList.add(new ApiProxy.LogRecord(aRecord, nextMessage));
        }
        return ImmutableList.copyOf(theList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setStopwatch(Stopwatch stopwatch) {
        Object object = this.lock;
        synchronized (object) {
            this.stopwatch = stopwatch;
        }
    }

    @VisibleForTesting
    int getMaxLogMessageLength() {
        return this.maxLogMessageLength;
    }

    @VisibleForTesting
    long getByteCountBeforeFlushing() {
        return this.maxBytesToFlush;
    }

    @VisibleForTesting
    SourcePb.SourceLocation getSourceLocationProto(StackTraceElement sourceLocationFrame) {
        if (sourceLocationFrame == null || sourceLocationFrame.getFileName() == null) {
            return null;
        }
        return SourcePb.SourceLocation.newBuilder().setFile(sourceLocationFrame.getFileName()).setLine(sourceLocationFrame.getLineNumber()).setFunctionName(sourceLocationFrame.getClassName() + "." + sourceLocationFrame.getMethodName()).build();
    }

    private static StackTraceElement stackFrameFor(StackTraceElement frame, Throwable stack) {
        if (frame == null) {
            if (stack == null) {
                return null;
            }
            return AppLogsWriter.getTopUserStackFrame(Throwables.lazyStackTrace(stack));
        }
        if (frame.getFileName() != null && frame.getLineNumber() > 0) {
            return frame;
        }
        if (stack == null) {
            return null;
        }
        return AppLogsWriter.findStackFrame(frame.getClassName(), frame.getMethodName(), stack);
    }

    static StackTraceElement findStackFrame(String className, String methodName, Throwable stack) {
        List<StackTraceElement> stackFrames = Throwables.lazyStackTrace(stack);
        for (StackTraceElement stackFrame : stackFrames) {
            if (!className.equals(stackFrame.getClassName()) || !methodName.equals(stackFrame.getMethodName())) continue;
            return stackFrame;
        }
        return AppLogsWriter.getTopUserStackFrame(stackFrames);
    }

    public static ApiProxy.LogRecord.Level convertLogLevel(Level level) {
        long intLevel = level.intValue();
        if (intLevel >= (long)Level.SEVERE.intValue()) {
            return ApiProxy.LogRecord.Level.error;
        }
        if (intLevel >= (long)Level.WARNING.intValue()) {
            return ApiProxy.LogRecord.Level.warn;
        }
        if (intLevel >= (long)Level.INFO.intValue()) {
            return ApiProxy.LogRecord.Level.info;
        }
        return ApiProxy.LogRecord.Level.debug;
    }

    public static StackTraceElement getTopUserStackFrame(List<StackTraceElement> stack) {
        boolean loggerFrameEncountered = false;
        for (StackTraceElement element : stack) {
            if (AppLogsWriter.isLoggerFrame(element.getClassName())) {
                loggerFrameEncountered = true;
                continue;
            }
            if (!loggerFrameEncountered || AppLogsWriter.isProtectedFrame(element.getClassName())) continue;
            return element;
        }
        return null;
    }

    private static boolean isLoggerFrame(String cname) {
        return cname.equals("java.util.logging.Logger") || cname.equals("com.google.devtools.cdbg.debuglets.java.GaeDynamicLogHelper");
    }

    private static boolean isProtectedFrame(String cname) {
        return PROTECTED_LOGS_CLASSES.matcher(cname).lookingAt();
    }
}

