/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.base.AppVersionKey;
import com.google.apphosting.base.protos.AppinfoPb;
import com.google.apphosting.base.protos.GitSourceContext;
import com.google.apphosting.base.protos.SourceContext;
import com.google.apphosting.runtime.ApplicationEnvironment;
import com.google.apphosting.runtime.AutoBuilder_AppVersion_Builder;
import com.google.apphosting.runtime.CloudDebuggerCallback;
import com.google.apphosting.runtime.SessionsConfig;
import com.google.apphosting.runtime.ThreadGroupPool;
import com.google.auto.value.AutoBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.GoogleLogger;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class AppVersion
implements CloudDebuggerCallback {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final String STATIC_PREFIX = "__static__/";
    private static final String SOURCE_CONTEXT_FILE_PATH = "WEB-INF/classes/source-context.json";
    private static final String GIT_PROPERTIES_FILE_PATH = "WEB-INF/classes/git.properties";
    private final AppVersionKey appVersionKey;
    private final File rootDirectory;
    private final ClassLoader classLoader;
    private final ApplicationEnvironment environment;
    private final Set<String> resourceFiles;
    private final Set<String> staticFiles;
    private final SessionsConfig sessionsConfig;
    private final String publicRoot;
    private final ThreadGroupPool threadGroupPool;
    private boolean sourceContextLoaded = false;
    private SourceContext sourceContext;

    public static Builder builder() {
        return new AutoBuilder_AppVersion_Builder();
    }

    AppVersion(@Nullable AppVersionKey appVersionKey, @Nullable AppinfoPb.AppInfo appInfo, @Nullable File rootDirectory, @Nullable ClassLoader classLoader, @Nullable ApplicationEnvironment environment, @Nullable SessionsConfig sessionsConfig, String publicRoot, @Nullable ThreadGroupPool threadGroupPool) {
        this.appVersionKey = appVersionKey;
        this.rootDirectory = rootDirectory;
        this.classLoader = classLoader;
        this.environment = environment;
        this.resourceFiles = this.extractResourceFiles(appInfo);
        this.staticFiles = AppVersion.extractStaticFiles(appInfo);
        this.sessionsConfig = sessionsConfig;
        if (!publicRoot.isEmpty()) {
            publicRoot = publicRoot.substring(1) + "/";
        }
        this.publicRoot = publicRoot;
        this.threadGroupPool = threadGroupPool;
    }

    public AppVersionKey getKey() {
        return this.appVersionKey;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ApplicationEnvironment getEnvironment() {
        return this.environment;
    }

    public SessionsConfig getSessionsConfig() {
        return this.sessionsConfig;
    }

    public boolean isResourceFile(String path) {
        return this.resourceFiles.contains(this.publicRoot + path);
    }

    public boolean isStaticFile(String path) {
        return this.staticFiles.contains(STATIC_PREFIX + this.publicRoot + path);
    }

    public String getPublicRoot() {
        return this.publicRoot;
    }

    public ThreadGroupPool getThreadGroupPool() {
        return this.threadGroupPool;
    }

    @Override
    public CloudDebuggerCallback.ClassType getClassType(Class<?> cls) {
        return AccessController.doPrivileged(() -> {
            ClassLoader testedClassLoader = cls.getClassLoader();
            if (testedClassLoader == this.classLoader) {
                return CloudDebuggerCallback.ClassType.APPLICATION;
            }
            if (testedClassLoader == this.getClass().getClassLoader()) {
                return CloudDebuggerCallback.ClassType.RUNTIME;
            }
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            if (testedClassLoader == systemClassLoader || testedClassLoader == systemClassLoader.getParent()) {
                return CloudDebuggerCallback.ClassType.SAFE_RUNTIME;
            }
            return CloudDebuggerCallback.ClassType.UNKNOWN;
        });
    }

    public synchronized SourceContext getSourceContext() {
        if (!this.sourceContextLoaded) {
            this.sourceContext = this.readSourceContext();
            this.sourceContextLoaded = true;
        }
        return this.sourceContext;
    }

    private SourceContext readSourceContext() {
        SourceContext sourceContextFromFile = this.readSourceContextFromJsonFile();
        if (sourceContextFromFile == null) {
            sourceContextFromFile = this.readSourceContextFromGitPropertiesFile();
        }
        return sourceContextFromFile;
    }

    private SourceContext readSourceContextFromJsonFile() {
        SourceContext sourceContext = null;
        try {
            Path sourceContextPath = this.rootDirectory.toPath().resolve(SOURCE_CONTEXT_FILE_PATH);
            String content = new String(Files.readAllBytes(sourceContextPath), StandardCharsets.UTF_8);
            SourceContext.Builder sourceContextBuilder = SourceContext.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(content, (Message.Builder)sourceContextBuilder);
            sourceContext = sourceContextBuilder.build();
            if (sourceContext.getContextCase() == SourceContext.ContextCase.CONTEXT_NOT_SET) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return sourceContext;
    }

    private SourceContext readSourceContextFromGitPropertiesFile() {
        SourceContext gitSourceContext;
        try {
            File gitPropertiesFile = new File(this.rootDirectory, GIT_PROPERTIES_FILE_PATH);
            Properties gitProperties = new Properties();
            gitProperties.load(new FileInputStream(gitPropertiesFile));
            String url = gitProperties.getProperty("git.remote.origin.url");
            String commit = gitProperties.getProperty("git.commit.id");
            if (url != null && commit != null) {
                gitSourceContext = SourceContext.newBuilder().setGit(GitSourceContext.newBuilder().setUrl(url).setRevisionId(commit)).build();
                ((GoogleLogger.Api)logger.atInfo()).log("found Git properties and generated source context:\n%s", gitSourceContext);
            } else {
                gitSourceContext = null;
            }
        }
        catch (Exception e) {
            gitSourceContext = null;
        }
        return gitSourceContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ImmutableSet<String> extractResourceFiles(AppinfoPb.AppInfo appInfo) {
        if (!appInfo.getFileList().isEmpty()) {
            return appInfo.getFileList().stream().map(AppinfoPb.AppInfo.File::getPath).collect(ImmutableSet.toImmutableSet());
        }
        if (this.getRootDirectory() == null) return ImmutableSet.of();
        Path app = FileSystems.getDefault().getPath(this.getRootDirectory().getAbsolutePath(), new String[0]);
        if (!Files.isDirectory(app, new LinkOption[0])) return ImmutableSet.of();
        try (Stream<Path> stream = Files.walk(app, FileVisitOption.FOLLOW_LINKS);){
            ImmutableSet<String> immutableSet = stream.map(path -> app.relativize((Path)path).toString().replace('\\', '/')).collect(ImmutableSet.toImmutableSet());
            return immutableSet;
        }
        catch (IOException ex) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Cannot list files in : %s", app);
        }
        return ImmutableSet.of();
    }

    private static Set<String> extractStaticFiles(AppinfoPb.AppInfo appInfo) {
        HashSet<String> files = new HashSet<String>();
        for (AppinfoPb.AppInfo.Blob blob : appInfo.getBlobList()) {
            files.add(blob.getPath());
        }
        return files;
    }

    @AutoBuilder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setAppVersionKey(AppVersionKey var1);

        public abstract Builder setAppInfo(AppinfoPb.AppInfo var1);

        public abstract Builder setRootDirectory(File var1);

        public abstract Builder setClassLoader(ClassLoader var1);

        public abstract Builder setEnvironment(ApplicationEnvironment var1);

        public abstract Builder setSessionsConfig(SessionsConfig var1);

        public abstract Builder setPublicRoot(String var1);

        public abstract Builder setThreadGroupPool(ThreadGroupPool var1);

        public abstract AppVersion build();
    }
}

