/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.runtime.ApiProxyImpl;
import com.google.apphosting.runtime.CloudDebuggerAgentWrapper;
import com.google.apphosting.runtime.RequestManager;
import com.google.apphosting.runtime.RuntimeLogSink;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

class AutoBuilder_RequestManager_Builder
extends RequestManager.Builder {
    private Long softDeadlineDelay;
    private Long hardDeadlineDelay;
    private Boolean disableDeadlineTimers;
    private Optional<RuntimeLogSink> runtimeLogSink = Optional.empty();
    private ApiProxyImpl apiProxyImpl;
    private Integer maxOutstandingApiRpcs;
    private Boolean threadStopTerminatesClone;
    private Boolean interruptFirstOnSoftDeadline;
    private CloudDebuggerAgentWrapper cloudDebuggerAgent;
    private Boolean enableCloudDebugger;
    private Long cyclesPerSecond;
    private Boolean waitForDaemonRequestThreads;
    private ImmutableMap<String, String> environment;

    AutoBuilder_RequestManager_Builder() {
    }

    @Override
    public RequestManager.Builder setSoftDeadlineDelay(long softDeadlineDelay) {
        this.softDeadlineDelay = softDeadlineDelay;
        return this;
    }

    @Override
    public long softDeadlineDelay() {
        if (this.softDeadlineDelay == null) {
            throw new IllegalStateException("Property \"softDeadlineDelay\" has not been set");
        }
        return this.softDeadlineDelay;
    }

    @Override
    public RequestManager.Builder setHardDeadlineDelay(long hardDeadlineDelay) {
        this.hardDeadlineDelay = hardDeadlineDelay;
        return this;
    }

    @Override
    public long hardDeadlineDelay() {
        if (this.hardDeadlineDelay == null) {
            throw new IllegalStateException("Property \"hardDeadlineDelay\" has not been set");
        }
        return this.hardDeadlineDelay;
    }

    @Override
    public RequestManager.Builder setDisableDeadlineTimers(boolean disableDeadlineTimers) {
        this.disableDeadlineTimers = disableDeadlineTimers;
        return this;
    }

    @Override
    public boolean disableDeadlineTimers() {
        if (this.disableDeadlineTimers == null) {
            throw new IllegalStateException("Property \"disableDeadlineTimers\" has not been set");
        }
        return this.disableDeadlineTimers;
    }

    @Override
    public RequestManager.Builder setRuntimeLogSink(Optional<RuntimeLogSink> runtimeLogSink) {
        if (runtimeLogSink == null) {
            throw new NullPointerException("Null runtimeLogSink");
        }
        this.runtimeLogSink = runtimeLogSink;
        return this;
    }

    @Override
    public RequestManager.Builder setApiProxyImpl(ApiProxyImpl apiProxyImpl) {
        if (apiProxyImpl == null) {
            throw new NullPointerException("Null apiProxyImpl");
        }
        this.apiProxyImpl = apiProxyImpl;
        return this;
    }

    @Override
    public RequestManager.Builder setMaxOutstandingApiRpcs(int maxOutstandingApiRpcs) {
        this.maxOutstandingApiRpcs = maxOutstandingApiRpcs;
        return this;
    }

    @Override
    public int maxOutstandingApiRpcs() {
        if (this.maxOutstandingApiRpcs == null) {
            throw new IllegalStateException("Property \"maxOutstandingApiRpcs\" has not been set");
        }
        return this.maxOutstandingApiRpcs;
    }

    @Override
    public RequestManager.Builder setThreadStopTerminatesClone(boolean threadStopTerminatesClone) {
        this.threadStopTerminatesClone = threadStopTerminatesClone;
        return this;
    }

    @Override
    public boolean threadStopTerminatesClone() {
        if (this.threadStopTerminatesClone == null) {
            throw new IllegalStateException("Property \"threadStopTerminatesClone\" has not been set");
        }
        return this.threadStopTerminatesClone;
    }

    @Override
    public RequestManager.Builder setInterruptFirstOnSoftDeadline(boolean interruptFirstOnSoftDeadline) {
        this.interruptFirstOnSoftDeadline = interruptFirstOnSoftDeadline;
        return this;
    }

    @Override
    public boolean interruptFirstOnSoftDeadline() {
        if (this.interruptFirstOnSoftDeadline == null) {
            throw new IllegalStateException("Property \"interruptFirstOnSoftDeadline\" has not been set");
        }
        return this.interruptFirstOnSoftDeadline;
    }

    @Override
    public RequestManager.Builder setCloudDebuggerAgent(@Nullable CloudDebuggerAgentWrapper cloudDebuggerAgent) {
        this.cloudDebuggerAgent = cloudDebuggerAgent;
        return this;
    }

    @Override
    public RequestManager.Builder setEnableCloudDebugger(boolean enableCloudDebugger) {
        this.enableCloudDebugger = enableCloudDebugger;
        return this;
    }

    @Override
    public boolean enableCloudDebugger() {
        if (this.enableCloudDebugger == null) {
            throw new IllegalStateException("Property \"enableCloudDebugger\" has not been set");
        }
        return this.enableCloudDebugger;
    }

    @Override
    public RequestManager.Builder setCyclesPerSecond(long cyclesPerSecond) {
        this.cyclesPerSecond = cyclesPerSecond;
        return this;
    }

    @Override
    public long cyclesPerSecond() {
        if (this.cyclesPerSecond == null) {
            throw new IllegalStateException("Property \"cyclesPerSecond\" has not been set");
        }
        return this.cyclesPerSecond;
    }

    @Override
    public RequestManager.Builder setWaitForDaemonRequestThreads(boolean waitForDaemonRequestThreads) {
        this.waitForDaemonRequestThreads = waitForDaemonRequestThreads;
        return this;
    }

    @Override
    public boolean waitForDaemonRequestThreads() {
        if (this.waitForDaemonRequestThreads == null) {
            throw new IllegalStateException("Property \"waitForDaemonRequestThreads\" has not been set");
        }
        return this.waitForDaemonRequestThreads;
    }

    @Override
    public RequestManager.Builder setEnvironment(Map<String, String> environment) {
        this.environment = ImmutableMap.copyOf(environment);
        return this;
    }

    @Override
    public RequestManager build() {
        if (this.softDeadlineDelay == null || this.hardDeadlineDelay == null || this.disableDeadlineTimers == null || this.apiProxyImpl == null || this.maxOutstandingApiRpcs == null || this.threadStopTerminatesClone == null || this.interruptFirstOnSoftDeadline == null || this.enableCloudDebugger == null || this.cyclesPerSecond == null || this.waitForDaemonRequestThreads == null || this.environment == null) {
            StringBuilder missing = new StringBuilder();
            if (this.softDeadlineDelay == null) {
                missing.append(" softDeadlineDelay");
            }
            if (this.hardDeadlineDelay == null) {
                missing.append(" hardDeadlineDelay");
            }
            if (this.disableDeadlineTimers == null) {
                missing.append(" disableDeadlineTimers");
            }
            if (this.apiProxyImpl == null) {
                missing.append(" apiProxyImpl");
            }
            if (this.maxOutstandingApiRpcs == null) {
                missing.append(" maxOutstandingApiRpcs");
            }
            if (this.threadStopTerminatesClone == null) {
                missing.append(" threadStopTerminatesClone");
            }
            if (this.interruptFirstOnSoftDeadline == null) {
                missing.append(" interruptFirstOnSoftDeadline");
            }
            if (this.enableCloudDebugger == null) {
                missing.append(" enableCloudDebugger");
            }
            if (this.cyclesPerSecond == null) {
                missing.append(" cyclesPerSecond");
            }
            if (this.waitForDaemonRequestThreads == null) {
                missing.append(" waitForDaemonRequestThreads");
            }
            if (this.environment == null) {
                missing.append(" environment");
            }
            throw new IllegalStateException("Missing required properties:" + missing);
        }
        return new RequestManager(this.softDeadlineDelay, this.hardDeadlineDelay, this.disableDeadlineTimers, this.runtimeLogSink, this.apiProxyImpl, this.maxOutstandingApiRpcs, this.threadStopTerminatesClone, this.interruptFirstOnSoftDeadline, this.cloudDebuggerAgent, this.enableCloudDebugger, this.cyclesPerSecond, this.waitForDaemonRequestThreads, this.environment);
    }
}

