/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.base.protos.ClonePb;
import com.google.apphosting.base.protos.EmptyMessage;
import com.google.apphosting.base.protos.ModelClonePb;
import com.google.apphosting.base.protos.SourceContext;
import com.google.apphosting.runtime.ApiDeadlineOracle;
import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.CloudDebuggerAgentWrapper;
import com.google.apphosting.runtime.RequestManager;
import com.google.apphosting.runtime.anyrpc.AnyRpcServerContext;
import com.google.apphosting.runtime.anyrpc.CloneControllerServerInterface;
import com.google.common.flogger.GoogleLogger;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;

public class CloneControllerImpl
implements CloneControllerServerInterface {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final Callback callback;
    private final ApiDeadlineOracle deadlineOracle;
    private final RequestManager requestManager;
    private final ByteBuffer hotspotPerformanceData;
    private final CloudDebuggerAgentWrapper cloudDebuggerAgent;

    public CloneControllerImpl(Callback callback, ApiDeadlineOracle deadlineOracle, RequestManager requestManager, ByteBuffer hotspotPerformanceData, CloudDebuggerAgentWrapper cloudDebuggerAgent) {
        this.callback = callback;
        this.deadlineOracle = deadlineOracle;
        this.requestManager = requestManager;
        this.hotspotPerformanceData = hotspotPerformanceData;
        this.cloudDebuggerAgent = cloudDebuggerAgent;
    }

    @Override
    public void waitForSandbox(AnyRpcServerContext rpc, EmptyMessage unused) {
        rpc.finishWithAppError(1, "waitForSandbox is unimplemented");
    }

    @Override
    public void applyCloneSettings(AnyRpcServerContext rpc, ClonePb.CloneSettings settings) {
        ((GoogleLogger.Api)logger.atWarning()).log("applyCloneSettings");
        try {
            if (settings.hasMaxOutstandingApiRpcs()) {
                this.requestManager.setMaxOutstandingApiRpcs(settings.getMaxOutstandingApiRpcs());
            }
            for (ClonePb.ApiPackageDeadlines deadline : settings.getApiCallDeadlinesList()) {
                if (deadline.hasDefaultDeadlineS()) {
                    this.deadlineOracle.addPackageDefaultDeadline(deadline.getApiPackage(), deadline.getDefaultDeadlineS());
                }
                if (!deadline.hasMaxDeadlineS()) continue;
                this.deadlineOracle.addPackageMaxDeadline(deadline.getApiPackage(), deadline.getMaxDeadlineS());
            }
            for (ClonePb.ApiPackageDeadlines deadline : settings.getOfflineApiCallDeadlinesList()) {
                if (deadline.hasDefaultDeadlineS()) {
                    this.deadlineOracle.addOfflinePackageDefaultDeadline(deadline.getApiPackage(), deadline.getDefaultDeadlineS());
                }
                if (!deadline.hasMaxDeadlineS()) continue;
                this.deadlineOracle.addOfflinePackageMaxDeadline(deadline.getApiPackage(), deadline.getMaxDeadlineS());
            }
            this.callback.divertNetworkServices();
            rpc.finishWithResponse(EmptyMessage.getDefaultInstance());
            ((GoogleLogger.Api)logger.atWarning()).log("applyCloneSettings done");
        }
        catch (RuntimeException ex) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(ex)).log("oh noes");
            throw ex;
        }
    }

    @Override
    public void sendDeadline(AnyRpcServerContext rpc, ModelClonePb.DeadlineInfo deadline) {
        ((GoogleLogger.Api)logger.atInfo()).log("Got a sendDeadline RPC.");
        this.requestManager.sendDeadline(deadline.getSecurityTicket(), deadline.getHard());
        rpc.finishWithResponse(EmptyMessage.getDefaultInstance());
    }

    @Override
    public void getPerformanceData(AnyRpcServerContext rpc, ModelClonePb.PerformanceDataRequest req) {
        ((GoogleLogger.Api)logger.atInfo()).log("Got a getPerformanceData RPC with type %s", req.getType());
        ClonePb.PerformanceData.Builder data = ClonePb.PerformanceData.newBuilder().setType(req.getType());
        if (this.hotspotPerformanceData != null) {
            ClonePb.PerformanceData.Entry.Builder entry = ClonePb.PerformanceData.Entry.newBuilder().setFormat(ClonePb.PerformanceData.Format.JAVA_HOTSPOT_HSPERFDATA);
            ByteBuffer bb = this.hotspotPerformanceData.duplicate();
            bb.position(0);
            bb.limit(bb.capacity());
            entry.setPayload(ByteString.copyFrom(bb));
            data.addEntries(entry);
        }
        rpc.finishWithResponse(data.build());
    }

    @Override
    public void updateActiveBreakpoints(AnyRpcServerContext rpc, ClonePb.CloudDebuggerBreakpoints request) {
        byte[][] requestData = new byte[request.getBreakpointDataCount()][];
        for (int i = 0; i < requestData.length; ++i) {
            requestData[i] = request.getBreakpointData(i).toByteArray();
        }
        this.cloudDebuggerAgent.setActiveBreakpoints(requestData);
        ClonePb.CloudDebuggerBreakpoints.Builder response = ClonePb.CloudDebuggerBreakpoints.newBuilder();
        byte[][] responseData = this.cloudDebuggerAgent.dequeueBreakpointUpdates();
        if (responseData != null) {
            for (byte[] breakpointData : responseData) {
                response.addBreakpointData(ByteString.copyFrom(breakpointData));
            }
        }
        rpc.finishWithResponse(response.build());
    }

    @Override
    public void getDebuggeeInfo(AnyRpcServerContext rpc, ClonePb.DebuggeeInfoRequest request) {
        ClonePb.DebuggeeInfoResponse.Builder response = ClonePb.DebuggeeInfoResponse.newBuilder();
        String[] parts = request.getAppVersionId().split("/");
        if (parts.length == 2) {
            SourceContext sourceContext = this.getSourceContext(parts[0], parts[1]);
            if (sourceContext != null) {
                response.getDebuggeeInfoBuilder().setSourceContext(sourceContext);
            }
        } else {
            ((GoogleLogger.Api)logger.atWarning()).log("invalid AppVersionId : %s", request.getAppVersionId());
        }
        rpc.finishWithResponse(response.build());
    }

    SourceContext getSourceContext(String appId, String versionId) {
        AppVersion appVersion = this.callback.getAppVersion(appId, versionId);
        return appVersion == null ? null : appVersion.getSourceContext();
    }

    public static interface Callback {
        public void divertNetworkServices();

        public AppVersion getAppVersion(String var1, String var2);
    }
}

