/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.taskqueue.DeferredTask;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.RetryOptions;
import com.google.appengine.api.taskqueue.TaskOptions;
import com.google.appengine.api.taskqueue.TransientFailureException;
import com.google.apphosting.runtime.DatastoreSessionStore;
import com.google.apphosting.runtime.SessionData;
import com.google.apphosting.runtime.SessionStore;
import java.lang.reflect.Constructor;

public class DeferredDatastoreSessionStore
extends DatastoreSessionStore {
    private static final int SAVE_TASK_AGE_LIMIT_SECS = 10;
    private static final Constructor<DeferredTask> putDeferredTaskConstructor = DeferredDatastoreSessionStore.getConstructor(DeferredTask.class.getPackage().getName() + ".DatastorePutDeferredTask", Entity.class);
    private static final Constructor<DeferredTask> deleteDeferredTaskConstructor = DeferredDatastoreSessionStore.getConstructor(DeferredTask.class.getPackage().getName() + ".DatastoreDeleteDeferredTask", Key.class);
    private final Queue queue;

    public DeferredDatastoreSessionStore(String queueName) {
        this.queue = queueName == null ? QueueFactory.getDefaultQueue() : QueueFactory.getQueue(queueName);
    }

    @Override
    public void saveSession(String key, SessionData data) throws SessionStore.Retryable {
        try {
            Entity e = DatastoreSessionStore.createEntityForSession(key, data);
            this.queue.add(TaskOptions.Builder.withPayload(DeferredDatastoreSessionStore.newDeferredTask(putDeferredTaskConstructor, e)).retryOptions(RetryOptions.Builder.withTaskAgeLimitSeconds(10L)));
        }
        catch (TransientFailureException e) {
            throw new SessionStore.Retryable(e);
        }
    }

    @Override
    public void deleteSession(String keyStr) {
        Key key = DatastoreSessionStore.createKeyForSession(keyStr);
        this.queue.add(TaskOptions.Builder.withPayload(DeferredDatastoreSessionStore.newDeferredTask(deleteDeferredTaskConstructor, key)));
    }

    private static Constructor<DeferredTask> getConstructor(String clsName, Class<?> argType) {
        try {
            Class<?> cls = Class.forName(clsName);
            Constructor<DeferredTask> ctor = cls.getConstructor(argType);
            ctor.setAccessible(true);
            return ctor;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static DeferredTask newDeferredTask(Constructor<DeferredTask> ctor, Object arg) {
        try {
            return ctor.newInstance(arg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

