/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.base.protos.HttpPb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;

public class HttpCompression {
    private static final ImmutableSet<String> COMPRESSABLE_CSS_JS = ImmutableSet.of("text/css", "text/javascript", "application/x-javascript", "application/javascript", "application/json");

    static byte[] compress(ByteString content) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream zos = new GZIPOutputStream(outputStream);){
            content.writeTo(zos);
        }
        return outputStream.toByteArray();
    }

    String getHeader(List<HttpPb.ParsedHttpHeader> lrh, String key) {
        for (HttpPb.ParsedHttpHeader p : lrh) {
            if (!p.getKey().equalsIgnoreCase(key)) continue;
            return p.getValue();
        }
        return null;
    }

    boolean isContentGzipEncoded(String header) {
        if (header == null) {
            return false;
        }
        return header.toLowerCase().contains("gzip");
    }

    public boolean attemptCompression(RuntimePb.UPRequest request, MutableUpResponse response) throws IOException {
        if (!response.hasHttpResponse()) {
            return false;
        }
        if (response.getHttpResponseResponse().size() == 0) {
            return false;
        }
        String contentEncoding = this.getHeader(response.getRuntimeHeadersList(), "Content-Encoding");
        if (this.isContentGzipEncoded(contentEncoding)) {
            return false;
        }
        String userAgent = this.getHeader(request.getRequest().getHeadersList(), "User-Agent");
        if (request.getRequest().getGzipGfe()) {
            userAgent = userAgent + ",gzip(gfe)";
        }
        String acceptEncoding = this.getHeader(request.getRuntimeHeadersList(), "Accept-Encoding");
        String contentType = this.getHeader(response.getHttpOutputHeadersList(), "Content-Type");
        boolean compressForGfe = this.shouldCompress(true, userAgent, acceptEncoding, contentType);
        boolean compressForClient = this.shouldCompress(false, userAgent, acceptEncoding, contentType);
        if (!compressForGfe && !compressForClient) {
            return false;
        }
        ByteString responseBytes = response.getHttpResponseResponse();
        long uncompressedSize = responseBytes.size();
        response.setHttpResponseResponse(ByteString.copyFrom(HttpCompression.compress(responseBytes)));
        response.setHttpUncompressedSize(uncompressedSize);
        response.setHttpUncompressForClient(!compressForClient);
        response.addRuntimeHeaders(HttpPb.ParsedHttpHeader.newBuilder().setKey("Content-Encoding").setValue("gzip"));
        return true;
    }

    boolean shouldCompress(boolean compressForGfe, String userAgent, String acceptEncoding, String contentType) {
        return this.canCompressFor(!compressForGfe, userAgent, acceptEncoding, contentType);
    }

    private boolean canCompressFor(boolean ignoreGfe, @Nullable String userAgent, @Nullable String coding, @Nullable String type) {
        if (userAgent == null || userAgent.isEmpty()) {
            return false;
        }
        if (coding == null || coding.isEmpty()) {
            return false;
        }
        if (type == null || type.isEmpty()) {
            return false;
        }
        if (!(coding.startsWith("gzip") || coding.contains(" gzip") || coding.contains(",gzip"))) {
            return false;
        }
        if (ignoreGfe && coding.contains("gzip(gfe)") && !coding.replace("gzip(gfe)", "").contains("gzip")) {
            return false;
        }
        try {
            MediaType mediaType = MediaType.parse(type);
            type = mediaType.type() != null && mediaType.subtype() != null ? mediaType.type() + "/" + mediaType.subtype() : "nodefaulttype";
        }
        catch (IllegalArgumentException e) {
            type = "nodefaulttype";
        }
        if (!(userAgent.contains("Mozilla/") && !userAgent.contains("Mozilla/4.0") || userAgent.contains(" MSIE ") || userAgent.contains("Opera") || this.isGoodGzipUserAgent(userAgent))) {
            int gzipPosition = userAgent.indexOf("gzip");
            if (gzipPosition != -1) {
                if (ignoreGfe && gzipPosition == userAgent.indexOf("gzip(gfe)")) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (!(!COMPRESSABLE_CSS_JS.contains(type) || userAgent.contains(" MSIE ") || userAgent.contains("Opera") || this.isGoodGzipUserAgent(userAgent) || userAgent.contains("gzip"))) {
            return false;
        }
        return type.startsWith("text/") || COMPRESSABLE_CSS_JS.contains(type) || type.startsWith("application/") && (type.endsWith("+xml") || type.endsWith("/xml") || type.endsWith("/csv")) || type.equals("image/pwg-raster");
    }

    private boolean isGoodGzipUserAgent(String userAgent) {
        return userAgent.contains(" Gecko") || userAgent.contains("Google") || userAgent.contains(" Safari/") || userAgent.contains("msnbot") || userAgent.contains("Baiduspider");
    }
}

