/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.runtime.AppLogsWriter;
import com.google.apphosting.runtime.LogHandler;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.io.PrintStream;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.annotation.Nullable;

public final class JsonLogHandler
extends LogHandler {
    private static final String TRACE_KEY = "\"logging.googleapis.com/trace\": ";
    private static final String SOURCE_LOCATION_KEY = "\"logging.googleapis.com/sourceLocation\": ";
    private static final String SPAN_KEY = "\"logging.googleapis.com/spanId\": ";
    private static final String DEBUG = "DEBUG";
    private static final String INFO = "INFO";
    private static final String WARNING = "WARNING";
    private static final String ERROR = "ERROR";
    private static final String DEFAULT = "DEFAULT";
    static final Escaper ESCAPER = Escapers.builder().addEscape('\"', "\\\"").addEscape('\\', "\\\\").addEscape('\n', "\\n").addEscape('\r', "\\r").addEscape('\t', "\\t").build();
    private final PrintStream out;
    private final boolean closePrintStreamOnClose;
    @Nullable
    private final String projectId;
    private final Formatter formatter;

    public JsonLogHandler(PrintStream out, boolean closePrintStreamOnClose, @Nullable String projectId, Formatter formatter) {
        this.out = out;
        this.closePrintStreamOnClose = closePrintStreamOnClose;
        this.projectId = projectId;
        this.formatter = Preconditions.checkNotNull(formatter);
    }

    @Override
    public void publish(LogRecord record) {
        StringBuilder json = new StringBuilder("{");
        this.appendTraceId(json);
        JsonLogHandler.appendSpanId(json);
        JsonLogHandler.appendSeverity(json, record);
        JsonLogHandler.appendSourceLocation(json, record);
        this.appendMessage(json, record);
        json.append("}");
        this.out.println(json.toString());
    }

    private static void appendSpanId(StringBuilder json) {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment instanceof ApiProxy.EnvironmentWithTrace) {
            ApiProxy.EnvironmentWithTrace environmentWithTrace = (ApiProxy.EnvironmentWithTrace)environment;
            environmentWithTrace.getSpanId().ifPresent(id -> json.append(SPAN_KEY).append("\"").append((String)id).append("\", "));
        }
    }

    private void appendMessage(StringBuilder json, LogRecord record) {
        String message = this.formatter.formatMessage(record);
        if (message == null) {
            message = "";
        }
        json.append("\"message\": \"").append(ESCAPER.escape(message));
        if (record.getThrown() != null) {
            json.append("\\n").append(ESCAPER.escape(Throwables.getStackTraceAsString(record.getThrown())));
        }
        json.append("\"");
    }

    private void appendTraceId(StringBuilder json) {
        if (Strings.isNullOrEmpty(this.projectId)) {
            return;
        }
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment instanceof ApiProxy.EnvironmentWithTrace) {
            ApiProxy.EnvironmentWithTrace environmentWithTrace = (ApiProxy.EnvironmentWithTrace)environment;
            environmentWithTrace.getTraceId().ifPresent(id -> json.append(TRACE_KEY).append("\"projects/").append(this.projectId).append("/traces/").append((String)id).append("\", "));
        }
    }

    private static void appendSeverity(StringBuilder json, LogRecord record) {
        json.append("\"severity\": \"").append(JsonLogHandler.levelToSeverity(record.getLevel())).append("\", ");
    }

    private static void appendSourceLocation(StringBuilder json, LogRecord record) {
        if (record.getSourceClassName() != null && record.getSourceMethodName() != null) {
            StackTraceElement stackFrame = AppLogsWriter.findStackFrame(record.getSourceClassName(), record.getSourceMethodName(), new Throwable());
            String function = '\"' + stackFrame.getClassName() + "." + stackFrame.getMethodName() + '\"';
            json.append(SOURCE_LOCATION_KEY).append('{').append("\"function\": ").append(function).append(", \"file\": \"").append(stackFrame.getFileName()).append("\", \"line\": \"").append(stackFrame.getLineNumber()).append("\"}, ");
        }
    }

    private static String levelToSeverity(Level level) {
        int intLevel = level == null ? 0 : level.intValue();
        switch (intLevel) {
            case 300: 
            case 400: 
            case 500: {
                return DEBUG;
            }
            case 700: 
            case 800: {
                return INFO;
            }
            case 900: {
                return WARNING;
            }
            case 1000: {
                return ERROR;
            }
        }
        return DEFAULT;
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() throws SecurityException {
        if (this.closePrintStreamOnClose) {
            this.out.close();
        }
    }
}

