/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.common.base.Throwables;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class LogHandler
extends Handler {
    private static final String[] RUNTIME_LOGGERS = new String[]{"com.google.apphosting.runtime", "com.google.common.stats", "com.google.net"};
    private static final List<Logger> runtimeLoggers = new ArrayList<Logger>();

    LogHandler() {
        this.setLevel(Level.FINEST);
        this.setFilter(new ApiProxyLogFilter());
        this.setFormatter(new CustomFormatter());
    }

    public void init(Logger rootLogger) {
        FastFormatter fastFormatter = new FastFormatter();
        for (Handler handler : rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
            for (String name : RUNTIME_LOGGERS) {
                Logger logger = Logger.getLogger(name);
                logger.addHandler(handler);
                runtimeLoggers.add(logger);
            }
            handler.setFormatter(fastFormatter);
        }
        for (String name : RUNTIME_LOGGERS) {
            Logger logger = Logger.getLogger(name);
            logger.setUseParentHandlers(false);
        }
        rootLogger.addHandler(this);
    }

    @Override
    public abstract void publish(LogRecord var1);

    @Override
    public abstract void flush();

    @Override
    public abstract void close();

    private static final class FastFormatter
    extends Formatter {
        private FastFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            Instant instant = Instant.ofEpochMilli(record.getMillis());
            ZonedDateTime time = instant.atZone(ZoneId.systemDefault());
            StringBuilder sb = new StringBuilder();
            sb.append(record.getLevel().getName().charAt(0));
            sb.append(' ');
            FastFormatter.appendTwoDigits(sb, time.getHour());
            sb.append(':');
            FastFormatter.appendTwoDigits(sb, time.getMinute());
            sb.append(':');
            FastFormatter.appendTwoDigits(sb, time.getSecond());
            sb.append(' ');
            if (record.getSourceClassName() != null) {
                sb.append(record.getSourceClassName());
                if (record.getSourceMethodName() != null) {
                    sb.append(" ").append(record.getSourceMethodName());
                }
            } else {
                sb.append(record.getLoggerName());
            }
            sb.append(' ');
            Object[] params = record.getParameters();
            String message = params == null || params.length == 0 ? record.getMessage() : MessageFormat.format(record.getMessage(), params);
            sb.append(message);
            sb.append('\n');
            if (record.getThrown() != null) {
                sb.append(Throwables.getStackTraceAsString(record.getThrown()));
            }
            return sb.toString();
        }

        private static void appendTwoDigits(StringBuilder sb, int value) {
            if (value < 10) {
                sb.append('0');
            }
            sb.append(value);
        }
    }

    private static final class CustomFormatter
    extends Formatter {
        private CustomFormatter() {
        }

        @Override
        public synchronized String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            if (record.getSourceClassName() != null) {
                sb.append(record.getSourceClassName());
            } else if (record.getLoggerName() != null) {
                sb.append(record.getLoggerName());
            }
            if (record.getSourceMethodName() != null) {
                sb.append(" ");
                sb.append(record.getSourceMethodName());
            }
            sb.append(": ");
            sb.append(this.formatMessage(record));
            sb.append("\n");
            if (record.getThrown() != null) {
                sb.append(Throwables.getStackTraceAsString(record.getThrown()));
            }
            return sb.toString();
        }
    }

    private static final class ApiProxyLogFilter
    implements Filter {
        private ApiProxyLogFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            String name = record.getLoggerName();
            if (name == null) {
                return true;
            }
            if (name.startsWith("com.google.apphosting.runtime.")) {
                return false;
            }
            return !name.startsWith("com.google.net.") && !name.startsWith("com.google.common.stats.") && !name.startsWith("io.netty.") && !name.startsWith("io.grpc.netty.");
        }
    }
}

