/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.IStringConverterFactory;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.List;
import java.util.regex.Pattern;

public class ParameterFactory
implements IStringConverterFactory {
    private static final ImmutableMap<Class<?>, Class<? extends IStringConverter<?>>> CONVERTERS = ImmutableMap.of(Boolean.TYPE, BooleanConverter.class, Boolean.class, BooleanConverter.class);
    private static final Pattern SIMPLE_PARAM_PATTERN = Pattern.compile("^(--\\w+)$");

    @Override
    public <T> Class<? extends IStringConverter<T>> getConverter(Class<T> type) {
        return CONVERTERS.get(type);
    }

    public static ImmutableList<String> expandBooleanParams(List<String> args, Class<?> optionsClass) {
        ImmutableMap<String, String> expandedMap = ParameterFactory.expandedBooleanNamesFor(optionsClass);
        ImmutableList.Builder expanded = ImmutableList.builder();
        for (String arg : args) {
            if (SIMPLE_PARAM_PATTERN.matcher(arg = arg.trim()).matches() && expandedMap.containsKey(arg)) {
                arg = expandedMap.get(arg);
            }
            expanded.add(arg);
        }
        return expanded.build();
    }

    private static ImmutableMap<String, String> expandedBooleanNamesFor(Class<?> optionsClass) {
        ImmutableMap.Builder<String, String> mapBuilder = ImmutableMap.builder();
        for (Field field : optionsClass.getDeclaredFields()) {
            Class<?> fieldType;
            Parameter param = field.getAnnotation(Parameter.class);
            if (param == null || (fieldType = field.getType()) != Boolean.TYPE) continue;
            for (String name : param.names()) {
                mapBuilder.put(name, name + "=" + true);
                mapBuilder.put("--no" + name.substring(2), name + "=" + false);
            }
        }
        return mapBuilder.buildOrThrow();
    }

    public static class BooleanConverter
    implements IStringConverter<Boolean> {
        private static final Pattern TRUE_PATTERN = Pattern.compile("^(true|t|yes|y|1)$", 2);
        private static final Pattern FALSE_PATTERN = Pattern.compile("^(false|f|no|n|0)$", 2);

        @Override
        public Boolean convert(String value) {
            if (TRUE_PATTERN.matcher(value).matches()) {
                return true;
            }
            if (FALSE_PATTERN.matcher(value).matches()) {
                return false;
            }
            throw new ParameterException("Invalid boolean value: " + value);
        }
    }
}

