/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.runtime.AutoBuilder_ThreadGroupPool_Builder;
import com.google.apphosting.runtime.JavaRuntime;
import com.google.auto.value.AutoBuilder;
import com.google.common.flogger.GoogleLogger;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadGroupPool {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final ThreadGroup parentThreadGroup;
    private final String threadGroupNamePrefix;
    private final AtomicInteger threadGroupCounter;
    private final Queue<PoolEntry> waitingThreads;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final boolean ignoreDaemonThreads;

    public static Builder builder() {
        return new AutoBuilder_ThreadGroupPool_Builder();
    }

    public ThreadGroupPool(ThreadGroup parentThreadGroup, String threadGroupNamePrefix, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean ignoreDaemonThreads) {
        this.parentThreadGroup = parentThreadGroup;
        this.threadGroupNamePrefix = threadGroupNamePrefix;
        this.threadGroupCounter = new AtomicInteger(0);
        this.waitingThreads = new ConcurrentLinkedQueue<PoolEntry>();
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.ignoreDaemonThreads = ignoreDaemonThreads;
    }

    public void start(String threadName, Runnable runnable) throws InterruptedException {
        PoolEntry entry = this.waitingThreads.poll();
        if (entry == null) {
            entry = this.buildPoolEntry();
        }
        this.initThread(entry.getMainThread(), threadName);
        entry.runInMainThread(runnable);
    }

    private void removeThread(PoolEntry entry) {
        this.waitingThreads.remove(entry);
    }

    private void returnThread(PoolEntry entry) {
        this.initThread(entry.getMainThread(), "Idle");
        this.waitingThreads.add(entry);
    }

    public int waitingThreadCount() {
        return this.waitingThreads.size();
    }

    private void initThread(Thread thread, String threadName) {
        thread.setName(threadName);
        thread.setUncaughtExceptionHandler(null);
    }

    private PoolEntry buildPoolEntry() {
        String name = this.threadGroupNamePrefix + this.threadGroupCounter.getAndIncrement();
        ThreadGroup threadGroup = new ThreadGroup(this.parentThreadGroup, name){

            @Override
            public void uncaughtException(Thread th, Throwable ex) {
                ThreadGroupPool.this.uncaughtExceptionHandler.uncaughtException(th, ex);
            }
        };
        PoolEntry entry = new PoolEntry(threadGroup);
        entry.startMainThread();
        return entry;
    }

    public static CountDownLatch resetCurrentThread() throws InterruptedException {
        Thread thread = Thread.currentThread();
        if (thread instanceof RestartableThread) {
            return ((RestartableThread)thread).reset();
        }
        throw new IllegalStateException("Current thread is not a main request thread.");
    }

    private class PoolEntry
    implements Runnable {
        final ThreadGroup threadGroup;
        private final SynchronousQueue<Runnable> runnableQueue;
        private final RestartableThread mainThread;

        PoolEntry(ThreadGroup threadGroup) {
            this.threadGroup = threadGroup;
            this.runnableQueue = new SynchronousQueue();
            this.mainThread = new RestartableThread(threadGroup, this);
            this.mainThread.setDaemon(false);
        }

        void startMainThread() {
            this.mainThread.start();
        }

        Thread getMainThread() {
            return this.mainThread;
        }

        void runInMainThread(Runnable runnable) throws InterruptedException {
            if (!this.mainThread.isAlive()) {
                throw new IllegalStateException("Main thread is not running.");
            }
            this.runnableQueue.put(runnable);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Runnable runnable;
                    try {
                        runnable = this.runnableQueue.take();
                    }
                    catch (InterruptedException ex) {
                        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withCause(ex)).log("Interrupted while waiting for next Runnable");
                        ThreadGroupPool.this.removeThread(this);
                        return;
                    }
                    runnable.run();
                    if (this.otherThreadsLeftInThreadGroup()) {
                        return;
                    }
                    if (Thread.interrupted()) {
                        ((GoogleLogger.Api)logger.atInfo()).log("Not reusing %s, interrupt bit was set.", this);
                        return;
                    }
                    ThreadGroupPool.this.returnThread(this);
                }
            }
            catch (Throwable th) {
                JavaRuntime.killCloneIfSeriousException(th);
                throw th;
            }
        }

        private boolean otherThreadsLeftInThreadGroup() {
            List<Thread> threads = this.threadsInThreadGroup();
            boolean otherThreads = false;
            if (threads.size() > 1) {
                for (Thread thread : threads) {
                    if (thread == Thread.currentThread() || ThreadGroupPool.this.ignoreDaemonThreads && thread.isDaemon()) continue;
                    Throwable th = new Throwable();
                    th.setStackTrace(thread.getStackTrace());
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(th)).log("Extra thread left running: %s", thread);
                    otherThreads = true;
                }
            }
            return otherThreads;
        }

        private List<Thread> threadsInThreadGroup() {
            int threadCount;
            Thread[] threads = new Thread[50];
            while ((threadCount = this.threadGroup.enumerate(threads, true)) == threads.length) {
                threads = new Thread[threads.length * 2];
            }
            return Arrays.asList(threads).subList(0, threadCount);
        }
    }

    private static final class RestartableThread
    extends Thread {
        private final Object lock = new Object();
        private CountDownLatch latch;

        RestartableThread(ThreadGroup threadGroup, Runnable runnable) {
            super(threadGroup, runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CountDownLatch reset() {
            Object object = this.lock;
            synchronized (object) {
                this.latch = new CountDownLatch(1);
                return this.latch;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() {
            Object object = this.lock;
            synchronized (object) {
                if (this.latch != null) {
                    this.latch.countDown();
                    this.latch = null;
                    return;
                }
            }
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Thread.State getState() {
            Object object = this.lock;
            synchronized (object) {
                if (this.latch != null) {
                    return Thread.State.NEW;
                }
            }
            return super.getState();
        }
    }

    @AutoBuilder
    public static abstract class Builder {
        public abstract Builder setParentThreadGroup(ThreadGroup var1);

        public abstract Builder setThreadGroupNamePrefix(String var1);

        public abstract Builder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler var1);

        public abstract Builder setIgnoreDaemonThreads(boolean var1);

        public abstract ThreadGroupPool build();
    }
}

