/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.CloudTraceContext;
import com.google.apphosting.base.protos.TraceId;
import com.google.apphosting.base.protos.TracePb;
import com.google.protobuf.ByteString;

public class TraceContextHelper {
    private static final long INVALID_SPAN_ID = 0L;
    private static final long MASK_TRACE_ENABLED = 1L;
    private static final long MASK_STACK_TRACE_ENABLED = 2L;
    private static final String OPTIONS_SEPARATOR_AND_VARIABLE = ";o=";
    private static final int TRACE_LENGTH = 32;

    static CloudTraceContext toObject(TracePb.TraceContextProto proto) {
        return new CloudTraceContext(proto.getTraceId().toByteArray(), 0L, proto.getSpanId(), (long)proto.getTraceMask());
    }

    static TracePb.TraceContextProto toProto2(CloudTraceContext context) {
        return TracePb.TraceContextProto.newBuilder().setTraceId(ByteString.copyFrom(context.getTraceId())).setSpanId(context.getSpanId()).setTraceMask((int)context.getTraceMask()).build();
    }

    static boolean needsTrace(TracePb.TraceContextProto contextProto) {
        return TraceContextHelper.needsTrace(contextProto.getTraceMask());
    }

    static boolean needsTrace(long traceMask) {
        return (traceMask & 1L) != 0L;
    }

    private static boolean needsStackTrace(long traceMask) {
        return (traceMask & 2L) != 0L;
    }

    static boolean needsStackTrace(TracePb.TraceContextProto contextProto) {
        return TraceContextHelper.needsStackTrace(contextProto.getTraceMask());
    }

    static boolean isStackTraceEnabled(CloudTraceContext context) {
        return TraceContextHelper.needsStackTrace(context.getTraceMask());
    }

    public static TracePb.TraceContextProto parseTraceContextHeader(String traceContextHeader) {
        TracePb.TraceContextProto.Builder protoBuilder = TracePb.TraceContextProto.newBuilder();
        int slashStart = traceContextHeader.indexOf(47);
        int semiStart = traceContextHeader.indexOf(59);
        int traceEnd = slashStart >= 0 ? slashStart : (semiStart >= 0 ? semiStart : traceContextHeader.length());
        String traceId = traceContextHeader.substring(0, traceEnd);
        protoBuilder.setTraceId(TraceContextHelper.parseTraceId(traceId).toByteString());
        int optionsStart = traceContextHeader.lastIndexOf(OPTIONS_SEPARATOR_AND_VARIABLE);
        if (optionsStart > 0 && (optionsStart += OPTIONS_SEPARATOR_AND_VARIABLE.length()) < traceContextHeader.length()) {
            String options = traceContextHeader.substring(optionsStart);
            protoBuilder.setTraceMask(Integer.parseUnsignedInt(options));
        }
        if (slashStart > 0) {
            int spanIdEnd;
            int n = spanIdEnd = semiStart > slashStart ? semiStart : traceContextHeader.length();
            if (slashStart + 1 < spanIdEnd) {
                String spanId = traceContextHeader.substring(slashStart + 1, spanIdEnd);
                protoBuilder.setSpanId(Long.parseUnsignedLong(spanId));
            }
        }
        return protoBuilder.build();
    }

    private static TraceId.TraceIdProto parseTraceId(String traceId) {
        if (traceId.length() < 32) {
            throw new NumberFormatException("Invalid TRACE ID: length too short");
        }
        String traceIdHi = traceId.substring(0, 16);
        String traceIdLo = traceId.substring(16, 32);
        return TraceId.TraceIdProto.newBuilder().setHi(Long.parseUnsignedLong(traceIdHi, 16)).setLo(Long.parseUnsignedLong(traceIdLo, 16)).build();
    }

    private TraceContextHelper() {
    }
}

