/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.CloudTraceContext;
import com.google.apphosting.base.protos.LabelsProtos;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.base.protos.SpanDetails;
import com.google.apphosting.base.protos.SpanId;
import com.google.apphosting.base.protos.SpanKindOuterClass;
import com.google.apphosting.base.protos.TraceEvents;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.TraceContextHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.flogger.GoogleLogger;
import com.google.common.primitives.Ints;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class TraceWriter {
    @VisibleForTesting
    public static final int DEFAULT_MAX_TRACE = 1000;
    @VisibleForTesting
    public static final String MAX_TRACE_PROPERTY = "com.google.appengine.max.trace.in.background";
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    static final int MAX_STACK_DEPTH = 128;
    static final int MAX_DICTIONARY_SIZE = 1024;
    private final CloudTraceContext context;
    private final MutableUpResponse upResponse;
    private final TraceEvents.TraceEventsProto.Builder traceEventsBuilder;
    private final Map<Long, TraceEvents.SpanEventsProto.Builder> spanEventsMap = Maps.newConcurrentMap();
    private final Set<Long> dictionaryKeys = Sets.newHashSet();
    private final int maxTraceSize;

    public TraceWriter(CloudTraceContext context, MutableUpResponse upResponse) {
        this(context, upResponse, false);
    }

    private TraceWriter(CloudTraceContext context, MutableUpResponse upResponse, boolean background) {
        this.context = context;
        this.upResponse = upResponse;
        this.traceEventsBuilder = TraceEvents.TraceEventsProto.newBuilder();
        if (background) {
            String maxTraceProperty = System.getProperty(MAX_TRACE_PROPERTY);
            Integer maxTraceValue = maxTraceProperty == null ? null : Ints.tryParse(maxTraceProperty);
            this.maxTraceSize = maxTraceValue == null ? 1000 : maxTraceValue;
        } else {
            this.maxTraceSize = Integer.MAX_VALUE;
        }
    }

    @Nullable
    public static TraceWriter getTraceWriterForRequest(RuntimePb.UPRequest upRequest, MutableUpResponse upResponse) {
        if (!TraceContextHelper.needsTrace(upRequest.getTraceContext())) {
            return null;
        }
        CloudTraceContext traceContext = TraceContextHelper.toObject(upRequest.getTraceContext()).createChildContext();
        boolean background = upRequest.getRequestType().equals(RuntimePb.UPRequest.RequestType.BACKGROUND);
        return new TraceWriter(traceContext, upResponse, background);
    }

    public CloudTraceContext getTraceContext() {
        return this.context;
    }

    private static String createSpanName(String packageName, String methodName) {
        return '/' + packageName + '.' + methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TraceEvents.SpanEventsProto.Builder createSpanEvents(CloudTraceContext context, String spanName, SpanKindOuterClass.SpanKind spanKind) {
        TraceEvents.SpanEventsProto.Builder spanEvents;
        TraceEvents.StartSpanProto.Builder startSpan = TraceEvents.StartSpanProto.newBuilder().setKind(spanKind).setName(spanName).setParentSpanId(SpanId.SpanIdProto.newBuilder().setId(context.getParentSpanId()));
        TraceEvents.SpanEventProto spanEvent = TraceEvents.SpanEventProto.newBuilder().setTimestamp(TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis())).setStartSpan(startSpan).build();
        TraceEvents.TraceEventsProto.Builder builder = this.traceEventsBuilder;
        synchronized (builder) {
            spanEvents = this.addSpanEventsBuilder();
            spanEvents.setSpanId(SpanId.SpanIdProto.newBuilder().setId(context.getSpanId())).addEvent(spanEvent);
        }
        return spanEvents;
    }

    public void startRequestSpan(String name) {
        TraceEvents.SpanEventsProto.Builder spanEvents = this.createSpanEvents(this.context, name, SpanKindOuterClass.SpanKind.RPC_SERVER);
        this.spanEventsMap.put(this.context.getSpanId(), spanEvents);
    }

    public CloudTraceContext startApiSpan(@Nullable CloudTraceContext parentContext, String packageName, String methodName) {
        CloudTraceContext childContext = parentContext != null ? parentContext.createChildContext() : this.context.createChildContext();
        TraceEvents.SpanEventsProto.Builder spanEvents = this.createSpanEvents(childContext, TraceWriter.createSpanName(packageName, methodName), SpanKindOuterClass.SpanKind.RPC_CLIENT);
        this.spanEventsMap.put(childContext.getSpanId(), spanEvents);
        return childContext;
    }

    public CloudTraceContext startChildSpan(CloudTraceContext parentContext, String name) {
        CloudTraceContext childContext = parentContext.createChildContext();
        TraceEvents.SpanEventsProto.Builder spanEvents = this.createSpanEvents(childContext, name, SpanKindOuterClass.SpanKind.SPAN_DEFAULT);
        this.spanEventsMap.put(childContext.getSpanId(), spanEvents);
        return childContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(CloudTraceContext context, String key, String value) {
        TraceEvents.SpanEventsProto.Builder currentSpanEvents = this.spanEventsMap.get(context.getSpanId());
        if (currentSpanEvents == null) {
            ((GoogleLogger.Api)logger.atSevere()).log("Span events must exist before setLabel is invoked.");
            return;
        }
        LabelsProtos.LabelProto.Builder label = LabelsProtos.LabelProto.newBuilder().setKey(key).setStrValue(value);
        LabelsProtos.LabelsProto.Builder labels = LabelsProtos.LabelsProto.newBuilder().addLabel(label);
        TraceEvents.AnnotateSpanProto.Builder annotateSpan = TraceEvents.AnnotateSpanProto.newBuilder().setLabels(labels);
        TraceEvents.TraceEventsProto.Builder builder = this.traceEventsBuilder;
        synchronized (builder) {
            currentSpanEvents.addEventBuilder().setTimestamp(TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis())).setAnnotateSpan(annotateSpan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStackTrace(CloudTraceContext context, StackTraceElement[] stackTrace) {
        TraceEvents.SpanEventsProto.Builder currentSpanEvents = this.spanEventsMap.get(context.getSpanId());
        if (currentSpanEvents == null) {
            ((GoogleLogger.Api)logger.atSevere()).log("Span events must exist before addStackTrace is invoked.");
            return;
        }
        SpanDetails.StackTraceDetails.Builder stackTraceDetails = SpanDetails.StackTraceDetails.newBuilder();
        int stackDepth = 0;
        long hashCode = 17L;
        for (StackTraceElement element : stackTrace) {
            if (element.getFileName() == null || element.getLineNumber() <= 0) continue;
            hashCode = 31L * hashCode + (long)element.hashCode();
            stackTraceDetails.addStackFrameBuilder().setClassName(element.getClassName()).setMethodName(element.getMethodName()).setLineNumber(element.getLineNumber()).setFileName(element.getFileName());
            if (++stackDepth >= 128) break;
        }
        if (stackDepth == 0) {
            return;
        }
        SpanDetails.SpanDetailsProto.Builder spanDetails = SpanDetails.SpanDetailsProto.newBuilder().setStackTraceHashId(hashCode);
        TraceEvents.AnnotateSpanProto.Builder annotateSpan = TraceEvents.AnnotateSpanProto.newBuilder().setSpanDetails(spanDetails);
        TraceEvents.TraceEventsProto.Builder builder = this.traceEventsBuilder;
        synchronized (builder) {
            if (!this.dictionaryKeys.contains(hashCode)) {
                if (this.dictionaryKeys.size() >= 1024) {
                    return;
                }
                this.dictionaryKeys.add(hashCode);
                this.addEventDictionaryBuilder().setKey(hashCode).setStackTraceValue(stackTraceDetails);
            }
            currentSpanEvents.addEventBuilder().setTimestamp(TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis())).setAnnotateSpan(annotateSpan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSpan(CloudTraceContext context) {
        TraceEvents.SpanEventsProto.Builder currentSpanEvents = this.spanEventsMap.remove(context.getSpanId());
        if (currentSpanEvents == null) {
            ((GoogleLogger.Api)logger.atSevere()).log("Span events must exist before endSpan is invoked.");
            return;
        }
        TraceEvents.EndSpanProto.Builder endSpan = TraceEvents.EndSpanProto.newBuilder();
        TraceEvents.TraceEventsProto.Builder builder = this.traceEventsBuilder;
        synchronized (builder) {
            currentSpanEvents.addEventBuilder().setTimestamp(TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis())).setEndSpan(endSpan);
            currentSpanEvents.setFullSpan(true);
        }
    }

    public void endApiSpan(CloudTraceContext context) {
        this.endSpan(context);
    }

    public void endRequestSpan() {
        this.endSpan(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushTrace() {
        TraceEvents.TraceEventsProto.Builder builder = this.traceEventsBuilder;
        synchronized (builder) {
            try {
                this.upResponse.setSerializedTrace(this.traceEventsBuilder.build().toByteString());
            }
            catch (Exception e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).log("Exception in flushTrace");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TraceEvents.SpanEventsProto.Builder addSpanEventsBuilder() {
        TraceEvents.TraceEventsProto.Builder builder = this.traceEventsBuilder;
        synchronized (builder) {
            if (this.traceEventsBuilder.getSpanEventsCount() < this.maxTraceSize) {
                return this.traceEventsBuilder.addSpanEventsBuilder();
            }
            return TraceEvents.SpanEventsProto.newBuilder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TraceEvents.EventDictionaryEntry.Builder addEventDictionaryBuilder() {
        TraceEvents.TraceEventsProto.Builder builder = this.traceEventsBuilder;
        synchronized (builder) {
            if (this.traceEventsBuilder.getDictionaryEntriesCount() < this.maxTraceSize) {
                return this.traceEventsBuilder.addDictionaryEntriesBuilder();
            }
            return TraceEvents.EventDictionaryEntry.newBuilder();
        }
    }
}

