/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.grpc;

import com.google.apphosting.runtime.anyrpc.AnyRpcCallback;
import com.google.apphosting.runtime.grpc.GrpcClientContext;
import com.google.protobuf.Message;
import io.grpc.stub.StreamObserver;

public class CallbackStreamObserver<ResponseT extends Message>
implements StreamObserver<ResponseT> {
    private final GrpcClientContext clientContext;
    private final AnyRpcCallback<ResponseT> anyRpcCallback;

    private CallbackStreamObserver(GrpcClientContext clientContext, AnyRpcCallback<ResponseT> anyRpcCallback) {
        this.clientContext = clientContext;
        this.anyRpcCallback = anyRpcCallback;
    }

    public static <ResponseT extends Message> CallbackStreamObserver<ResponseT> of(GrpcClientContext clientContext, AnyRpcCallback<ResponseT> anyRpcCallback) {
        return new CallbackStreamObserver<ResponseT>(clientContext, anyRpcCallback);
    }

    @Override
    public void onNext(ResponseT grpcResponse) {
        this.anyRpcCallback.success(grpcResponse);
    }

    @Override
    public void onError(Throwable throwable) {
        this.clientContext.setException(throwable);
        this.anyRpcCallback.failure();
    }

    @Override
    public void onCompleted() {
    }
}

