/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.grpc;

import com.google.apphosting.base.protos.AppinfoPb;
import com.google.apphosting.base.protos.CloneControllerGrpc;
import com.google.apphosting.base.protos.ClonePb;
import com.google.apphosting.base.protos.EmptyMessage;
import com.google.apphosting.base.protos.EvaluationRuntimeGrpc;
import com.google.apphosting.base.protos.ModelClonePb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.anyrpc.AnyRpcPlugin;
import com.google.apphosting.runtime.anyrpc.CloneControllerServerInterface;
import com.google.apphosting.runtime.anyrpc.EvaluationRuntimeServerInterface;
import com.google.apphosting.runtime.grpc.GrpcServerContext;
import com.google.common.base.Preconditions;
import io.grpc.BindableService;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Optional;

public class GrpcPlugin
extends AnyRpcPlugin {
    private static final int MAX_REQUEST_BODY_SIZE = 0x3200000;
    private Optional<Integer> optionalServerPort = Optional.empty();
    private Server server;

    @Override
    public void initialize(int serverPort) {
        if (serverPort != 0) {
            Preconditions.checkArgument(serverPort > 0, "Server port cannot be negative: %s", serverPort);
            this.optionalServerPort = Optional.of(serverPort);
        }
    }

    @Override
    public void startServer(EvaluationRuntimeServerInterface evaluationRuntime, CloneControllerServerInterface cloneController) {
        if (!this.optionalServerPort.isPresent()) {
            throw new IllegalStateException("No server port has been specified");
        }
        EvaluationRuntimeServer evaluationRuntimeServer = new EvaluationRuntimeServer(evaluationRuntime);
        CloneControllerServer cloneControllerServer = new CloneControllerServer(cloneController);
        ExceptionInterceptor exceptionInterceptor = new ExceptionInterceptor();
        ServerServiceDefinition evaluationRuntimeService = ServerInterceptors.intercept((BindableService)evaluationRuntimeServer, exceptionInterceptor);
        ServerServiceDefinition cloneControllerService = ServerInterceptors.intercept((BindableService)cloneControllerServer, exceptionInterceptor);
        this.server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort(this.optionalServerPort.get()).maxInboundMessageSize(0x3200000).addService(evaluationRuntimeService)).addService(cloneControllerService)).build();
        try {
            this.server.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getServerPort() {
        return this.optionalServerPort.get();
    }

    @Override
    public boolean serverStarted() {
        return this.server != null && !this.server.isShutdown() && !this.server.isTerminated();
    }

    @Override
    public void blockUntilShutdown() {
        try {
            this.server.awaitTermination();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stopServer() {
        if (this.serverStarted()) {
            this.server.shutdown();
        }
    }

    @Override
    public void shutdown() {
        this.stopServer();
    }

    @Override
    public Runnable traceContextPropagating(Runnable runnable) {
        return runnable;
    }

    private static Status statusFromException(RuntimeException e) {
        if (e instanceof StatusRuntimeException) {
            return ((StatusRuntimeException)e).getStatus();
        }
        String description = e.toString();
        StackTraceElement[] stack = e.getStackTrace();
        if (stack.length > 0) {
            description = description + ", at " + stack[0];
        }
        return Status.INTERNAL.withDescription(description).withCause(e);
    }

    private static class CloneControllerServer
    extends CloneControllerGrpc.CloneControllerImplBase {
        private final CloneControllerServerInterface cloneController;

        CloneControllerServer(CloneControllerServerInterface cloneController) {
            this.cloneController = cloneController;
        }

        @Override
        public void waitForSandbox(EmptyMessage emptyMessage, StreamObserver<EmptyMessage> streamObserver) {
            this.cloneController.waitForSandbox(new EmptyGrpcServerContext(streamObserver), EmptyMessage.getDefaultInstance());
        }

        @Override
        public void applyCloneSettings(ClonePb.CloneSettings cloneSettings, StreamObserver<EmptyMessage> streamObserver) {
            this.cloneController.applyCloneSettings(new EmptyGrpcServerContext(streamObserver), cloneSettings);
        }

        @Override
        public void sendDeadline(ModelClonePb.DeadlineInfo deadlineInfo, StreamObserver<EmptyMessage> streamObserver) {
            this.cloneController.sendDeadline(new EmptyGrpcServerContext(streamObserver), deadlineInfo);
        }

        @Override
        public void getPerformanceData(ModelClonePb.PerformanceDataRequest request, StreamObserver<ClonePb.PerformanceData> streamObserver) {
            GrpcServerContext<ClonePb.PerformanceData> serverContext = new GrpcServerContext<ClonePb.PerformanceData>(ClonePb.PerformanceData.class, streamObserver);
            this.cloneController.getPerformanceData(serverContext, request);
        }

        @Override
        public void updateActiveBreakpoints(ClonePb.CloudDebuggerBreakpoints cloudDebuggerBreakpoints, StreamObserver<ClonePb.CloudDebuggerBreakpoints> streamObserver) {
            GrpcServerContext<ClonePb.CloudDebuggerBreakpoints> serverContext = new GrpcServerContext<ClonePb.CloudDebuggerBreakpoints>(ClonePb.CloudDebuggerBreakpoints.class, streamObserver);
            this.cloneController.updateActiveBreakpoints(serverContext, cloudDebuggerBreakpoints);
        }

        @Override
        public void getDebuggeeInfo(ClonePb.DebuggeeInfoRequest request, StreamObserver<ClonePb.DebuggeeInfoResponse> streamObserver) {
            GrpcServerContext<ClonePb.DebuggeeInfoResponse> serverContext = new GrpcServerContext<ClonePb.DebuggeeInfoResponse>(ClonePb.DebuggeeInfoResponse.class, streamObserver);
            this.cloneController.getDebuggeeInfo(serverContext, request);
        }
    }

    private static class EvaluationRuntimeServer
    extends EvaluationRuntimeGrpc.EvaluationRuntimeImplBase {
        private final EvaluationRuntimeServerInterface evaluationRuntime;

        EvaluationRuntimeServer(EvaluationRuntimeServerInterface evaluationRuntime) {
            this.evaluationRuntime = evaluationRuntime;
        }

        @Override
        public void handleRequest(RuntimePb.UPRequest request, StreamObserver<RuntimePb.UPResponse> streamObserver) {
            GrpcServerContext<RuntimePb.UPResponse> serverContext = new GrpcServerContext<RuntimePb.UPResponse>(RuntimePb.UPResponse.class, streamObserver);
            this.evaluationRuntime.handleRequest(serverContext, request);
        }

        @Override
        public void addAppVersion(AppinfoPb.AppInfo appInfo, StreamObserver<EmptyMessage> streamObserver) {
            this.evaluationRuntime.addAppVersion(new EmptyGrpcServerContext(streamObserver), appInfo);
        }

        @Override
        public void deleteAppVersion(AppinfoPb.AppInfo appInfo, StreamObserver<EmptyMessage> streamObserver) {
            this.evaluationRuntime.deleteAppVersion(new EmptyGrpcServerContext(streamObserver), appInfo);
        }
    }

    private static class ExceptionInterceptor
    implements ServerInterceptor {
        private ExceptionInterceptor() {
        }

        public <RequestT, ResponseT> ServerCall.Listener<RequestT> interceptCall(final ServerCall<RequestT, ResponseT> call, Metadata metadata, ServerCallHandler<RequestT, ResponseT> next) {
            ServerCall.Listener<RequestT> nextListener = next.startCall(call, metadata);
            return new ForwardingServerCallListener.SimpleForwardingServerCallListener<RequestT>(nextListener){

                @Override
                public void onHalfClose() {
                    try {
                        super.onHalfClose();
                    }
                    catch (RuntimeException e) {
                        call.close(GrpcPlugin.statusFromException(e), new Metadata());
                    }
                }
            };
        }
    }

    private static class EmptyGrpcServerContext
    extends GrpcServerContext<EmptyMessage> {
        EmptyGrpcServerContext(StreamObserver<EmptyMessage> streamObserver) {
            super(EmptyMessage.class, streamObserver);
        }
    }
}

