/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.http;

import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.base.protos.Status;
import com.google.apphosting.base.protos.api.RemoteApiPb;
import com.google.apphosting.runtime.anyrpc.APIHostClientInterface;
import com.google.apphosting.runtime.anyrpc.AnyRpcCallback;
import com.google.apphosting.runtime.anyrpc.AnyRpcClientContext;
import com.google.apphosting.runtime.http.AutoValue_HttpApiHostClient_Config;
import com.google.apphosting.runtime.http.JdkHttpApiHostClient;
import com.google.apphosting.runtime.http.JettyHttpApiHostClient;
import com.google.apphosting.utils.runtime.ApiProxyUtils;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.GoogleLogger;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.UninitializedMessageException;
import java.io.IOException;
import java.util.Optional;
import java.util.OptionalInt;

abstract class HttpApiHostClient
implements APIHostClientInterface {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    static final double DEFAULT_EXTRA_TIMEOUT_SECONDS = 2.0;
    static final ImmutableMap<String, String> HEADERS = ImmutableMap.of("X-Google-RPC-Service-Endpoint", "app-engine-apis", "X-Google-RPC-Service-Method", "/VMRemoteAPI.CallRemoteAPI");
    static final String CONTENT_TYPE_VALUE = "application/octet-stream";
    static final String REQUEST_ENDPOINT = "/rpc_http";
    static final String DEADLINE_HEADER = "X-Google-RPC-Service-Deadline";
    private static final int UNKNOWN_ERROR_CODE = 1;
    static final int MAX_PAYLOAD = 0x3200000;
    static final int EXTRA_CONTENT_BYTES = 4096;
    private final Config config;

    HttpApiHostClient(Config config) {
        this.config = config;
    }

    Config config() {
        return this.config;
    }

    static HttpApiHostClient create(String url, Config config) {
        if (System.getenv("APPENGINE_API_CALLS_USING_JDK_CLIENT") != null) {
            ((GoogleLogger.Api)logger.atInfo()).log("Using JDK HTTP client for API calls");
            return JdkHttpApiHostClient.create(url, config);
        }
        return JettyHttpApiHostClient.create(url, config);
    }

    @Override
    public Context newClientContext() {
        return new Context();
    }

    static void communicationFailure(Context context, String errorDetail, AnyRpcCallback<RuntimePb.APIResponse> callback, Throwable cause) {
        context.setApplicationError(0);
        context.setErrorDetail(errorDetail);
        context.setStatus(Status.StatusProto.newBuilder().setSpace("RPC").setCode(1).setCanonicalCode(1).setMessage(errorDetail).build());
        context.setException(cause);
        callback.failure();
    }

    static void timeout(AnyRpcCallback<RuntimePb.APIResponse> callback) {
        RuntimePb.APIResponse apiResponse = RuntimePb.APIResponse.newBuilder().setError(13).setRpcError(RuntimePb.APIResponse.RpcError.DEADLINE_EXCEEDED).build();
        callback.success(apiResponse);
    }

    static void cancelled(AnyRpcCallback<RuntimePb.APIResponse> callback) {
        RuntimePb.APIResponse apiResponse = RuntimePb.APIResponse.newBuilder().setError(11).build();
        callback.success(apiResponse);
    }

    @Override
    public void call(AnyRpcClientContext ctx, RuntimePb.APIRequest req, AnyRpcCallback<RuntimePb.APIResponse> cb) {
        Context context = (Context)ctx;
        ByteString payload = req.getPb();
        if (payload.size() > 0x3200000) {
            HttpApiHostClient.requestTooBig(cb);
            return;
        }
        RemoteApiPb.Request requestPb = RemoteApiPb.Request.newBuilder().setServiceName(req.getApiPackage()).setMethod(req.getCall()).setRequest(payload).setRequestId(req.getSecurityTicket()).setTraceContext(req.getTraceContext().toByteString()).build();
        this.send(requestPb.toByteArray(), context, cb);
    }

    static void receivedResponse(byte[] responseBytes, int responseLength, Context context, AnyRpcCallback<RuntimePb.APIResponse> callback) {
        RemoteApiPb.Response responsePb;
        ((GoogleLogger.Api)logger.atFine()).log("Response size %d", responseLength);
        CodedInputStream input = CodedInputStream.newInstance(responseBytes, 0, responseLength);
        try {
            responsePb = RemoteApiPb.Response.parseFrom(input, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        }
        catch (UninitializedMessageException | IOException e) {
            String errorDetail = "Failed to parse RemoteApiPb.Response";
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("%s", errorDetail);
            HttpApiHostClient.communicationFailure(context, errorDetail, callback, e);
            return;
        }
        if (responsePb.hasApplicationError()) {
            RemoteApiPb.ApplicationError applicationError = responsePb.getApplicationError();
            context.setApplicationError(applicationError.getCode());
            context.setErrorDetail(applicationError.getDetail());
            context.setStatus(Status.StatusProto.getDefaultInstance());
            callback.failure();
            return;
        }
        RuntimePb.APIResponse apiResponse = RuntimePb.APIResponse.newBuilder().setError(ApiProxyUtils.remoteApiErrorToApiResponseError(responsePb).getNumber()).setPb(responsePb.getResponse()).build();
        callback.success(apiResponse);
    }

    abstract void send(byte[] var1, Context var2, AnyRpcCallback<RuntimePb.APIResponse> var3);

    private static void requestTooBig(AnyRpcCallback<RuntimePb.APIResponse> cb) {
        RuntimePb.APIResponse apiResponse = RuntimePb.APIResponse.newBuilder().setError(5).build();
        cb.success(apiResponse);
    }

    static void responseTooBig(AnyRpcCallback<RuntimePb.APIResponse> cb) {
        RuntimePb.APIResponse apiResponse = RuntimePb.APIResponse.newBuilder().setError(10).build();
        cb.success(apiResponse);
    }

    static class Context
    implements AnyRpcClientContext {
        private final long startTimeMillis;
        private int applicationError;
        private String errorDetail;
        private Status.StatusProto status;
        private Throwable exception;
        private Optional<Long> deadlineNanos = Optional.empty();

        Context() {
            this.startTimeMillis = System.currentTimeMillis();
        }

        @Override
        public int getApplicationError() {
            return this.applicationError;
        }

        void setApplicationError(int applicationError) {
            this.applicationError = applicationError;
        }

        @Override
        public String getErrorDetail() {
            return this.errorDetail;
        }

        void setErrorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }

        void setException(Throwable exception) {
            this.exception = exception;
        }

        @Override
        public long getStartTimeMillis() {
            return this.startTimeMillis;
        }

        @Override
        public Status.StatusProto getStatus() {
            return this.status;
        }

        void setStatus(Status.StatusProto status) {
            this.status = status;
        }

        @Override
        public void setDeadline(double seconds) {
            Preconditions.checkArgument(seconds >= 0.0);
            double nanos = 1.0E9 * seconds;
            Preconditions.checkArgument(nanos <= 9.223372036854776E18);
            this.deadlineNanos = Optional.of((long)nanos);
        }

        Optional<Long> getDeadlineNanos() {
            return this.deadlineNanos;
        }

        @Override
        public void startCancel() {
            ((GoogleLogger.Api)logger.atWarning()).log("Canceling HTTP API call has no effect");
        }
    }

    @AutoValue
    static abstract class Config {
        Config() {
        }

        abstract double extraTimeoutSeconds();

        abstract OptionalInt maxConnectionsPerDestination();

        abstract boolean ignoreContentLength();

        abstract boolean treatClosedChannelAsCancellation();

        static Builder builder() {
            return new AutoValue_HttpApiHostClient_Config.Builder().setExtraTimeoutSeconds(2.0).setIgnoreContentLength(false).setTreatClosedChannelAsCancellation(false);
        }

        abstract Builder toBuilder();

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setMaxConnectionsPerDestination(OptionalInt var1);

            abstract Builder setExtraTimeoutSeconds(double var1);

            abstract Builder setIgnoreContentLength(boolean var1);

            abstract Builder setTreatClosedChannelAsCancellation(boolean var1);

            abstract Config build();
        }
    }
}

