/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.http;

import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.anyrpc.AnyRpcCallback;
import com.google.apphosting.runtime.http.HttpApiHostClient;
import com.google.common.flogger.GoogleLogger;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class JdkHttpApiHostClient
extends HttpApiHostClient {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final int MAX_LENGTH = 52432896;
    private static final AtomicInteger threadCount = new AtomicInteger();
    private final URL url;
    private final Executor executor;

    private JdkHttpApiHostClient(HttpApiHostClient.Config config, URL url, Executor executor) {
        super(config);
        this.url = url;
        this.executor = executor;
    }

    static JdkHttpApiHostClient create(String url, HttpApiHostClient.Config config) {
        try {
            ThreadFactory factory = runnable -> {
                Thread t = new Thread(JdkHttpApiHostClient.rootThreadGroup(), runnable);
                t.setName("JdkHttp-" + threadCount.incrementAndGet());
                t.setDaemon(true);
                return t;
            };
            ExecutorService executor = Executors.newCachedThreadPool(factory);
            return new JdkHttpApiHostClient(config, new URL(url), executor);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ThreadGroup rootThreadGroup() {
        ThreadGroup parent;
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while ((parent = group.getParent()) != null) {
            group = parent;
        }
        return group;
    }

    @Override
    void send(byte[] requestBytes, HttpApiHostClient.Context context, AnyRpcCallback<RuntimePb.APIResponse> callback) {
        this.executor.execute(() -> this.doSend(requestBytes, context, callback));
    }

    private void doSend(byte[] requestBytes, HttpApiHostClient.Context context, AnyRpcCallback<RuntimePb.APIResponse> callback) {
        block30: {
            try {
                HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
                connection.setDoOutput(true);
                HEADERS.forEach(connection::addRequestProperty);
                connection.addRequestProperty("Content-Type", "application/octet-stream");
                if (context.getDeadlineNanos().isPresent()) {
                    double deadlineSeconds = (double)context.getDeadlineNanos().get().longValue() / 1.0E9;
                    connection.addRequestProperty("X-Google-RPC-Service-Deadline", Double.toString(deadlineSeconds));
                    int deadlineMillis = Ints.saturatedCast(Math.max(1L, context.getDeadlineNanos().get() / 1000000L));
                    connection.setReadTimeout(deadlineMillis);
                }
                connection.setFixedLengthStreamingMode(requestBytes.length);
                connection.setRequestMethod("POST");
                try (OutputStream out = connection.getOutputStream();){
                    out.write(requestBytes);
                }
                if (connection.getResponseCode() != 200) break block30;
                int length = connection.getContentLength();
                if (length > 52432896) {
                    connection.getInputStream().close();
                    JdkHttpApiHostClient.responseTooBig(callback);
                    break block30;
                }
                byte[] buffer = new byte[length];
                try (InputStream in = connection.getInputStream();){
                    ByteStreams.readFully(in, buffer);
                    JdkHttpApiHostClient.receivedResponse(buffer, length, context, callback);
                }
            }
            catch (SocketTimeoutException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("SocketTimeoutException");
                JdkHttpApiHostClient.timeout(callback);
            }
            catch (IOException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("IOException");
                JdkHttpApiHostClient.communicationFailure(context, e.toString(), callback, e);
            }
        }
    }

    @Override
    public void enable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disable() {
        throw new UnsupportedOperationException();
    }
}

