/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty9;

import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.MutableUpResponse;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;

public class RpcEndPoint
implements EndPoint {
    private final long created = System.currentTimeMillis();
    private final RuntimePb.UPRequest upRequest;
    private final MutableUpResponse upResponse;
    private volatile boolean closed;
    private volatile Connection connection;
    private volatile long idleTimeout;

    public RpcEndPoint(RuntimePb.UPRequest upRequest, MutableUpResponse upResponse) {
        this.upRequest = upRequest;
        this.upResponse = upResponse;
        upResponse.setError(0);
    }

    public RuntimePb.UPRequest getUpRequest() {
        return this.upRequest;
    }

    public MutableUpResponse getUpResponse() {
        return this.upResponse;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return InetSocketAddress.createUnresolved("0.0.0.0", 0);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return InetSocketAddress.createUnresolved(this.upRequest.getRequest().getUserIp(), 0);
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public long getCreatedTimeStamp() {
        return this.created;
    }

    @Override
    public void shutdownOutput() {
        this.closed = true;
    }

    @Override
    public boolean isOutputShutdown() {
        return this.closed;
    }

    @Override
    public boolean isInputShutdown() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public int fill(ByteBuffer buffer) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean flush(ByteBuffer ... buffer) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getTransport() {
        return this;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Override
    public void fillInterested(Callback callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryFillInterested(Callback callback) {
        return false;
    }

    @Override
    public void write(Callback callback, ByteBuffer ... buffers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onClose() {
    }

    @Override
    public void upgrade(Connection a) {
    }

    @Override
    public boolean isFillInterested() {
        return false;
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return false;
    }
}

