/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty9;

import com.google.apphosting.runtime.jetty9.RequestListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.webapp.WebAppContext;

public class TransactionCleanupListener
implements RequestListener {
    private static final Logger logger = Logger.getLogger(TransactionCleanupListener.class.getName());
    private Object contextDatastoreService;
    private Method getActiveTransactions;
    private Method transactionRollback;
    private Method transactionGetId;

    public TransactionCleanupListener(ClassLoader loader) {
        try {
            Class<?> factory = loader.loadClass("com.google.appengine.api.datastore.DatastoreServiceFactory");
            this.contextDatastoreService = factory.getMethod("getDatastoreService", new Class[0]).invoke(null, new Object[0]);
            if (this.contextDatastoreService != null) {
                this.getActiveTransactions = this.contextDatastoreService.getClass().getMethod("getActiveTransactions", new Class[0]);
                this.getActiveTransactions.setAccessible(true);
                Class<?> transaction = loader.loadClass("com.google.appengine.api.datastore.Transaction");
                this.transactionRollback = transaction.getMethod("rollback", new Class[0]);
                this.transactionGetId = transaction.getMethod("getId", new Class[0]);
            }
        }
        catch (Exception ex) {
            logger.info("No datastore service found in webapp");
            logger.log(Level.FINE, "No context datastore service", ex);
        }
    }

    @Override
    public void requestReceived(WebAppContext context, Request request) {
    }

    @Override
    public void requestComplete(WebAppContext context, Request request) {
        if (this.transactionGetId == null) {
            return;
        }
        try {
            Object txns = this.getActiveTransactions.invoke(this.contextDatastoreService, new Object[0]);
            if (txns instanceof Collection) {
                for (Object tx : (Collection)txns) {
                    Object id = this.transactionGetId.invoke(tx, new Object[0]);
                    try {
                        Logger.getLogger("com.google.apphosting.util.servlet.TransactionCleanupFilter").warning("Request completed without committing or rolling back transaction " + id + ".  Transaction will be rolled back.");
                        this.transactionRollback.invoke(tx, new Object[0]);
                    }
                    catch (InvocationTargetException ex) {
                        logger.log(Level.WARNING, "Failed to rollback abandoned transaction " + id, ex.getTargetException());
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, "Failed to rollback abandoned transaction " + id, ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Failed to rollback abandoned transaction", ex);
        }
    }
}

