/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.apphosting.base.AppVersionKey;
import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.SessionsConfig;
import com.google.apphosting.runtime.jetty9.AppEngineQuickStartConfiguration;
import com.google.apphosting.runtime.jetty9.AppEngineWebInfConfiguration;
import com.google.apphosting.runtime.jetty94.AppEngineWebAppContext;
import com.google.apphosting.runtime.jetty94.SessionManagerHandler;
import com.google.apphosting.runtime.jetty94.WebAppContextFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.common.html.HtmlEscapers;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class AppVersionHandlerFactory {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final String TOMCAT_SIMPLE_INSTANCE_MANAGER = "org.apache.tomcat.SimpleInstanceManager";
    private static final String TOMCAT_INSTANCE_MANAGER = "org.apache.tomcat.InstanceManager";
    private static final String TOMCAT_JSP_FACTORY = "org.apache.jasper.runtime.JspFactoryImpl";
    public static final String WEB_DEFAULTS_XML = "com/google/apphosting/runtime/jetty94/webdefault.xml";
    private static final String USE_ANNOTATION_SCANNING = "use.annotationscanning";
    private final String[] preconfigurationClasses = this.getPreconfigurationClasses();
    private static final String[] quickstartConfigurationClasses = new String[]{AppEngineQuickStartConfiguration.class.getCanonicalName()};
    static final String ERROR_PAGE_HANDLED = "org.eclipse.jetty.server.error_page.handled";
    private final Server server;
    private final String serverInfo;
    private final WebAppContextFactory contextFactory;

    public AppVersionHandlerFactory(Server server, String serverInfo, WebAppContextFactory contextFactory) {
        this.server = server;
        this.serverInfo = serverInfo;
        this.contextFactory = contextFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler createHandler(AppVersion appVersion) throws ServletException {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Handler handler = this.doCreateHandler(appVersion);
            this.server.addBean(handler);
            Handler handler2 = handler;
            return handler2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private final String[] getPreconfigurationClasses() {
        ImmutableList.Builder list = new ImmutableList.Builder();
        list.add(AppEngineWebInfConfiguration.class.getCanonicalName());
        list.add(WebXmlConfiguration.class.getCanonicalName());
        list.add(MetaInfConfiguration.class.getCanonicalName());
        list.add(FragmentConfiguration.class.getCanonicalName());
        if (Boolean.getBoolean(USE_ANNOTATION_SCANNING)) {
            list.add(AnnotationConfiguration.class.getCanonicalName());
        }
        return (String[])list.build().stream().toArray(String[]::new);
    }

    private Handler doCreateHandler(AppVersion appVersion) throws ServletException {
        AppVersionKey appVersionKey = appVersion.getKey();
        try {
            File contextRoot = appVersion.getRootDirectory();
            AppEngineWebAppContext context = this.contextFactory.createContext(appVersion, this.serverInfo);
            context.setServer(this.server);
            context.setDefaultsDescriptor(WEB_DEFAULTS_XML);
            context.setClassLoader(appVersion.getClassLoader());
            context.setErrorHandler(new NullErrorHandler());
            File qswebxml = new File(contextRoot, "WEB-INF/quickstart-web.xml");
            if (qswebxml.exists()) {
                context.setConfigurationClasses(quickstartConfigurationClasses);
            } else {
                context.setConfigurationClasses(this.preconfigurationClasses);
            }
            context.setPersistTempDirectory(true);
            context.setExtractWAR(false);
            context.setThrowUnavailableOnStartupException(true);
            try {
                Class<?> klass = appVersion.getClassLoader().loadClass(TOMCAT_SIMPLE_INSTANCE_MANAGER);
                Object sim = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
                context.getServletContext().setAttribute(TOMCAT_INSTANCE_MANAGER, sim);
                klass = appVersion.getClassLoader().loadClass(TOMCAT_JSP_FACTORY);
                JspFactory jspf = (JspFactory)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
                JspFactory.setDefaultFactory((JspFactory)jspf);
                Class.forName("org.apache.jasper.compiler.JspRuntimeContext", true, appVersion.getClassLoader());
            }
            catch (Throwable klass) {
                // empty catch block
            }
            SessionsConfig sessionsConfig = appVersion.getSessionsConfig();
            SessionManagerHandler.Config.Builder builder = SessionManagerHandler.Config.builder();
            if (sessionsConfig.getAsyncPersistenceQueueName() != null) {
                builder.setAsyncPersistenceQueueName(sessionsConfig.getAsyncPersistenceQueueName());
            }
            builder.setEnableSession(sessionsConfig.isEnabled()).setAsyncPersistence(sessionsConfig.isAsyncPersistence()).setServletContextHandler(context);
            SessionManagerHandler.create(builder.build());
            context.setAttribute("com.google.apphosting.runtime.jetty9.APP_VERSION_CONTEXT_ATTR", appVersion);
            context.start();
            Throwable unavailableCause = context.getUnavailableException();
            if (unavailableCause != null) {
                if (unavailableCause instanceof ServletException) {
                    throw (ServletException)unavailableCause;
                }
                UnavailableException unavailableException = new UnavailableException("Initialization failed.");
                unavailableException.initCause(unavailableCause);
                throw unavailableException;
            }
            return context;
        }
        catch (ServletException ex) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Exception adding %s", appVersionKey);
            throw ex;
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    private static class NullErrorHandler
    extends ErrorPageErrorHandler {
        private NullErrorHandler() {
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            ((GoogleLogger.Api)logger.atFine()).log("Custom Jetty ErrorHandler received an error notification.");
            this.mayHandleByErrorPage(request, response);
            baseRequest.setHandled(true);
        }

        private void mayHandleByErrorPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
            String oldErrorPage;
            Class exClass = (Class)request.getAttribute("javax.servlet.error.exception_type");
            Integer code = (Integer)request.getAttribute("javax.servlet.error.status_code");
            String message = (String)request.getAttribute("javax.servlet.error.message");
            String errorPage = this.getErrorPage(request);
            if (!(errorPage == null || (oldErrorPage = (String)request.getAttribute("org.eclipse.jetty.server.error_page")) != null && oldErrorPage.equals(errorPage))) {
                request.setAttribute("org.eclipse.jetty.server.error_page", (Object)errorPage);
                Dispatcher dispatcher = (Dispatcher)this._servletContext.getRequestDispatcher(errorPage);
                try {
                    if (dispatcher != null) {
                        dispatcher.error((ServletRequest)request, (ServletResponse)response);
                        request.setAttribute(AppVersionHandlerFactory.ERROR_PAGE_HANDLED, (Object)errorPage);
                        return;
                    }
                    ((GoogleLogger.Api)logger.atWarning()).log("No error page %s", errorPage);
                }
                catch (ServletException e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Failed to handle error page.");
                }
            }
            if (exClass == null && code != null && message != null) {
                response.setContentType("text/html; charset=UTF-8");
                String messageEscaped = HtmlEscapers.htmlEscaper().escape(message);
                PrintWriter writer = response.getWriter();
                writer.println("<html><head>");
                writer.println("<meta http-equiv=\"content-type\" content=\"text/html;charset=utf-8\">");
                writer.println("<title>" + code + " " + messageEscaped + "</title>");
                writer.println("</head>");
                writer.println("<body text=#000000 bgcolor=#ffffff>");
                writer.println("<h1>Error: " + messageEscaped + "</h1>");
                writer.println("</body></html>");
            }
        }
    }
}

