/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.apphosting.base.AppVersionKey;
import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.SessionStoreFactory;
import com.google.apphosting.runtime.jetty94.AppVersionHandlerFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;

public class AppVersionHandlerMap
extends AbstractHandlerContainer {
    private final AppVersionHandlerFactory appVersionHandlerFactory;
    private final Map<AppVersionKey, AppVersion> appVersionMap;
    private final Map<AppVersionKey, Handler> handlerMap;

    public AppVersionHandlerMap(AppVersionHandlerFactory appVersionHandlerFactory) {
        this.appVersionHandlerFactory = appVersionHandlerFactory;
        this.appVersionMap = new HashMap<AppVersionKey, AppVersion>();
        this.handlerMap = new HashMap<AppVersionKey, Handler>();
    }

    public void addAppVersion(AppVersion appVersion) {
        this.appVersionMap.put(appVersion.getKey(), appVersion);
    }

    public void removeAppVersion(AppVersionKey appVersionKey) {
        this.appVersionMap.remove(appVersionKey);
    }

    public void setSessionStoreFactory(SessionStoreFactory factory) {
    }

    public synchronized Handler getHandler(AppVersionKey appVersionKey) throws ServletException {
        AppVersion appVersion;
        Handler handler = this.handlerMap.get(appVersionKey);
        if (handler == null && (appVersion = this.appVersionMap.get(appVersionKey)) != null) {
            handler = this.appVersionHandlerFactory.createHandler(appVersion);
            this.handlerMap.put(appVersionKey, handler);
        }
        return handler;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        AppVersionKey appVersionKey = (AppVersionKey)request.getAttribute("com.google.apphosting.runtime.jetty9.APP_VERSION_REQUEST_ATTR");
        if (appVersionKey == null) {
            throw new ServletException("Request did not provide an application version");
        }
        Handler handler = this.getHandler(appVersionKey);
        if (handler == null) {
            throw new ServletException("Unknown application: " + appVersionKey);
        }
        try {
            handler.handle(target, baseRequest, request, response);
        }
        catch (IOException | ServletException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    @Override
    protected void doStart() throws Exception {
        for (Handler handler : this.getHandlers()) {
            handler.start();
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        for (Handler handler : this.getHandlers()) {
            handler.stop();
        }
    }

    @Override
    public void setServer(Server server) {
        super.setServer(server);
        for (Handler handler : this.getHandlers()) {
            handler.setServer(server);
        }
    }

    @Override
    public Handler[] getHandlers() {
        return this.handlerMap.values().toArray(new Handler[0]);
    }

    public void setHandlers(Handler[] handlers) {
        throw new UnsupportedOperationException();
    }

    public void addHandler(Handler handler) {
        throw new UnsupportedOperationException();
    }

    public void removeHandler(Handler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void expandChildren(List<Handler> list, Class<?> byClass) {
        for (Handler handler : this.getHandlers()) {
            this.expandHandler(handler, list, byClass);
        }
    }
}

