/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.apphosting.runtime.SessionData;
import com.google.apphosting.runtime.SessionStore;
import com.google.apphosting.runtime.jetty94.AppEngineSessionData;
import com.google.apphosting.runtime.jetty94.DeferredDatastoreSessionStore;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.GoogleLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.server.session.AbstractSessionDataStore;
import org.eclipse.jetty.server.session.UnreadableSessionDataException;
import org.eclipse.jetty.server.session.UnwriteableSessionDataException;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;

class DatastoreSessionStore
implements SessionStore {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    static final String SESSION_ENTITY_TYPE = "_ah_SESSION";
    private static final String EXPIRES_PROP = "_expires";
    private static final String VALUES_PROP = "_values";
    private static final String SESSION_PREFIX = "_ahs";
    private final SessionDataStoreImpl impl;

    DatastoreSessionStore(boolean useTaskqueue, Optional<String> queueName) {
        this.impl = useTaskqueue ? new DeferredDatastoreSessionStore(queueName) : new SessionDataStoreImpl();
    }

    static String keyForSessionId(String id) {
        return id.startsWith(SESSION_PREFIX) ? id : SESSION_PREFIX + id;
    }

    static String normalizeSessionId(String id) {
        return id.startsWith(SESSION_PREFIX) ? id.substring(SESSION_PREFIX.length()) : id;
    }

    SessionDataStoreImpl getSessionDataStoreImpl() {
        return this.impl;
    }

    @Override
    public SessionData getSession(String key) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void saveSession(String key, SessionData data) {
        throw new UnsupportedOperationException("saveSession is not supported.");
    }

    @Override
    public void deleteSession(String key) {
        try {
            this.impl.delete(key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class SessionDataStoreImpl
    extends AbstractSessionDataStore {
        private static final int MAX_RETRIES = 10;
        private static final int INITIAL_BACKOFF_MS = 50;
        private final DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();

        SessionDataStoreImpl() {
        }

        @Override
        public Set<String> doGetExpired(Set<String> candidates) {
            return ImmutableSet.of();
        }

        @Override
        public void doStore(String id, org.eclipse.jetty.server.session.SessionData data, long lastSaveTime) throws InterruptedException, IOException, UnwriteableSessionDataException, SessionStore.Retryable {
            Entity entity = this.entityFromSession(id, data);
            int backoff = 50;
            for (int attempts = 0; attempts < 10; ++attempts) {
                try {
                    this.datastore.put(entity);
                    return;
                }
                catch (DatastoreTimeoutException ex) {
                    Thread.sleep(backoff);
                    backoff *= 2;
                    continue;
                }
            }
            throw new UnwriteableSessionDataException(id, this._context, null);
        }

        @Override
        public boolean isPassivating() {
            return false;
        }

        @Override
        public boolean exists(String id) throws Exception {
            try {
                Entity entity = this.datastore.get(SessionDataStoreImpl.createKeyForSession(id));
                ((GoogleLogger.Api)logger.atFinest()).log("Session %s %s", (Object)id, (Object)(entity != null ? "exists" : "does not exist"));
                return true;
            }
            catch (EntityNotFoundException ex) {
                ((GoogleLogger.Api)logger.atFine()).log("Session %s does not exist", id);
                return false;
            }
        }

        @Override
        public boolean delete(String id) throws IOException {
            this.datastore.delete(SessionDataStoreImpl.createKeyForSession(id));
            return true;
        }

        @Override
        public org.eclipse.jetty.server.session.SessionData doLoad(String id) throws Exception {
            try {
                Entity entity = this.datastore.get(SessionDataStoreImpl.createKeyForSession(id));
                ((GoogleLogger.Api)logger.atFinest()).log("Loaded session %s from datastore.", id);
                return this.sessionFromEntity(entity, DatastoreSessionStore.normalizeSessionId(id));
            }
            catch (EntityNotFoundException ex) {
                ((GoogleLogger.Api)logger.atFine()).log("Unable to find specified session %s", id);
                return null;
            }
        }

        static Key createKeyForSession(String id) {
            String originalNamespace = NamespaceManager.get();
            try {
                NamespaceManager.set("");
                Key key = KeyFactory.createKey(DatastoreSessionStore.SESSION_ENTITY_TYPE, DatastoreSessionStore.keyForSessionId(id));
                return key;
            }
            finally {
                NamespaceManager.set(originalNamespace);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Entity entityFromSession(String id, org.eclipse.jetty.server.session.SessionData data) throws IOException {
            String originalNamespace = NamespaceManager.get();
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(((AppEngineSessionData)data).getMutableAttributes());
                oos.flush();
                NamespaceManager.set("");
                Entity entity = new Entity(DatastoreSessionStore.SESSION_ENTITY_TYPE, DatastoreSessionStore.SESSION_PREFIX + id);
                entity.setProperty(DatastoreSessionStore.EXPIRES_PROP, data.getExpiry());
                entity.setProperty(DatastoreSessionStore.VALUES_PROP, new Blob(baos.toByteArray()));
                Entity entity2 = entity;
                return entity2;
            }
            finally {
                NamespaceManager.set(originalNamespace);
            }
        }

        org.eclipse.jetty.server.session.SessionData sessionFromEntity(Entity entity, String id) throws Exception {
            if (entity == null) {
                return null;
            }
            long time = System.currentTimeMillis();
            AtomicReference reference = new AtomicReference();
            AtomicReference exception = new AtomicReference();
            Runnable load = () -> {
                try {
                    org.eclipse.jetty.server.session.SessionData session = this.createSessionData(entity, id, time);
                    reference.set(session);
                }
                catch (UnreadableSessionDataException ex) {
                    exception.set(ex);
                }
            };
            this._context.run(load);
            if (exception.get() != null) {
                throw (Exception)exception.get();
            }
            return (org.eclipse.jetty.server.session.SessionData)reference.get();
        }

        @Override
        public org.eclipse.jetty.server.session.SessionData newSessionData(String id, long created, long accessed, long lastAccessed, long maxInactiveMs) {
            return new AppEngineSessionData(id, this._context.getCanonicalContextPath(), this._context.getVhost(), created, accessed, lastAccessed, maxInactiveMs);
        }

        private org.eclipse.jetty.server.session.SessionData createSessionData(Entity entity, String id, long time) throws UnreadableSessionDataException {
            long expiry = (Long)entity.getProperty(DatastoreSessionStore.EXPIRES_PROP);
            Blob blob = (Blob)entity.getProperty(DatastoreSessionStore.VALUES_PROP);
            org.eclipse.jetty.server.session.SessionData session = this.newSessionData(id, time, time, time, 1000L * (long)this._context.getSessionHandler().getMaxInactiveInterval());
            session.setExpiry(expiry);
            try (ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream(new ByteArrayInputStream(blob.getBytes()));){
                Map map = (Map)ois.readObject();
                session.putAllAttributes(map);
            }
            catch (Exception ex) {
                throw new UnreadableSessionDataException(id, this._context, ex);
            }
            return session;
        }
    }
}

