/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.taskqueue.DeferredTask;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.RetryOptions;
import com.google.appengine.api.taskqueue.TaskOptions;
import com.google.appengine.api.taskqueue.TransientFailureException;
import com.google.apphosting.runtime.SessionStore;
import com.google.apphosting.runtime.jetty94.DatastoreSessionStore;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Optional;
import org.eclipse.jetty.server.session.SessionData;

class DeferredDatastoreSessionStore
extends DatastoreSessionStore.SessionDataStoreImpl {
    private static final int SAVE_TASK_AGE_LIMIT_SECS = 10;
    private static final Constructor<DeferredTask> putDeferredTaskConstructor = DeferredDatastoreSessionStore.getConstructor(DeferredTask.class.getPackage().getName() + ".DatastorePutDeferredTask", Entity.class);
    private static final Constructor<DeferredTask> deleteDeferredTaskConstructor = DeferredDatastoreSessionStore.getConstructor(DeferredTask.class.getPackage().getName() + ".DatastoreDeleteDeferredTask", Key.class);
    private final Queue queue;

    DeferredDatastoreSessionStore(Optional<String> queueName) {
        this.queue = queueName.isPresent() ? QueueFactory.getQueue(queueName.get()) : QueueFactory.getDefaultQueue();
    }

    @Override
    public void doStore(String id, SessionData data, long lastSaveTime) throws IOException, SessionStore.Retryable {
        try {
            Entity e = this.entityFromSession(id, data);
            this.queue.add(TaskOptions.Builder.withPayload(DeferredDatastoreSessionStore.newDeferredTask(putDeferredTaskConstructor, e)).retryOptions(RetryOptions.Builder.withTaskAgeLimitSeconds(10L)));
        }
        catch (ReflectiveOperationException e) {
            throw new IOException(e);
        }
        catch (TransientFailureException e) {
            throw new SessionStore.Retryable(e);
        }
    }

    @Override
    public boolean delete(String id) throws IOException {
        try {
            Key key = DeferredDatastoreSessionStore.createKeyForSession(id);
            this.queue.add(TaskOptions.Builder.withPayload(DeferredDatastoreSessionStore.newDeferredTask(deleteDeferredTaskConstructor, key)));
        }
        catch (ReflectiveOperationException e) {
            throw new IOException(e);
        }
        return true;
    }

    private static Constructor<DeferredTask> getConstructor(String clsName, Class<?> argType) {
        try {
            Class<?> cls = Class.forName(clsName);
            Constructor<DeferredTask> ctor = cls.getConstructor(argType);
            ctor.setAccessible(true);
            return ctor;
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static DeferredTask newDeferredTask(Constructor<DeferredTask> ctor, Object arg) throws ReflectiveOperationException {
        return ctor.newInstance(arg);
    }
}

