/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.apphosting.runtime.jetty94.CacheControlHeader;
import com.google.apphosting.utils.config.AppYaml;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.io.WriterOutputStream;
import org.eclipse.jetty.util.resource.Resource;

public class FileSender {
    private final AppYaml appYaml;

    public FileSender(AppYaml appYaml) {
        this.appYaml = appYaml;
    }

    public void sendData(ServletContext servletContext, HttpServletResponse response, boolean include, Resource resource, String urlPath) throws IOException {
        long contentLength = resource.length();
        if (!include) {
            this.writeHeaders(servletContext, response, resource, contentLength, urlPath);
        }
        Object out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream(response.getWriter());
        }
        resource.writeTo((OutputStream)out, 0L, contentLength);
    }

    private void writeHeaders(ServletContext servletContext, HttpServletResponse response, Resource resource, long contentCount, String urlPath) throws IOException {
        String contentType = servletContext.getMimeType(resource.getName());
        if (contentType != null) {
            response.setContentType(contentType);
        }
        if (contentCount != -1L) {
            if (contentCount < Integer.MAX_VALUE) {
                response.setContentLength((int)contentCount);
            } else {
                response.setContentLengthLong(contentCount);
            }
        }
        response.setDateHeader(HttpHeader.LAST_MODIFIED.asString(), resource.lastModified());
        if (this.appYaml != null) {
            Optional<AppYaml.Handler> maybeHandler = this.appYaml.getHandlers().stream().filter(handler -> handler.getStatic_files() != null && handler.getRegularExpression() != null && handler.getRegularExpression().matcher(urlPath).matches()).findFirst();
            maybeHandler.ifPresent(handler -> {
                String cacheControlValue = CacheControlHeader.fromExpirationTime(handler.getExpiration()).getValue();
                response.setHeader(HttpHeader.CACHE_CONTROL.asString(), cacheControlValue);
                Map<String, String> headersFromHandler = handler.getHttp_headers();
                if (headersFromHandler != null) {
                    for (Map.Entry<String, String> entry : headersFromHandler.entrySet()) {
                        response.addHeader(entry.getKey(), entry.getValue());
                    }
                }
            });
        }
        if (Strings.isNullOrEmpty(response.getHeader(HttpHeader.CACHE_CONTROL.asString()))) {
            response.setHeader(HttpHeader.CACHE_CONTROL.asString(), CacheControlHeader.getDefaultInstance().getValue());
        }
    }

    public boolean checkIfUnmodified(HttpServletRequest request, HttpServletResponse response, Resource resource) throws IOException {
        if (!request.getMethod().equals(HttpMethod.HEAD.asString())) {
            String ifms = request.getHeader(HttpHeader.IF_MODIFIED_SINCE.asString());
            if (ifms != null) {
                long ifmsl = -1L;
                try {
                    ifmsl = request.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.asString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (ifmsl != -1L && resource.lastModified() <= ifmsl) {
                    response.reset();
                    response.setStatus(304);
                    response.flushBuffer();
                    return true;
                }
            }
            long date = -1L;
            try {
                date = request.getDateHeader(HttpHeader.IF_UNMODIFIED_SINCE.asString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (date != -1L && resource.lastModified() > date) {
                response.sendError(412);
                return true;
            }
        }
        return false;
    }
}

