/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.apphosting.base.protos.AppLogsPb;
import com.google.apphosting.base.protos.AppinfoPb;
import com.google.apphosting.base.protos.EmptyMessage;
import com.google.apphosting.base.protos.HttpPb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.base.protos.TracePb;
import com.google.apphosting.runtime.ServletEngineAdapter;
import com.google.apphosting.runtime.TraceContextHelper;
import com.google.apphosting.runtime.anyrpc.AnyRpcServerContext;
import com.google.apphosting.runtime.anyrpc.EvaluationRuntimeServerInterface;
import com.google.apphosting.runtime.jetty94.AppInfoFactory;
import com.google.apphosting.runtime.jetty94.JettyServerConnectorWithReusePort;
import com.google.apphosting.runtime.jetty94.RpcConnector;
import com.google.common.base.Ascii;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.GoogleLogger;
import com.google.common.html.HtmlEscapers;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;

public class JettyHttpProxy {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final String JETTY_LOG_CLASS = "org.eclipse.jetty.util.log.class";
    private static final String JETTY_STDERRLOG = "org.eclipse.jetty.util.log.StdErrLog";

    public static void startServer(ServletEngineAdapter.Config runtimeOptions) {
        try {
            System.setProperty(JETTY_LOG_CLASS, JETTY_STDERRLOG);
            ForwardingHandler handler = new ForwardingHandler(runtimeOptions, System.getenv());
            handler.init();
            Server server = JettyHttpProxy.newServer(runtimeOptions, handler);
            server.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Server newServer(ServletEngineAdapter.Config runtimeOptions, ForwardingHandler handler) {
        Server server = new Server();
        JettyServerConnectorWithReusePort c = new JettyServerConnectorWithReusePort(server, runtimeOptions.jettyReusePort());
        c.setHost(runtimeOptions.jettyHttpAddress().getHost());
        c.setPort(runtimeOptions.jettyHttpAddress().getPort());
        server.setConnectors(new Connector[]{c});
        HttpConnectionFactory factory = c.getConnectionFactory(HttpConnectionFactory.class);
        factory.setHttpCompliance(RpcConnector.LEGACY_MODE ? HttpCompliance.RFC7230_LEGACY : HttpCompliance.RFC7230);
        HttpConfiguration config = factory.getHttpConfiguration();
        config.setRequestHeaderSize(runtimeOptions.jettyRequestHeaderSize());
        config.setResponseHeaderSize(runtimeOptions.jettyResponseHeaderSize());
        config.setSendDateHeader(false);
        config.setSendServerVersion(false);
        config.setSendXPoweredBy(false);
        GzipHandler gzip = new GzipHandler();
        gzip.setIncludedMethods("GET", "POST");
        gzip.setInflateBufferSize(8192);
        server.setHandler(gzip);
        gzip.setHandler(handler);
        ((GoogleLogger.Api)logger.atInfo()).log("Starting Jetty http server for Java runtime proxy.");
        return server;
    }

    private static HttpPb.ParsedHttpHeader.Builder createRuntimeHeader(String key, String value) {
        return HttpPb.ParsedHttpHeader.newBuilder().setKey(key).setValue(value);
    }

    private static Level toJavaLevel(long level) {
        switch (Ints.saturatedCast(level)) {
            case 0: {
                return Level.FINE;
            }
            case 1: {
                return Level.INFO;
            }
            case 3: 
            case 4: {
                return Level.SEVERE;
            }
        }
        return Level.WARNING;
    }

    private JettyHttpProxy() {
    }

    public static class ForwardingHandler
    extends AbstractHandler {
        private static final String DEFAULT_SECRET_KEY = "secretkey";
        private static final String X_FORWARDED_PROTO = "x-forwarded-proto";
        private static final String X_APPENGINE_API_TICKET = "x-appengine-api-ticket";
        private static final String X_APPENGINE_HTTPS = "x-appengine-https";
        private static final String X_APPENGINE_USER_IP = "x-appengine-user-ip";
        private static final String X_APPENGINE_USER_EMAIL = "x-appengine-user-email";
        private static final String X_APPENGINE_AUTH_DOMAIN = "x-appengine-auth-domain";
        private static final String X_APPENGINE_USER_ID = "x-appengine-user-id";
        private static final String X_APPENGINE_USER_NICKNAME = "x-appengine-user-nickname";
        private static final String X_APPENGINE_USER_ORGANIZATION = "x-appengine-user-organization";
        private static final String X_APPENGINE_USER_IS_ADMIN = "x-appengine-user-is-admin";
        private static final String X_APPENGINE_TRUSTED_IP_REQUEST = "x-appengine-trusted-ip-request";
        private static final String X_APPENGINE_LOAS_PEER_USERNAME = "x-appengine-loas-peer-username";
        private static final String X_APPENGINE_GAIA_ID = "x-appengine-gaia-id";
        private static final String X_APPENGINE_GAIA_AUTHUSER = "x-appengine-gaia-authuser";
        private static final String X_APPENGINE_GAIA_SESSION = "x-appengine-gaia-session";
        private static final String X_APPENGINE_APPSERVER_DATACENTER = "x-appengine-appserver-datacenter";
        private static final String X_APPENGINE_APPSERVER_TASK_BNS = "x-appengine-appserver-task-bns";
        private static final String X_APPENGINE_DEFAULT_VERSION_HOSTNAME = "x-appengine-default-version-hostname";
        private static final String X_APPENGINE_REQUEST_LOG_ID = "x-appengine-request-log-id";
        private static final String X_APPENGINE_QUEUENAME = "x-appengine-queuename";
        private static final String X_APPENGINE_TIMEOUT_MS = "x-appengine-timeout-ms";
        private static final String X_GOOGLE_INTERNAL_SKIPADMINCHECK = "x-google-internal-skipadmincheck";
        private static final String X_GOOGLE_INTERNAL_SKIPADMINCHECK_UC = "X-Google-Internal-SkipAdminCheck";
        private static final String X_GOOGLE_INTERNAL_PROFILER = "x-google-internal-profiler";
        private static final String X_CLOUD_TRACE_CONTEXT = "x-cloud-trace-context";
        private static final String IS_ADMIN_HEADER_VALUE = "1";
        private static final String IS_TRUSTED = "1";
        private static final String WARMUP_IP = "0.1.0.3";
        private static final ImmutableSet<String> PRIVATE_APPENGINE_HEADERS = ImmutableSet.of("x-appengine-api-ticket", "x-appengine-https", "x-appengine-user-ip", "x-appengine-user-email", "x-appengine-auth-domain", "x-appengine-user-id", new String[]{"x-appengine-user-nickname", "x-appengine-user-organization", "x-appengine-user-is-admin", "x-appengine-trusted-ip-request", "x-appengine-loas-peer-username", "x-appengine-gaia-id", "x-appengine-gaia-authuser", "x-appengine-gaia-session", "x-appengine-appserver-datacenter", "x-appengine-appserver-task-bns", "x-appengine-default-version-hostname", "x-appengine-request-log-id", "x-appengine-timeout-ms", "x-google-internal-profiler"});
        private final String applicationRoot;
        private final String fixedApplicationPath;
        private final AppInfoFactory appInfoFactory;
        private final EvaluationRuntimeServerInterface evaluationRuntimeServerInterface;

        public ForwardingHandler(ServletEngineAdapter.Config runtimeOptions, Map<String, String> env) throws ExecutionException, InterruptedException, IOException {
            this.applicationRoot = runtimeOptions.applicationRoot();
            this.fixedApplicationPath = runtimeOptions.fixedApplicationPath();
            this.appInfoFactory = new AppInfoFactory(env);
            this.evaluationRuntimeServerInterface = runtimeOptions.evaluationRuntimeServerInterface();
        }

        private void init() {
            try {
                AppinfoPb.AppInfo appinfo = this.appInfoFactory.getAppInfoFromFile(this.applicationRoot, this.fixedApplicationPath);
                LocalRpcContext context = new LocalRpcContext(EmptyMessage.class);
                this.evaluationRuntimeServerInterface.addAppVersion(context, appinfo);
                context.getResponse();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
            baseRequest.setHandled(true);
            RuntimePb.UPRequest upRequest = this.translateToUpRequest(baseRequest);
            try {
                RuntimePb.UPResponse upResponse = this.getUpResponse(upRequest);
                this.fillHttpResponse(baseRequest.getResponse(), upResponse);
            }
            catch (Exception ex) {
                ForwardingHandler.populateErrorResponse(response, "Can't make request of app: " + Throwables.getStackTraceAsString(ex));
            }
        }

        RuntimePb.UPResponse getUpResponse(RuntimePb.UPRequest upRequest) throws ExecutionException, InterruptedException {
            Duration timeRemaining = upRequest.getRuntimeHeadersList().stream().filter(p -> Ascii.equalsIgnoreCase(p.getKey(), X_APPENGINE_TIMEOUT_MS)).map(p -> Duration.ofMillis(Long.parseLong(p.getValue()))).findFirst().orElse(Duration.ofNanos(Long.MAX_VALUE));
            LocalRpcContext context = new LocalRpcContext(RuntimePb.UPResponse.class, timeRemaining);
            this.evaluationRuntimeServerInterface.handleRequest(context, upRequest);
            RuntimePb.UPResponse upResponse = (RuntimePb.UPResponse)context.getResponse();
            for (AppLogsPb.AppLogLine line : upResponse.getAppLogList()) {
                logger.at(JettyHttpProxy.toJavaLevel(line.getLevel())).log("%s", line.getMessage());
            }
            return upResponse;
        }

        void fillHttpResponse(Response response, RuntimePb.UPResponse rpcResp) {
            HttpPb.HttpResponse rpcHttpResp = rpcResp.getHttpResponse();
            if (rpcResp.getError() != RuntimePb.UPResponse.ERROR.OK.getNumber()) {
                ForwardingHandler.populateErrorResponse(response, "Request failed: " + rpcResp.getErrorMessage());
                return;
            }
            response.setStatus(rpcHttpResp.getResponsecode());
            for (HttpPb.ParsedHttpHeader header : rpcHttpResp.getOutputHeadersList()) {
                response.addHeader(header.getKey(), header.getValue());
            }
            try {
                response.getHttpOutput().sendContent(rpcHttpResp.getResponse().asReadOnlyByteBuffer());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        RuntimePb.UPRequest translateToUpRequest(HttpServletRequest realRequest) {
            RuntimePb.UPRequest.Builder upReqBuilder = RuntimePb.UPRequest.newBuilder().setAppId(this.appInfoFactory.getGaeApplication()).setVersionId(this.appInfoFactory.getGaeVersion()).setModuleId(this.appInfoFactory.getGaeService()).setModuleVersionId(this.appInfoFactory.getGaeServiceVersion());
            upReqBuilder.setSecurityTicket(DEFAULT_SECRET_KEY);
            upReqBuilder.setNickname("");
            if (realRequest instanceof Request) {
                for (HttpField field : ((Request)realRequest).getHttpFields()) {
                    ForwardingHandler.builderHeader(upReqBuilder, field.getName(), field.getValue());
                }
            } else {
                for (String name : Collections.list(realRequest.getHeaderNames())) {
                    Iterator<String> value = realRequest.getHeader(name);
                    ForwardingHandler.builderHeader(upReqBuilder, name, (String)((Object)value));
                }
            }
            AppinfoPb.Handler handler = upReqBuilder.getHandler().newBuilderForType().setType(AppinfoPb.Handler.HANDLERTYPE.CGI_BIN.getNumber()).setPath("unused").build();
            upReqBuilder.setHandler(handler);
            HttpPb.HttpRequest.Builder httpRequest = upReqBuilder.getRequestBuilder().setHttpVersion(realRequest.getProtocol()).setProtocol(realRequest.getMethod()).setUrl(this.getUrl(realRequest)).setUserIp(realRequest.getRemoteAddr());
            if (realRequest instanceof Request) {
                for (HttpField field : ((Request)realRequest).getHttpFields()) {
                    ForwardingHandler.requestHeader(upReqBuilder, httpRequest, field.getName(), field.getValue());
                }
            } else {
                for (String name : Collections.list(realRequest.getHeaderNames())) {
                    String value = realRequest.getHeader(name);
                    ForwardingHandler.requestHeader(upReqBuilder, httpRequest, name, value);
                }
            }
            try {
                httpRequest.setPostdata(ByteString.readFrom((InputStream)realRequest.getInputStream()));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not read POST content:", ex);
            }
            if ("/_ah/background".equals(realRequest.getRequestURI())) {
                if (WARMUP_IP.equals(httpRequest.getUserIp())) {
                    upReqBuilder.setRequestType(RuntimePb.UPRequest.RequestType.BACKGROUND);
                }
            } else if ("/_ah/start".equals(realRequest.getRequestURI()) && WARMUP_IP.equals(httpRequest.getUserIp())) {
                httpRequest.setIsHttps(true);
            }
            return upReqBuilder.build();
        }

        private static void builderHeader(RuntimePb.UPRequest.Builder upReqBuilder, String name, String value) {
            String lower;
            if (Strings.isNullOrEmpty(value)) {
                return;
            }
            switch (lower = Ascii.toLowerCase(name)) {
                case "x-appengine-api-ticket": {
                    upReqBuilder.setSecurityTicket(value);
                    return;
                }
                case "x-appengine-user-email": {
                    upReqBuilder.setEmail(value);
                    return;
                }
                case "x-appengine-user-nickname": {
                    upReqBuilder.setNickname(value);
                    return;
                }
                case "x-appengine-user-is-admin": {
                    upReqBuilder.setIsAdmin(value.equals("1"));
                    return;
                }
                case "x-appengine-auth-domain": {
                    upReqBuilder.setAuthDomain(value);
                    return;
                }
                case "x-appengine-user-organization": {
                    upReqBuilder.setUserOrganization(value);
                    return;
                }
                case "x-appengine-loas-peer-username": {
                    upReqBuilder.setPeerUsername(value);
                    return;
                }
                case "x-appengine-gaia-id": {
                    upReqBuilder.setGaiaId(Long.parseLong(value));
                    return;
                }
                case "x-appengine-gaia-authuser": {
                    upReqBuilder.setAuthuser(value);
                    return;
                }
                case "x-appengine-gaia-session": {
                    upReqBuilder.setGaiaSession(value);
                    return;
                }
                case "x-appengine-appserver-datacenter": {
                    upReqBuilder.setAppserverDatacenter(value);
                    return;
                }
                case "x-appengine-appserver-task-bns": {
                    upReqBuilder.setAppserverTaskBns(value);
                    return;
                }
                case "x-appengine-user-id": {
                    upReqBuilder.setObfuscatedGaiaId(value);
                    return;
                }
                case "x-appengine-default-version-hostname": {
                    upReqBuilder.setDefaultVersionHostname(value);
                    return;
                }
                case "x-appengine-request-log-id": {
                    upReqBuilder.setRequestLogId(value);
                    return;
                }
            }
        }

        private static void requestHeader(RuntimePb.UPRequest.Builder upReqBuilder, HttpPb.HttpRequest.Builder httpRequest, String name, String value) {
            String lower;
            if (Strings.isNullOrEmpty(value)) {
                return;
            }
            switch (lower = Ascii.toLowerCase(name)) {
                case "x-appengine-trusted-ip-request": {
                    httpRequest.setTrusted(value.equals("1"));
                    upReqBuilder.setIsTrustedApp(true);
                    break;
                }
                case "x-appengine-https": {
                    httpRequest.setIsHttps(value.equals("on"));
                    break;
                }
                case "x-appengine-user-ip": {
                    httpRequest.setUserIp(value);
                    break;
                }
                case "x-forwarded-proto": {
                    httpRequest.setIsHttps(value.equals("https"));
                    break;
                }
                case "x-cloud-trace-context": {
                    try {
                        TracePb.TraceContextProto proto = TraceContextHelper.parseTraceContextHeader(value);
                        upReqBuilder.setTraceContext(proto);
                    }
                    catch (NumberFormatException e) {
                        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Could not parse trace context header: %s", value);
                    }
                    break;
                }
                case "x-google-internal-skipadmincheck": {
                    if (!upReqBuilder.getRuntimeHeadersList().stream().map(HttpPb.ParsedHttpHeader::getKey).noneMatch(X_GOOGLE_INTERNAL_SKIPADMINCHECK_UC::equalsIgnoreCase)) break;
                    upReqBuilder.addRuntimeHeaders(JettyHttpProxy.createRuntimeHeader(X_GOOGLE_INTERNAL_SKIPADMINCHECK_UC, "true"));
                    break;
                }
                case "x-appengine-queuename": {
                    httpRequest.setIsOffline(true);
                    if (!upReqBuilder.getRuntimeHeadersList().stream().map(HttpPb.ParsedHttpHeader::getKey).noneMatch(X_GOOGLE_INTERNAL_SKIPADMINCHECK_UC::equalsIgnoreCase)) break;
                    upReqBuilder.addRuntimeHeaders(JettyHttpProxy.createRuntimeHeader(X_GOOGLE_INTERNAL_SKIPADMINCHECK_UC, "true"));
                    break;
                }
                case "x-appengine-timeout-ms": {
                    upReqBuilder.addRuntimeHeaders(JettyHttpProxy.createRuntimeHeader(X_APPENGINE_TIMEOUT_MS, value));
                    break;
                }
                case "x-google-internal-profiler": {
                    try {
                        TextFormat.merge(value, (Message.Builder)upReqBuilder.getProfilerSettingsBuilder());
                        break;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("X-Google-Internal-Profiler read content error:", ex);
                    }
                }
            }
            if (!PRIVATE_APPENGINE_HEADERS.contains(lower)) {
                httpRequest.addHeadersBuilder().setKey(name).setValue(value);
            }
        }

        private String getUrl(HttpServletRequest req) {
            StringBuffer url = req.getRequestURL();
            String query = req.getQueryString();
            if (query != null) {
                url.append('?').append(query);
            }
            return url.toString();
        }

        static void populateErrorResponse(HttpServletResponse resp, String errMsg) {
            resp.setStatus(500);
            try {
                ServletOutputStream outstr = resp.getOutputStream();
                outstr.print("<html><head><title>Server Error</title></head>");
                outstr.print("<body>" + HtmlEscapers.htmlEscaper().escape(errMsg) + "</body></html>");
            }
            catch (IOException iox) {
                throw new RuntimeException(iox);
            }
        }
    }

    private static class LocalRpcContext<M extends MessageLite>
    implements AnyRpcServerContext {
        private static final AtomicLong globalIds = new AtomicLong();
        private final Class<M> responseMessageClass;
        private final long startTimeMillis;
        private final Duration timeRemaining;
        private final SettableFuture<M> futureResponse = SettableFuture.create();
        private final long globalId = globalIds.getAndIncrement();

        private LocalRpcContext(Class<M> responseMessageClass) {
            this(responseMessageClass, Duration.ofNanos(Long.MAX_VALUE));
        }

        private LocalRpcContext(Class<M> responseMessageClass, Duration timeRemaining) {
            this.responseMessageClass = responseMessageClass;
            this.startTimeMillis = System.currentTimeMillis();
            this.timeRemaining = timeRemaining;
        }

        @Override
        public void finishWithResponse(MessageLite response) {
            this.futureResponse.set(this.responseMessageClass.cast(response));
        }

        M getResponse() throws ExecutionException, InterruptedException {
            return (M)((MessageLite)this.futureResponse.get());
        }

        @Override
        public void finishWithAppError(int appErrorCode, String errorDetail) {
            String message = "AppError: code " + appErrorCode + "; errorDetail " + errorDetail;
            this.futureResponse.setException(new RuntimeException(message));
        }

        @Override
        public Duration getTimeRemaining() {
            return this.timeRemaining;
        }

        @Override
        public long getGlobalId() {
            return this.globalId;
        }

        @Override
        public long getStartTimeMillis() {
            return this.startTimeMillis;
        }
    }
}

