/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.jetty94.FileSender;
import com.google.apphosting.utils.config.AppYaml;
import com.google.common.base.Ascii;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;

public class ResourceFileServlet
extends HttpServlet {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private Resource resourceBase;
    private String[] welcomeFiles;
    private FileSender fSender;
    ContextHandler chandler;
    ServletContext context;

    public void init() throws ServletException {
        this.context = this.getServletContext();
        AppVersion appVersion = (AppVersion)this.context.getAttribute("com.google.apphosting.runtime.jetty9.APP_VERSION_CONTEXT_ATTR");
        this.chandler = ((ContextHandler.Context)this.context).getContextHandler();
        AppYaml appYaml = (AppYaml)this.chandler.getServer().getAttribute("com.google.apphosting.runtime.jetty94.appYaml");
        this.fSender = new FileSender(appYaml);
        this.welcomeFiles = this.chandler.getWelcomeFiles();
        try {
            this.resourceBase = Resource.newResource(this.context.getResource("/" + appVersion.getPublicRoot()));
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo;
        String servletPath;
        boolean included;
        boolean bl = included = request.getAttribute("javax.servlet.include.request_uri") != null;
        if (included) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            included = Boolean.FALSE;
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        boolean forwarded = request.getAttribute("javax.servlet.forward.request_uri") != null;
        String pathInContext = URIUtil.addPaths(servletPath, pathInfo);
        if (this.isProtectedPath(pathInContext) && !included && !forwarded) {
            response.sendError(404);
            return;
        }
        if (this.maybeServeWelcomeFile(pathInContext, included, request, response)) {
            return;
        }
        if (pathInContext.endsWith("/")) {
            response.sendError(404);
            return;
        }
        for (int i = 0; i < pathInContext.length(); ++i) {
            char c = pathInContext.charAt(i);
            if (c >= ' ' && c != '\u007f') continue;
            response.sendError(400);
            ((GoogleLogger.Api)logger.atWarning()).log("Attempted to access file containing control character, returning 400.");
            return;
        }
        Resource resource = null;
        try {
            resource = this.getResource(pathInContext);
            if (resource == null) {
                response.sendError(404);
                return;
            }
            if (StringUtil.endsWithIgnoreCase(resource.getName(), ".jsp")) {
                response.sendError(404);
                return;
            }
            if (resource.isDirectory()) {
                if (included || !this.fSender.checkIfUnmodified(request, response, resource)) {
                    response.sendError(403);
                }
            } else if (resource == null || !resource.exists()) {
                ((GoogleLogger.Api)logger.atWarning()).log("Non existent resource: %s = %s", (Object)pathInContext, (Object)resource);
                response.sendError(404);
            } else if (included || !this.fSender.checkIfUnmodified(request, response, resource)) {
                this.fSender.sendData(this.context, response, included, resource, request.getRequestURI());
            }
        }
        finally {
            if (resource != null) {
                resource.release();
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(405);
    }

    protected boolean isProtectedPath(String target) {
        return (target = Ascii.toLowerCase(target)).contains("/web-inf/") || target.contains("/meta-inf/");
    }

    private Resource getResource(String pathInContext) {
        try {
            if (this.resourceBase != null) {
                return this.resourceBase.addPath(pathInContext);
            }
        }
        catch (Exception ex) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Could not find: %s", pathInContext);
        }
        return null;
    }

    private boolean maybeServeWelcomeFile(String path, boolean included, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.welcomeFiles == null) {
            System.err.println("No welcome files");
            return false;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        AppVersion appVersion = (AppVersion)this.getServletContext().getAttribute("com.google.apphosting.runtime.jetty9.APP_VERSION_CONTEXT_ATTR");
        ServletHandler handler = this.chandler.getChildHandlerByClass(ServletHandler.class);
        MappedResource<ServletHolder> defaultEntry = handler.getHolderEntry("/");
        for (String welcomeName : this.welcomeFiles) {
            String welcomePath = path + welcomeName;
            String relativePath = welcomePath.substring(1);
            if (!Objects.equals(handler.getHolderEntry(welcomePath), defaultEntry)) {
                RequestDispatcher dispatcher = request.getRequestDispatcher(path + welcomeName);
                return this.serveWelcomeFileAsForward(dispatcher, included, request, response);
            }
            if (appVersion.isResourceFile(relativePath)) {
                RequestDispatcher dispatcher = request.getRequestDispatcher(path + welcomeName);
                return this.serveWelcomeFileAsForward(dispatcher, included, request, response);
            }
            if (!appVersion.isStaticFile(relativePath)) continue;
            return this.serveWelcomeFileAsRedirect(path + welcomeName, included, request, response);
        }
        return false;
    }

    private boolean serveWelcomeFileAsRedirect(String path, boolean included, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (included) {
            return false;
        }
        response.setContentLength(0);
        String q = request.getQueryString();
        if (q != null && q.length() != 0) {
            response.sendRedirect(path + "?" + q);
        } else {
            response.sendRedirect(path);
        }
        return true;
    }

    private boolean serveWelcomeFileAsForward(RequestDispatcher dispatcher, boolean included, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!included && !request.getRequestURI().endsWith("/")) {
            this.redirectToAddSlash(request, response);
            return true;
        }
        if (dispatcher != null) {
            if (included) {
                dispatcher.include((ServletRequest)request, (ServletResponse)response);
            } else {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
            return true;
        }
        return false;
    }

    private void redirectToAddSlash(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer buf = request.getRequestURL();
        int param = buf.lastIndexOf(";");
        if (param < 0) {
            buf.append('/');
        } else {
            buf.insert(param, '/');
        }
        String q = request.getQueryString();
        if (q != null && q.length() != 0) {
            buf.append('?');
            buf.append(q);
        }
        response.setContentLength(0);
        response.sendRedirect(response.encodeRedirectURL(buf.toString()));
    }
}

