/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.timer;

import com.google.apphosting.runtime.timer.CpuSpeedExtractor;
import com.google.apphosting.runtime.timer.Timer;
import java.util.Arrays;

public class CpuRatioTimer
implements Timer {
    private final Timer cpuUsageTimer;
    private final Timer wallclockTimer;
    private final CpuSpeedExtractor cpuSpeedExtractor;
    private final Timer[] extraTimers;

    public CpuRatioTimer(Timer cpuUsageTimer, Timer wallclockTimer, CpuSpeedExtractor cpuSpeedExtractor, Timer[] extraTimers) {
        this.cpuUsageTimer = cpuUsageTimer;
        this.wallclockTimer = wallclockTimer;
        this.cpuSpeedExtractor = cpuSpeedExtractor;
        this.extraTimers = extraTimers;
    }

    @Override
    public void start() {
        this.cpuUsageTimer.start();
        this.wallclockTimer.start();
        for (Timer timer : this.extraTimers) {
            timer.start();
        }
    }

    @Override
    public void stop() {
        this.cpuUsageTimer.stop();
        this.wallclockTimer.stop();
        for (Timer timer : this.extraTimers) {
            timer.stop();
        }
    }

    @Override
    public void update() {
        this.cpuUsageTimer.update();
        this.wallclockTimer.update();
        for (Timer timer : this.extraTimers) {
            timer.update();
        }
    }

    public Timer getCpuUsageTimer() {
        return this.cpuUsageTimer;
    }

    public Timer getWallclockTimer() {
        return this.wallclockTimer;
    }

    public double getCpuRatio() {
        double cpuNanos = this.cpuUsageTimer.getNanoseconds();
        double wallclockNanos = this.wallclockTimer.getNanoseconds();
        return cpuNanos / wallclockNanos;
    }

    public long getCycleCount() {
        double seconds = (double)this.getNanoseconds() / 1.0E9;
        return (long)(seconds * (double)this.cpuSpeedExtractor.getCyclesPerSecond());
    }

    @Override
    public long getNanoseconds() {
        long total = this.cpuUsageTimer.getNanoseconds();
        for (Timer timer : this.extraTimers) {
            total += timer.getNanoseconds();
        }
        return total;
    }

    public String toString() {
        double cpuSeconds = (double)this.cpuUsageTimer.getNanoseconds() / 1.0E9;
        double wallclockSeconds = (double)this.wallclockTimer.getNanoseconds() / 1.0E9;
        StringBuilder builder = new StringBuilder(String.format("%.3f CPU / %.3f wallclock (%.1f%%), %.3f Mcycles@%.1fGHz", cpuSeconds, wallclockSeconds, 100.0 * this.getCpuRatio(), (double)this.getCycleCount() / 1000000.0, (double)this.cpuSpeedExtractor.getCyclesPerSecond() / 1.0E9));
        if (this.extraTimers.length > 0) {
            builder.append(Arrays.toString(this.extraTimers));
        }
        return builder.toString();
    }
}

