/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.timer;

import com.google.apphosting.runtime.timer.AbstractIntervalTimer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

class JmxCpuTimer
extends AbstractIntervalTimer {
    private static final ThreadMXBean THREAD_MX = ManagementFactory.getThreadMXBean();
    private final long threadId;

    public JmxCpuTimer(Thread thread) {
        this.threadId = thread.getId();
        THREAD_MX.setThreadCpuTimeEnabled(true);
    }

    public static boolean isAvailable() {
        return THREAD_MX.isThreadCpuTimeSupported();
    }

    @Override
    protected long getCurrent() {
        return THREAD_MX.getThreadCpuTime(this.threadId);
    }
}

