/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.timer;

import com.google.apphosting.runtime.timer.Timer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;

class JmxThreadGroupCpuTimer
implements Timer {
    private static final ThreadMXBean THREAD_MX = ManagementFactory.getThreadMXBean();
    private static final int MAX_THREADS = 64;
    protected volatile boolean running = false;
    private final ThreadGroup threadGroup;
    private final Map<Thread, Long> lastCounterMap;
    private long currentSum;

    public JmxThreadGroupCpuTimer(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
        this.lastCounterMap = new HashMap<Thread, Long>();
        THREAD_MX.setThreadCpuTimeEnabled(true);
    }

    public static boolean isAvailable() {
        return THREAD_MX.isThreadCpuTimeSupported();
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            throw new IllegalStateException("already running");
        }
        this.update();
        this.running = true;
    }

    @Override
    public synchronized void stop() {
        if (!this.running) {
            throw new IllegalStateException("not running");
        }
        this.update();
        this.running = false;
    }

    @Override
    public synchronized void update() {
        Thread[] threads = new Thread[64];
        int activeThreads = this.threadGroup.enumerate(threads);
        for (int i = 0; i < activeThreads; ++i) {
            Thread thread = threads[i];
            long counter = THREAD_MX.getThreadCpuTime(thread.getId());
            if (counter == -1L) continue;
            Long last = this.lastCounterMap.get(thread);
            System.err.println(thread + ": " + counter + " (vs. " + last + "), running = " + this.running);
            if (last != null) {
                long diff = counter - last;
                this.currentSum += diff;
            } else if (this.running) {
                this.currentSum += counter;
                System.err.println("currentSum = " + this.currentSum);
            }
            this.lastCounterMap.put(thread, counter);
        }
    }

    @Override
    public synchronized long getNanoseconds() {
        this.update();
        return this.currentSum;
    }

    public String toString() {
        return String.format("%.3f", (double)this.getNanoseconds() / 1.0E9);
    }
}

