/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.timer;

import com.google.apphosting.runtime.timer.CpuRatioTimer;
import com.google.apphosting.runtime.timer.CpuSpeedExtractorFactory;
import com.google.apphosting.runtime.timer.JmxCpuTimer;
import com.google.apphosting.runtime.timer.JmxThreadGroupCpuTimer;
import com.google.apphosting.runtime.timer.Timer;
import com.google.apphosting.runtime.timer.TimerSet;
import com.google.apphosting.runtime.timer.WallclockTimer;
import com.google.common.flogger.GoogleLogger;

public class TimerFactory {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final TimerSet[] timerSets;
    private final CpuSpeedExtractorFactory cpuSpeedExtractorFactory;
    private final boolean isCpuTimerAvailable;

    public TimerFactory(long cyclesPerSecond, TimerSet ... timerSets) {
        this.timerSets = timerSets;
        this.cpuSpeedExtractorFactory = new CpuSpeedExtractorFactory(cyclesPerSecond);
        if (JmxCpuTimer.isAvailable()) {
            this.isCpuTimerAvailable = true;
            ((GoogleLogger.Api)logger.atInfo()).log("JMX CPU timing information is available.");
        } else {
            this.isCpuTimerAvailable = false;
            ((GoogleLogger.Api)logger.atWarning()).log("JMX CPU timing information is NOT available, wallclock time will be used instead!");
        }
    }

    public Timer getWallclockTimer() {
        return new WallclockTimer();
    }

    public Timer getCpuCycleTimer(Thread thread) {
        if (this.isCpuTimerAvailable) {
            return new JmxCpuTimer(thread);
        }
        throw new UnsupportedOperationException("JMX CPU timing not available.");
    }

    public Timer getThreadGroupCpuTimer(ThreadGroup threadGroup) {
        if (this.isCpuTimerAvailable) {
            return new JmxThreadGroupCpuTimer(threadGroup);
        }
        throw new UnsupportedOperationException("JMX CPU timing not available.");
    }

    public CpuRatioTimer getCpuRatioTimer(Thread thread) {
        Timer[] timers = new Timer[this.timerSets.length];
        for (int i = 0; i < this.timerSets.length; ++i) {
            timers[i] = this.timerSets[i].createTimer();
        }
        return new CpuRatioTimer(this.getCpuCycleTimer(thread), this.getWallclockTimer(), this.cpuSpeedExtractorFactory.getExtractor(), timers);
    }

    public CpuRatioTimer getCpuRatioTimer(ThreadGroup threadGroup) {
        Timer[] timers = new Timer[this.timerSets.length];
        for (int i = 0; i < this.timerSets.length; ++i) {
            timers[i] = this.timerSets[i].createTimer();
        }
        return new CpuRatioTimer(this.getThreadGroupCpuTimer(threadGroup), this.getWallclockTimer(), this.cpuSpeedExtractorFactory.getExtractor(), timers);
    }
}

