/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.XmlUtils;
import com.google.common.base.CharMatcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

abstract class AbstractConfigXmlReader<T> {
    final String appDir;
    final boolean required;
    private static final Logger logger = Logger.getLogger(AbstractConfigXmlReader.class.getName());
    private static final CharMatcher INVALID_TAG_CHARS = CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('A', 'Z')).or(CharMatcher.anyOf("_.-")).negate();

    AbstractConfigXmlReader(String appDir, boolean required) {
        if (appDir.length() > 0 && appDir.charAt(appDir.length() - 1) != File.separatorChar) {
            appDir = appDir + File.separatorChar;
        }
        this.appDir = appDir;
        this.required = required;
    }

    public String getFilename() {
        return this.appDir + this.getRelativeFilename();
    }

    abstract String getRelativeFilename();

    abstract T processXml(InputStream var1);

    T readConfigXml() {
        T configXml;
        if (!this.required && !this.fileExists()) {
            return null;
        }
        try (InputStream is = this.getInputStream();){
            configXml = this.processXml(is);
            logger.fine("Successfully processed " + this.getFilename());
        }
        catch (Exception e) {
            String msg = "Received exception processing " + this.getFilename();
            logger.log(Level.SEVERE, msg, e);
            if (e instanceof AppEngineConfigException) {
                throw (AppEngineConfigException)e;
            }
            throw new AppEngineConfigException(msg, e);
        }
        return configXml;
    }

    boolean fileExists() {
        return new File(this.getFilename()).exists();
    }

    protected InputStream getInputStream() {
        try {
            return new FileInputStream(this.getFilename());
        }
        catch (FileNotFoundException fnfe) {
            throw new AppEngineConfigException("Could not locate " + new File(this.getFilename()).getAbsolutePath(), fnfe);
        }
    }

    String stringContents(Element element) {
        String text = XmlUtils.getText(element);
        if (text.isEmpty()) {
            throw new AppEngineConfigException(this.getFilename() + " has bad contents in <" + AbstractConfigXmlReader.sanitizeTag(element.getTagName()) + ">");
        }
        return CharMatcher.whitespace().trimFrom(text);
    }

    static String sanitizeTag(String tag) {
        return INVALID_TAG_CHARS.replaceFrom((CharSequence)tag, '?');
    }
}

