/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.runtime;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.base.protos.Status;
import com.google.apphosting.base.protos.api.RemoteApiPb;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.flogger.GoogleLogger;
import java.util.Optional;

public final class ApiProxyUtils {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    private ApiProxyUtils() {
    }

    public static ApiProxy.ApiProxyException convertApiError(RuntimePb.APIResponse apiResponse, String packageName, String methodName, GoogleLogger logger) {
        RuntimePb.APIResponse.ERROR error = RuntimePb.APIResponse.ERROR.forNumber(apiResponse.getError());
        switch (error) {
            case CALL_NOT_FOUND: {
                return new ApiProxy.CallNotFoundException(packageName, methodName);
            }
            case SECURITY_VIOLATION: {
                ((GoogleLogger.Api)logger.atSevere()).log("Security violation: invalid request id used!");
                return new ApiProxy.UnknownException(packageName, methodName);
            }
            case CAPABILITY_DISABLED: {
                return new ApiProxy.CapabilityDisabledException(apiResponse.getErrorMessage(), packageName, methodName);
            }
            case OVER_QUOTA: {
                return new ApiProxy.OverQuotaException(apiResponse.getErrorMessage(), packageName, methodName);
            }
            case REQUEST_TOO_LARGE: {
                return new ApiProxy.RequestTooLargeException(packageName, methodName);
            }
            case RESPONSE_TOO_LARGE: {
                return new ApiProxy.ResponseTooLargeException(packageName, methodName);
            }
            case PARSE_ERROR: 
            case BAD_REQUEST: {
                return new ApiProxy.ArgumentException(packageName, methodName);
            }
            case CANCELLED: {
                return new ApiProxy.CancelledException(packageName, methodName);
            }
            case BUFFER_ERROR: {
                ((GoogleLogger.Api)logger.atSevere()).log("API returned BUFFER_ERROR, but shared buffers no longer supported.");
                return new ApiProxy.ArgumentException(packageName, methodName);
            }
            case FEATURE_DISABLED: {
                return new ApiProxy.FeatureNotEnabledException("%s.%s " + apiResponse.getErrorMessage(), packageName, methodName);
            }
            case RPC_ERROR: {
                return ApiProxyUtils.convertApiResponseRpcErrorToException(apiResponse.getRpcError(), packageName, methodName, apiResponse.getRpcApplicationError(), apiResponse.getErrorMessage(), logger);
            }
        }
        return new ApiProxy.UnknownException(packageName, methodName);
    }

    private static ApiProxy.ApiProxyException convertApiResponseRpcErrorToException(RuntimePb.APIResponse.RpcError rpcError, String packageName, String methodName, int applicationError, String errorDetail, GoogleLogger logger) {
        ((GoogleLogger.Api)logger.atWarning()).log("RPC failed : %s : %s", (Object)rpcError, (Object)errorDetail);
        if (rpcError == null) {
            return new ApiProxy.UnknownException(packageName, methodName);
        }
        switch (rpcError) {
            case DEADLINE_EXCEEDED: {
                return new ApiProxy.ApiDeadlineExceededException(packageName, methodName);
            }
            case APPLICATION_ERROR: {
                return new ApiProxy.ApplicationException(applicationError, errorDetail);
            }
        }
        return new ApiProxy.UnknownException(packageName, methodName);
    }

    public static ApiProxy.ApiProxyException getRpcError(String packageName, String methodName, Status.StatusProto status, int applicationError, String errorDetail, Throwable cause) {
        Optional<ApiProxy.ApiProxyException> statusException = ApiProxyUtils.statusException(status, packageName, methodName, cause);
        if (statusException.isPresent()) {
            return statusException.get();
        }
        if (applicationError == 9 && "memcache".equals(packageName)) {
            return new ApiProxy.CapabilityDisabledException(errorDetail, packageName, methodName);
        }
        return new ApiProxy.ApplicationException(applicationError, errorDetail);
    }

    public static ApiProxy.ApiProxyException getApiError(String packageName, String methodName, RemoteApiPb.Response response, GoogleLogger logger) {
        RuntimePb.APIResponse apiResponse = RuntimePb.APIResponse.newBuilder().setError(ApiProxyUtils.remoteApiErrorToApiResponseError(response).getNumber()).setPb(response.getResponse()).build();
        return ApiProxyUtils.getApiError(packageName, methodName, apiResponse, logger);
    }

    public static ApiProxy.ApiProxyException getApiError(String packageName, String methodName, RuntimePb.APIResponse apiResponse, GoogleLogger logger) {
        ((GoogleLogger.Api)logger.atWarning()).log("Received error from APIHost : %s : %s", apiResponse.getError(), (Object)apiResponse.getErrorMessage());
        return ApiProxyUtils.convertApiError(apiResponse, packageName, methodName, logger);
    }

    @VisibleForTesting
    public static Optional<ApiProxy.ApiProxyException> statusException(Status.StatusProto status, String packageName, String methodName, Throwable cause) {
        switch (status.getSpace()) {
            case "generic": {
                if (status.getCode() == 1) {
                    return Optional.of(new ApiProxy.CancelledException(packageName, methodName));
                }
                return Optional.empty();
            }
            case "RPC": {
                if (status.getCode() == 4) {
                    return Optional.of(new ApiProxy.ApiDeadlineExceededException(packageName, methodName));
                }
                return Optional.of(new ApiProxy.UnknownException(packageName, methodName, cause));
            }
        }
        return Optional.empty();
    }

    public static RuntimePb.APIResponse.ERROR remoteApiErrorToApiResponseError(RemoteApiPb.Response responsePb) {
        if (!responsePb.hasRpcError()) {
            return RuntimePb.APIResponse.ERROR.OK;
        }
        int code = responsePb.getRpcError().getCode();
        RemoteApiPb.RpcError.ErrorCode[] errorCodes = RemoteApiPb.RpcError.ErrorCode.values();
        if (code >= 0 && code < errorCodes.length) {
            RemoteApiPb.RpcError.ErrorCode errorCode = errorCodes[code];
            try {
                return RuntimePb.APIResponse.ERROR.valueOf(errorCode.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        ((GoogleLogger.Api)logger.atWarning()).log("Unknown error code %s", code);
        return RuntimePb.APIResponse.ERROR.RPC_ERROR;
    }
}

