/*
 * Decompiled with CFR 0.152.
 */
package com.google.borg.borgcron;

import com.google.borg.borgcron.GrocLexer;
import com.google.borg.borgcron.GrocParser;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class GrocTimeSpecification {
    private final Set<Integer> months;
    private final Set<Integer> ordinals;
    private final Set<Integer> weekdays;
    private final Set<Integer> monthdays;
    private final Integer interval;
    private final String intervalPeriod;
    private final int hour;
    private final int minute;
    private final int seconds;
    private final IntegerPair startHourMinute;
    private final IntegerPair endHourMinute;
    private final TimeZone timezone;
    private static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");
    private static final long MS_PER_HOUR = 3600000L;
    private static final long MS_PER_MINUTE = 60000L;
    private static final String[] ORDINALS = new String[]{"1st", "2nd", "3rd", "4th", "5th"};
    private static final String[] WEEKDAY_NAMES = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
    private static final String[] MONTH_NAMES = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static final IntegerPair START_OF_DAY = new IntegerPair(0, 0);
    private static final IntegerPair END_OF_DAY = new IntegerPair(23, 59);

    private static void checkEntriesAreInRange(Set<Integer> inputSet, int lowerLimit, int upperLimit, String spec, String setName) {
        for (Integer value : inputSet) {
            if (value >= lowerLimit && value <= upperLimit) continue;
            throw new IllegalArgumentException("Specification '" + spec + "': " + setName + " is out of range [" + lowerLimit + ".." + upperLimit + "]");
        }
    }

    private static int getLastDayOfMonth(int month) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                return 29;
            }
        }
        return 0;
    }

    public static GrocTimeSpecification create(String spec, TimeZone timezone) {
        GrocLexer lexer = new GrocLexer((CharStream)new ANTLRStringStream(spec));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        GrocParser parser = new GrocParser((TokenStream)tokens);
        parser.init();
        try {
            parser.timespec();
        }
        catch (RecognitionException e) {
            throw new IllegalArgumentException("Specification '" + spec + "' is invalid.", e);
        }
        if (timezone == null) {
            timezone = UTC_ZONE;
        }
        String period = parser.getIntervalPeriod();
        boolean hasPeriod = !parser.getIntervalPeriod().isEmpty();
        boolean synchronised = parser.getSynchronized();
        String startTime = parser.getStartTime();
        String endTime = parser.getEndTime();
        Integer interval = parser.getInterval();
        if (hasPeriod && interval == null) {
            throw new IllegalArgumentException("Specification '" + spec + "', appears to be periodic ('every...') but is missing an interval ('seconds', 'minutes), period='" + period + "'");
        }
        GrocTimeSpecification.checkEntriesAreInRange(parser.getOrdinals(), 1, 5, spec, "ordinals");
        GrocTimeSpecification.checkEntriesAreInRange(parser.getWeekdays(), 0, 6, spec, "weekdays");
        GrocTimeSpecification.checkEntriesAreInRange(parser.getMonths(), 1, 12, spec, "months");
        GrocTimeSpecification.checkEntriesAreInRange(parser.getMonthdays(), 1, 31, spec, "days of month");
        if (!parser.getMonths().isEmpty() && !parser.getMonthdays().isEmpty()) {
            boolean validDays = false;
            int lastMonth = -1;
            int minDayOfMonth = 32;
            for (Integer day : parser.getMonthdays()) {
                if (day >= minDayOfMonth) continue;
                minDayOfMonth = day;
            }
            for (Integer month : parser.getMonths()) {
                lastMonth = month;
                if (minDayOfMonth > GrocTimeSpecification.getLastDayOfMonth(month)) continue;
                validDays = true;
                break;
            }
            if (!validDays) {
                throw new IllegalArgumentException("Specification '" + spec + "': invalid day of month, got day " + minDayOfMonth + " of month " + lastMonth);
            }
        }
        if (interval != null) {
            GrocTimeSpecification gts = new GrocTimeSpecification(interval, parser.getIntervalPeriod(), startTime, endTime, synchronised, timezone);
            return gts;
        }
        GrocTimeSpecification gts = new GrocTimeSpecification(parser.getOrdinals(), parser.getMonths(), parser.getWeekdays(), parser.getMonthdays(), parser.getTime(), timezone);
        return gts;
    }

    public static GrocTimeSpecification create(String spec) {
        return GrocTimeSpecification.create(spec, UTC_ZONE);
    }

    public GrocTimeSpecification(Set<Integer> ordinals, Set<Integer> months, Set<Integer> weekdays, Set<Integer> monthdays, String time, TimeZone timezone) {
        this.timezone = timezone;
        this.ordinals = ordinals;
        this.months = months;
        this.weekdays = weekdays;
        this.monthdays = monthdays;
        if (!weekdays.isEmpty() && !monthdays.isEmpty()) {
            throw new IllegalArgumentException("cannot specify both monthdays and weekdays");
        }
        GrocTimeSpecification.verifyWithinLimits(ordinals, 1, 5, "ordinals");
        GrocTimeSpecification.verifyWithinLimits(weekdays, 0, 6, "weekdays");
        GrocTimeSpecification.verifyWithinLimits(months, 1, 12, "months");
        GrocTimeSpecification.verifyWithinLimits(monthdays, 1, 31, "day of month");
        if (!months.isEmpty() && !monthdays.isEmpty()) {
            Calendar calendar = Calendar.getInstance();
            boolean noValidDates = true;
            int lastMonth = -1;
            int minMonthday = 32;
            for (int day : monthdays) {
                if (day >= minMonthday) continue;
                minMonthday = day;
            }
            Iterator<Integer> iterator = months.iterator();
            while (iterator.hasNext()) {
                int month;
                lastMonth = month = iterator.next().intValue();
                calendar.set(4, month - 1, 1);
                if (minMonthday > calendar.getActualMaximum(5)) continue;
                noValidDates = false;
                break;
            }
            if (noValidDates) {
                throw new IllegalArgumentException("invalid day of month, got day " + minMonthday + " of month " + lastMonth);
            }
        }
        IntegerPair timeHourMinute = GrocTimeSpecification.parseTime(time);
        this.hour = timeHourMinute.first;
        this.minute = timeHourMinute.second;
        this.interval = null;
        this.seconds = 0;
        this.startHourMinute = null;
        this.endHourMinute = null;
        this.intervalPeriod = "";
    }

    public GrocTimeSpecification(int interval, String period, String startTime, String endTime, boolean synchronize, TimeZone timezone) {
        this.hour = 0;
        this.minute = 0;
        this.months = new HashSet<Integer>();
        this.ordinals = new HashSet<Integer>();
        this.weekdays = new HashSet<Integer>();
        this.monthdays = new HashSet<Integer>();
        this.timezone = timezone;
        if (interval <= 0) {
            throw new IllegalArgumentException("interval must be greater than zero");
        }
        this.interval = interval;
        this.intervalPeriod = period;
        this.seconds = this.intervalPeriod.equals("hours") ? this.interval * 3600 : this.interval * 60;
        if (!startTime.isEmpty()) {
            this.startHourMinute = GrocTimeSpecification.parseTime(startTime);
            this.endHourMinute = GrocTimeSpecification.parseTime(endTime);
        } else if (synchronize) {
            if (this.seconds > 86400 || 86400 % this.seconds != 0) {
                throw new IllegalArgumentException("can only use synchronized for periods that divide evenly into 24 hours");
            }
            this.startHourMinute = START_OF_DAY;
            this.endHourMinute = END_OF_DAY;
        } else {
            this.startHourMinute = null;
            this.endHourMinute = null;
        }
    }

    private static void verifyWithinLimits(Set<Integer> inputSet, int lowerLimit, int upperLimit, String setName) {
        for (int entry : inputSet) {
            if (entry >= lowerLimit && entry <= upperLimit) continue;
            throw new IllegalArgumentException(setName + " must be between " + lowerLimit + " and " + upperLimit + " inclusive, got " + inputSet);
        }
    }

    private static IntegerPair parseTime(String timeString) {
        int colonIndex = timeString.indexOf(":");
        int hour = Integer.parseInt(timeString.substring(0, colonIndex));
        int minute = Integer.parseInt(timeString.substring(colonIndex + 1));
        return new IntegerPair(hour, minute);
    }

    private static String formatTime(int hour, int minute) {
        return new Formatter(new StringBuilder(5), null).format("%d:%02d", hour, minute).toString();
    }

    public List<Date> getMatches(Date start, int count) {
        ArrayList<Date> results = new ArrayList<Date>();
        Date next = start;
        for (int i = 0; i < count; ++i) {
            next = this.getMatch(next);
            results.add(next);
        }
        return results;
    }

    public Date getMatch(Date start) {
        if (this.interval != null && this.startHourMinute != null) {
            return this.getMatchRangedInterval(start);
        }
        if (this.interval != null) {
            return this.getMatchInterval(start);
        }
        return this.getMatchSpecificTime(start);
    }

    private Date getMatchRangedInterval(Date now) {
        Date startDate = this.getPreviousDate(now, this.startHourMinute);
        long startDeltaMillis = now.getTime() - startDate.getTime();
        long millis = (long)this.seconds * 1000L;
        long numIntervals = (startDeltaMillis + millis) / millis;
        long intervalMillis = startDate.getTime() + numIntervals * millis;
        Date intervalDate = new Date(intervalMillis);
        Date nextStartDate = this.getNextDate(now, this.startHourMinute);
        if (this.timeIsInRange(now) && this.timeIsInRange(intervalDate) && intervalDate.before(nextStartDate)) {
            return intervalDate;
        }
        return nextStartDate;
    }

    private boolean timeIsInRange(Date utcDate) {
        Date previousEndDate;
        Date previousStartDate = this.getPreviousDate(utcDate, this.startHourMinute);
        if (previousStartDate.after(previousEndDate = this.getPreviousDate(utcDate, this.endHourMinute))) {
            return true;
        }
        return utcDate.equals(previousEndDate);
    }

    private Date getPreviousDate(Date utcDate, IntegerPair targetHourMinute) {
        Calendar localDate = Calendar.getInstance(this.timezone);
        localDate.setTime(utcDate);
        Date result;
        while ((result = this.combineDateAndTime(localDate.get(1), localDate.get(2), localDate.get(5), targetHourMinute)).after(utcDate)) {
            localDate.add(5, -1);
        }
        return result;
    }

    private Date getNextDate(Date utcDate, IntegerPair targetHourMinute) {
        Calendar localDate = Calendar.getInstance(this.timezone);
        localDate.setTime(utcDate);
        Date result;
        while (!(result = this.combineDateAndTime(localDate.get(1), localDate.get(2), localDate.get(5), targetHourMinute)).after(utcDate)) {
            localDate.add(5, 1);
        }
        return result;
    }

    private Date combineDateAndTime(int year, int month, int day, IntegerPair hourMinute) {
        Calendar utcCalendar = Calendar.getInstance(UTC_ZONE);
        utcCalendar.set(year, month, day, hourMinute.first, hourMinute.second, 0);
        utcCalendar.set(14, 0);
        long utcMillis = utcCalendar.getTimeInMillis();
        if (this.timezone.getDSTSavings() == 0) {
            return new Date(utcMillis - (long)this.timezone.getRawOffset());
        }
        long standardMillis = utcMillis - (long)this.timezone.getRawOffset();
        long daylightMillis = standardMillis - (long)this.timezone.getDSTSavings();
        Calendar standardCalendar = Calendar.getInstance(this.timezone);
        Calendar daylightCalendar = Calendar.getInstance(this.timezone);
        standardCalendar.setTimeInMillis(standardMillis);
        daylightCalendar.setTimeInMillis(daylightMillis);
        boolean standardMatches = this.timeEquals(standardCalendar, year, month, day, hourMinute);
        boolean daylightMatches = this.timeEquals(daylightCalendar, year, month, day, hourMinute);
        if (standardMatches && daylightMatches) {
            long resultMillis = Math.min(standardMillis, daylightMillis);
            return new Date(resultMillis);
        }
        if (standardMatches) {
            return new Date(standardMillis);
        }
        if (daylightMatches) {
            return new Date(daylightMillis);
        }
        utcCalendar.set(12, 0);
        return new Date(utcCalendar.getTimeInMillis() - (long)this.timezone.getRawOffset());
    }

    private boolean timeEquals(Calendar calendar, int year, int month, int day, IntegerPair hourMinute) {
        if (calendar.get(1) != year) {
            return false;
        }
        if (calendar.get(2) != month) {
            return false;
        }
        if (calendar.get(5) != day) {
            return false;
        }
        if (calendar.get(11) != hourMinute.first) {
            return false;
        }
        if (calendar.get(12) != hourMinute.second) {
            return false;
        }
        return calendar.get(13) == 0;
    }

    private Date getMatchInterval(Date start) {
        Date result = this.intervalPeriod.equals("hours") ? new Date(start.getTime() + (long)this.interval.intValue() * 3600000L) : new Date(start.getTime() + (long)this.interval.intValue() * 60000L);
        result.setSeconds(0);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private Date getMatchSpecificTime(Date start) {
        calendar = Calendar.getInstance(this.timezone);
        calendar.setTime(start);
        startYear = calendar.get(1);
        startMonth = calendar.get(2) + 1;
        startDayOfMonth = calendar.get(5);
        startHour = calendar.get(11);
        startMinute = calendar.get(12);
        startDstOffset = calendar.get(16);
        maxMonthsToConsider = 48;
        monthGen = new NextGenerator(startMonth, this.months);
        monthsConsidered = 0;
        block0: while (true) {
            nextMonthWrapPair = monthGen.next();
            nextMonth = nextMonthWrapPair.first;
            yearWraps = nextMonthWrapPair.second;
            ++monthsConsidered;
            calendar.set(startYear + yearWraps, nextMonth - 1, 1);
            dayMatches = this.findDays(calendar);
            if (dayMatches.isEmpty()) {
                if (monthsConsidered >= 48) {
                    throw new AssertionError((Object)"no matching days");
                }
                continue;
            }
            if (calendar.get(1) == startYear && nextMonth == startMonth) {
                while (!dayMatches.isEmpty() && dayMatches.get(0) < startDayOfMonth) {
                    dayMatches.remove(0);
                }
                if (!dayMatches.isEmpty() && dayMatches.get(0) == startDayOfMonth) {
                    if (startHour > this.hour) {
                        dayMatches.remove(0);
                    } else if (startHour == this.hour && startMinute >= this.minute) {
                        inTheFallbackHour = false;
                        if (startDstOffset > 0) {
                            calendar.set(startYear, startMonth - 1, startDayOfMonth, startHour, startMinute, 0);
                            if (calendar.get(16) == 0) {
                                inTheFallbackHour = true;
                            }
                        }
                        if (!inTheFallbackHour) {
                            dayMatches.remove(0);
                        }
                    }
                }
            }
            do {
                if (!dayMatches.isEmpty()) ** break;
                continue block0;
                candidateDay = dayMatches.get(0);
                dayMatches.remove(0);
                beforeDstOffsetMillis = calendar.get(16);
                calendar.set(startYear + yearWraps, nextMonth - 1, candidateDay, this.hour, this.minute, 0);
                calendar.set(14, 0);
                dstOffsetDifferenceMillis = beforeDstOffsetMillis - calendar.get(16);
                if (dstOffsetDifferenceMillis <= 0) continue;
                calendar.add(14, -dstOffsetDifferenceMillis);
                if (calendar.get(16) != 0 && !start.after(calendar.getTime())) continue;
                calendar.add(14, dstOffsetDifferenceMillis);
            } while ((calhour = calendar.get(11)) != this.hour);
            break;
        }
        return calendar.getTime();
    }

    List<Integer> findDays(Calendar candidate) {
        TreeSet<Integer> outDays = new TreeSet<Integer>();
        long original = candidate.getTimeInMillis();
        candidate.set(5, 1);
        int firstWeekDay = candidate.get(7) - 1;
        candidate.set(2, candidate.get(2) + 1);
        candidate.add(5, -1);
        int lastDayOfMonth = candidate.get(5);
        candidate.setTimeInMillis(original);
        if (this.monthdays.isEmpty()) {
            for (int ordinal : this.ordinals) {
                for (int weekday : this.weekdays) {
                    int day = (7 + weekday - firstWeekDay) % 7 + 1;
                    if ((day += 7 * (ordinal - 1)) > lastDayOfMonth) continue;
                    outDays.add(day);
                }
            }
        } else {
            for (int day : this.monthdays) {
                if (day > lastDayOfMonth) continue;
                outDays.add(day);
            }
        }
        return new ArrayList<Integer>(outDays);
    }

    public boolean equals(Object other) {
        if (!(other instanceof GrocTimeSpecification)) {
            return false;
        }
        GrocTimeSpecification that = (GrocTimeSpecification)other;
        if (this.seconds != 0) {
            if (this.startHourMinute != null) {
                return this.seconds == that.seconds && this.startHourMinute.equals(that.startHourMinute) && this.endHourMinute.equals(that.endHourMinute) && (this.timezone.equals(that.timezone) || START_OF_DAY.equals(this.startHourMinute) && END_OF_DAY.equals(this.endHourMinute));
            }
            return that.startHourMinute == null && this.seconds == that.seconds;
        }
        return that.interval == null && this.ordinals.equals(that.ordinals) && this.months.equals(that.months) && this.monthdays.equals(that.monthdays) && this.weekdays.equals(that.weekdays) && this.hour == that.hour && this.minute == that.minute && this.timezone.equals(that.timezone);
    }

    public int hashCode() {
        int hashCode = 1;
        if (this.seconds != 0) {
            if (this.startHourMinute != null) {
                hashCode = hashCode * 17 + this.startHourMinute.hashCode();
                hashCode = hashCode * 17 + this.endHourMinute.hashCode();
                if (!this.startHourMinute.equals(START_OF_DAY) || !this.endHourMinute.equals(END_OF_DAY)) {
                    hashCode = hashCode * 17 + this.timezone.hashCode();
                }
            }
            hashCode = hashCode * 17 + this.seconds;
        } else {
            hashCode = hashCode * 17 + this.timezone.hashCode();
            hashCode = hashCode * 17 + this.ordinals.hashCode();
            hashCode = hashCode * 17 + this.months.hashCode();
            hashCode = hashCode * 17 + this.monthdays.hashCode();
            hashCode = hashCode * 17 + this.weekdays.hashCode();
            hashCode = hashCode * 17 + this.hour;
            hashCode = hashCode * 17 + this.minute;
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.interval != null) {
            sb.append("every ");
            sb.append(this.interval);
            sb.append(' ');
            sb.append(this.intervalPeriod);
            if (this.startHourMinute != null) {
                if (this.startHourMinute.first == 0 && this.startHourMinute.second == 0 && this.endHourMinute.first == 23 && this.endHourMinute.second == 59) {
                    sb.append(" synchronized");
                } else {
                    sb.append(" from ");
                    sb.append(GrocTimeSpecification.formatTime(this.startHourMinute.first, this.startHourMinute.second));
                    sb.append(" to ");
                    sb.append(GrocTimeSpecification.formatTime(this.endHourMinute.first, this.endHourMinute.second));
                }
            }
        } else {
            if (this.ordinals.size() == 5) {
                sb.append("every ");
            } else if (!this.ordinals.isEmpty()) {
                this.appendList(sb, this.ordinals, 1, ORDINALS);
                sb.append(' ');
            }
            if (!this.weekdays.isEmpty()) {
                if (this.weekdays.size() == 7) {
                    sb.append("day ");
                } else {
                    this.appendList(sb, this.weekdays, 0, WEEKDAY_NAMES);
                    sb.append(' ');
                }
            }
            if (!this.monthdays.isEmpty()) {
                int n = this.monthdays.size();
                for (int i = 1; i <= 31; ++i) {
                    if (!this.monthdays.contains(i)) continue;
                    sb.append(i);
                    if (--n <= 0) continue;
                    sb.append(',');
                }
                sb.append(' ');
            }
            if (this.months.size() < 12) {
                sb.append("of ");
                this.appendList(sb, this.months, 1, MONTH_NAMES);
                sb.append(' ');
            } else if (this.weekdays.isEmpty()) {
                sb.append("of month ");
            }
            sb.append(GrocTimeSpecification.formatTime(this.hour, this.minute));
        }
        return sb.toString();
    }

    private void appendList(StringBuilder builder, Set<Integer> set, int offset, String ... labels) {
        int n = set.size();
        for (int i = 0; i < labels.length; ++i) {
            if (!set.contains(i + offset)) continue;
            builder.append(labels[i]);
            if (--n <= 0) break;
            builder.append(',');
        }
    }

    static class IntegerPair {
        public final int first;
        public final int second;

        IntegerPair(int first, int second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object other) {
            return other instanceof IntegerPair && this.first == ((IntegerPair)other).first && this.second == ((IntegerPair)other).second;
        }

        public int hashCode() {
            return this.first ^ this.second;
        }

        public String toString() {
            return "<" + this.first + "," + this.second + ">";
        }
    }

    static class NextGenerator {
        private int start;
        private final Set<Integer> matches;
        private List<Integer> remaining;
        private int wrapcount;

        NextGenerator(Integer start, Set<Integer> matches) {
            this.start = start;
            this.matches = new TreeSet<Integer>(matches);
            this.remaining = new ArrayList<Integer>(this.matches);
            this.wrapcount = 0;
        }

        public IntegerPair next() {
            while (!this.remaining.isEmpty() && this.remaining.get(0) < this.start) {
                this.remaining.remove(0);
            }
            if (this.remaining.isEmpty()) {
                this.remaining = new ArrayList<Integer>(this.matches);
                ++this.wrapcount;
            }
            this.start = this.remaining.get(0);
            this.remaining.remove(0);
            return new IntegerPair(this.start, this.wrapcount);
        }
    }
}

