/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.GeneratedMetadataProto;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;

public class InternalProtobufMeta {
    private static final String PROTOBUF_META_FILE = "protobuf.meta";
    private static final InternalProtobufMeta INSTANCE = new InternalProtobufMeta(InternalProtobufMeta.loadMetadata());
    private final List<GeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry> extensions = new ArrayList<GeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry>();
    private final List<GeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> messages = new ArrayList<GeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry>();
    private final List<GeneratedMetadataProto.GeneratedMetadata.GeneratedEnumEntry> enums = new ArrayList<GeneratedMetadataProto.GeneratedMetadata.GeneratedEnumEntry>();

    private InternalProtobufMeta(List<GeneratedMetadataProto.GeneratedMetadata> metadatas) {
        HashSet<String> foundImmutable = new HashSet<String>();
        HashSet foundMutable = new HashSet();
        for (GeneratedMetadataProto.GeneratedMetadata metadata : metadatas) {
            for (GeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry generatedExtensionEntry : metadata.getExtensionList()) {
                if (!(generatedExtensionEntry.getImmutable() ? foundImmutable : foundMutable).add(generatedExtensionEntry.getName())) continue;
                this.extensions.add(generatedExtensionEntry);
            }
        }
        foundImmutable.clear();
        foundMutable.clear();
        for (GeneratedMetadataProto.GeneratedMetadata metadata : metadatas) {
            for (GeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry generatedMessageEntry : metadata.getGeneratedMessageList()) {
                if (!(generatedMessageEntry.getImmutable() ? foundImmutable : foundMutable).add(generatedMessageEntry.getName())) continue;
                this.messages.add(generatedMessageEntry);
            }
        }
        foundImmutable.clear();
        foundMutable.clear();
        for (GeneratedMetadataProto.GeneratedMetadata metadata : metadatas) {
            for (GeneratedMetadataProto.GeneratedMetadata.GeneratedEnumEntry generatedEnumEntry : metadata.getGeneratedEnumList()) {
                if (!(generatedEnumEntry.getImmutable() ? foundImmutable : foundMutable).add(generatedEnumEntry.getName())) continue;
                this.enums.add(generatedEnumEntry);
            }
        }
        ((ArrayList)this.extensions).trimToSize();
        ((ArrayList)this.messages).trimToSize();
        ((ArrayList)this.enums).trimToSize();
    }

    public static InternalProtobufMeta getInstance() {
        return INSTANCE;
    }

    public List<GeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry> getExtensions() {
        return this.extensions;
    }

    public List<GeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> getMessages() {
        return this.messages;
    }

    public List<GeneratedMetadataProto.GeneratedMetadata.GeneratedEnumEntry> getEnums() {
        return this.enums;
    }

    private static List<GeneratedMetadataProto.GeneratedMetadata> loadMetadata() {
        ClassLoader loader = InternalProtobufMeta.class.getClassLoader();
        ArrayList<GeneratedMetadataProto.GeneratedMetadata> metadatas = new ArrayList<GeneratedMetadataProto.GeneratedMetadata>();
        try {
            Enumeration<URL> urls = loader.getResources(PROTOBUF_META_FILE);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                metadatas.add(InternalProtobufMeta.load(url));
            }
            return metadatas;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load generated message meta data.", e);
        }
    }

    private static GeneratedMetadataProto.GeneratedMetadata load(URL url) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(url.openStream());){
            GeneratedMetadataProto.GeneratedMetadata generatedMetadata = GeneratedMetadataProto.GeneratedMetadata.parseFrom(is);
            return generatedMetadata;
        }
    }
}

