/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;

class ApplicationClassLoader
extends URLClassLoader {
    static final String COMPAT_PROPERTY = "appengine.api.legacy.repackaging";
    private final URL[] originalUrls;
    private final URL[] legacyUrls;
    private final URLClassLoader resourceLoader;
    boolean addedLegacyUrls;

    ApplicationClassLoader(URL[] urls, URL[] legacyUrls, ClassLoader parent, boolean alwaysScanClassDirs) {
        super(alwaysScanClassDirs ? urls : ApplicationClassLoader.excludeClasslessDirectories(urls), parent);
        this.originalUrls = urls;
        this.legacyUrls = legacyUrls;
        this.resourceLoader = Arrays.equals(urls, super.getURLs()) ? null : new URLClassLoader(urls, parent);
    }

    URL[] getActualUrls() {
        return super.getURLs();
    }

    @Override
    public URL[] getURLs() {
        return (URL[])this.originalUrls.clone();
    }

    @Override
    public URL findResource(String name) {
        return this.resourceLoader == null ? super.findResource(name) : this.resourceLoader.findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return this.resourceLoader == null ? super.findResources(name) : this.resourceLoader.findResources(name);
    }

    private static URL[] excludeClasslessDirectories(URL[] urls) {
        ArrayList<URL> classfulUrls = new ArrayList<URL>();
        for (URL url : urls) {
            if (url.getPath().endsWith("/") && !ApplicationClassLoader.hasClasses(url)) continue;
            classfulUrls.add(url);
        }
        return classfulUrls.toArray(new URL[0]);
    }

    private static boolean hasClasses(URL directoryUrl) {
        try {
            File directory = new File(directoryUrl.toURI());
            return ApplicationClassLoader.hasClasses(directory);
        }
        catch (URISyntaxException e) {
            return true;
        }
    }

    private static boolean hasClasses(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!(file.isDirectory() ? ApplicationClassLoader.hasClasses(file) : file.getName().endsWith(".class"))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            if (!this.addedLegacyUrls && Boolean.getBoolean(COMPAT_PROPERTY)) {
                for (URL url : this.legacyUrls) {
                    this.addURL(url);
                }
                this.addedLegacyUrls = true;
                return super.findClass(name);
            }
            throw e;
        }
    }
}

