/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.runtime.AutoValue_ApplicationEnvironment_RuntimeConfiguration;
import com.google.auto.value.AutoValue;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ApplicationEnvironment {
    private final String appId;
    private final String versionId;
    private final Map<String, String> systemProperties;
    private final Map<String, String> environmentVariables;
    private final File rootDirectory;
    private static final String[] VISIBLE_PROPERTIES = new String[]{"file.encoding", "file.separator", "path.separator", "line.separator", "os.name", "java.vendor", "java.vendor.url", "java.class.version", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.vm.vendor", "java.vm.name", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name"};
    private RuntimeConfiguration runtimeConfiguration;
    private @Nullable Boolean useGoogleConnectorJ;

    public ApplicationEnvironment(String appId, String versionId, Map<String, String> extraSystemProperties, Map<String, String> environmentVariables, File rootDirectory, RuntimeConfiguration configuration) {
        this.appId = appId;
        this.versionId = versionId;
        this.systemProperties = new HashMap<String, String>(extraSystemProperties);
        this.rootDirectory = rootDirectory;
        for (String property : VISIBLE_PROPERTIES) {
            this.systemProperties.computeIfAbsent(property, System::getProperty);
        }
        this.systemProperties.put("user.dir", rootDirectory.getPath());
        this.environmentVariables = new HashMap<String, String>(environmentVariables);
        this.runtimeConfiguration = configuration;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public RuntimeConfiguration getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public boolean isCloudDebuggerDisabled() {
        return "1".equals(this.environmentVariables.get("CDBG_DISABLE"));
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public void setUseGoogleConnectorJ(@Nullable Boolean useGoogleConnectorJ) {
        this.useGoogleConnectorJ = useGoogleConnectorJ;
    }

    public boolean getUseGoogleConnectorJ() {
        return Optional.ofNullable(this.useGoogleConnectorJ).orElse(this.runtimeConfiguration.getUseGoogleConnectorJ());
    }

    @AutoValue
    public static abstract class RuntimeConfiguration {
        public static final RuntimeConfiguration DEFAULT_FOR_TEST = RuntimeConfiguration.builder().setCloudSqlJdbcConnectivityEnabled(false).setUseGoogleConnectorJ(false).build();

        public abstract boolean getCloudSqlJdbcConnectivityEnabled();

        public abstract boolean getUseGoogleConnectorJ();

        public static Builder builder() {
            return new AutoValue_ApplicationEnvironment_RuntimeConfiguration.Builder();
        }

        public abstract Builder toBuilder();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setCloudSqlJdbcConnectivityEnabled(boolean var1);

            public abstract Builder setUseGoogleConnectorJ(boolean var1);

            public abstract RuntimeConfiguration build();
        }
    }
}

