/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ClassPathUtils {
    private static final Logger logger = Logger.getLogger(ClassPathUtils.class.getName());
    private static final String RUNTIME_BASE_PROPERTY = "classpath.runtimebase";
    private static final String USE_MAVENJARS = "use.mavenjars";
    private static final String RUNTIME_IMPL_PROPERTY = "classpath.runtime-impl";
    private static final String RUNTIME_SHARED_PROPERTY = "classpath.runtime-shared";
    private static final String PREBUNDLED_PROPERTY = "classpath.prebundled";
    private static final String API_PROPERTY = "classpath.api-map";
    private static final String CONNECTOR_J_PROPERTY = "classpath.connector-j";
    private static final String APPENGINE_API_LEGACY_PROPERTY = "classpath.appengine-api-legacy";
    private static final String LEGACY_PROPERTY = "classpath.legacy";
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private final File root;
    private File frozenApiJarFile;

    public ClassPathUtils() {
        this(null);
    }

    public ClassPathUtils(File root) {
        String runtimeBase = System.getProperty(RUNTIME_BASE_PROPERTY);
        if (runtimeBase == null) {
            throw new RuntimeException("System property not defined: classpath.runtimebase");
        }
        this.root = root;
        if (!new File(runtimeBase, "java_runtime_launcher").exists()) {
            this.initForJava11OrAbove(runtimeBase);
            return;
        }
        boolean useMavenJars = Boolean.getBoolean(USE_MAVENJARS);
        String runtimeImplJar = null;
        String cloudDebuggerJar = null;
        String profilerJar = null;
        if (System.getenv("GAE_PROFILER_MODE") != null) {
            profilerJar = "profiler.jar";
            logger.log(Level.INFO, "AppEngine profiler enabled.");
        }
        if (Boolean.getBoolean("use.java11")) {
            runtimeImplJar = "runtime-impl.jar";
        } else {
            runtimeImplJar = "runtime-impl.jar";
            cloudDebuggerJar = "frozen_debugger.jar";
        }
        List<String> runtimeClasspathEntries = useMavenJars ? Arrays.asList("jars/runtime-impl.jar", cloudDebuggerJar, profilerJar) : Arrays.asList(runtimeImplJar, cloudDebuggerJar, "runtime-impl-third-party.jar", "runtime-appengine-api.jar");
        String runtimeClasspath = runtimeClasspathEntries.stream().filter(t -> t != null).map(s -> runtimeBase + "/" + s).collect(Collectors.joining(PATH_SEPARATOR));
        if (System.getProperty(RUNTIME_IMPL_PROPERTY) != null) {
            runtimeClasspath = System.getProperty(RUNTIME_IMPL_PROPERTY) + PATH_SEPARATOR + runtimeClasspath;
        }
        if (new File(runtimeBase, "runtime-rpc-plugins.jar").exists()) {
            runtimeClasspath = runtimeClasspath + ":" + runtimeBase + "/runtime-rpc-plugins.jar";
        }
        System.setProperty(RUNTIME_IMPL_PROPERTY, runtimeClasspath);
        logger.log(Level.INFO, "Using runtime classpath: " + runtimeClasspath);
        this.frozenApiJarFile = new File(new File(root, runtimeBase), "/appengine-api.jar");
        if (useMavenJars) {
            System.setProperty(RUNTIME_SHARED_PROPERTY, runtimeBase + "/jars/runtime-shared.jar");
            System.setProperty(API_PROPERTY, "1.0=" + runtimeBase + "/jars/appengine-api-1.0-sdk.jar");
            System.setProperty(APPENGINE_API_LEGACY_PROPERTY, runtimeBase + "/jars/appengine-api-legacy.jar");
        } else {
            System.setProperty(RUNTIME_SHARED_PROPERTY, runtimeBase + "/runtime-shared.jar");
            System.setProperty(API_PROPERTY, "1.0=" + runtimeBase + "/appengine-api.jar");
        }
        System.setProperty(CONNECTOR_J_PROPERTY, runtimeBase + "/jdbc-mysql-connector.jar");
        System.setProperty(PREBUNDLED_PROPERTY, runtimeBase + "/conscrypt.jar");
        System.setProperty(LEGACY_PROPERTY, runtimeBase + "/legacy.jar");
    }

    private void initForJava11OrAbove(String runtimeBase) {
        List<String> runtimeClasspathEntries = Arrays.asList("runtime-impl.jar");
        String runtimeClasspath = runtimeClasspathEntries.stream().filter(t -> t != null).map(s -> runtimeBase + "/" + s).collect(Collectors.joining(PATH_SEPARATOR));
        if (System.getProperty(RUNTIME_IMPL_PROPERTY) != null) {
            runtimeClasspath = System.getProperty(RUNTIME_IMPL_PROPERTY) + PATH_SEPARATOR + runtimeClasspath;
        }
        System.setProperty(RUNTIME_IMPL_PROPERTY, runtimeClasspath);
        logger.log(Level.INFO, "Using runtime classpath: " + runtimeClasspath);
        System.setProperty(RUNTIME_SHARED_PROPERTY, runtimeBase + "/runtime-shared.jar");
        this.frozenApiJarFile = new File(runtimeBase, "/appengine-api-1.0-sdk.jar");
    }

    public URL[] getRuntimeImplUrls() {
        return this.parseClasspath(System.getProperty(RUNTIME_IMPL_PROPERTY));
    }

    public URL[] getRuntimeSharedUrls() {
        return this.parseClasspath(System.getProperty(RUNTIME_SHARED_PROPERTY));
    }

    public URL[] getPrebundledUrls() {
        String path = System.getProperty(PREBUNDLED_PROPERTY);
        if (path == null) {
            return new URL[0];
        }
        return this.parseClasspath(path);
    }

    public URL[] getConnectorJUrls() {
        String path = System.getProperty(CONNECTOR_J_PROPERTY);
        if (path == null) {
            return new URL[0];
        }
        return this.parseClasspath(path);
    }

    public URL[] getLegacyJarUrls() {
        String path = System.getProperty(LEGACY_PROPERTY);
        if (path == null) {
            return new URL[0];
        }
        return this.parseClasspath(path);
    }

    public File getFrozenApiJar() {
        return this.frozenApiJarFile;
    }

    @Nullable
    public File getAppengineApiLegacyJar() {
        String filename = System.getProperty(APPENGINE_API_LEGACY_PROPERTY);
        return filename == null ? null : new File(this.root, filename);
    }

    public URL[] parseClasspath(String classpath) {
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                urls.add(new URL("file", "", new File(this.root, token).getAbsolutePath().replace('\\', '/')));
            }
            catch (MalformedURLException ex) {
                logger.log(Level.WARNING, "Could not parse " + token + " as a URL, ignoring.", ex);
            }
        }
        return urls.toArray(new URL[0]);
    }
}

