/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.runtime.ClassPathUtils;
import com.google.apphosting.runtime.NullSandboxPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaRuntimeMain {
    private static final String FACTORY_CLASS = "com.google.apphosting.runtime.JavaRuntimeFactory";
    private static final Logger logger = Logger.getLogger(JavaRuntimeMain.class.getName());
    private static final String PROPERTIES_LOCATION = "WEB-INF/appengine_optional.properties";
    private static final String USE_MAVEN_JARS = "use.mavenjars";
    private static final String USE_ANNOTATION_SCANNING = "use.annotationscanning";
    private static final String DISABLE_API_CALL_LOGGING_IN_APIPROXY = "disable_api_call_logging_in_apiproxy";
    private static final String ALLOW_NON_RESIDENT_SESSION_ACCESS = "gae.allow_non_resident_session_access";

    public static void main(String[] args) {
        new JavaRuntimeMain().load(args);
    }

    public void load(String[] args) {
        try {
            System.setProperty("com.google.appengine.runtime.environment", "Production");
            this.processOptionalProperties(args);
            String appsRoot = this.getApplicationRoot(args);
            NullSandboxPlugin plugin = new NullSandboxPlugin();
            ClassPathUtils classPathUtils = new ClassPathUtils();
            ClassLoader runtimeLoader = plugin.createRuntimeClassLoader(classPathUtils, appsRoot);
            Class<?> runtimeFactory = runtimeLoader.loadClass(FACTORY_CLASS);
            Method mainMethod = runtimeFactory.getMethod("startRuntime", NullSandboxPlugin.class, String[].class);
            mainMethod.invoke(null, plugin, args);
        }
        catch (ReflectiveOperationException e) {
            String msg = "Unexpected failure creating RuntimeClassLoader";
            logger.log(Level.SEVERE, msg, e);
            throw new RuntimeException(msg, e);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Unexpected failure creating RuntimeClassLoader", t);
            throw t;
        }
    }

    private String getApplicationRoot(String[] args) {
        return this.getFlag(args, "application_root", null);
    }

    String getFlag(String[] args, String flagName, String warningMsgIfAbsent) {
        String target = "--" + flagName;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(target)) {
                if (i + 1 >= args.length) continue;
                return args[i + 1];
            }
            if (!args[i].startsWith(target + "=")) continue;
            return args[i].substring((target + "=").length());
        }
        if (warningMsgIfAbsent != null) {
            logger.warning(warningMsgIfAbsent);
        }
        return null;
    }

    void processOptionalProperties(String[] args) {
        File optionalPropFile = new File(this.getApplicationPath(args), PROPERTIES_LOCATION);
        if (!optionalPropFile.exists()) {
            return;
        }
        Properties optionalProperties = new Properties();
        try (FileInputStream in = new FileInputStream(optionalPropFile);){
            optionalProperties.load(in);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Cannot read optional properties file.", e);
            return;
        }
        for (String flag : new String[]{USE_MAVEN_JARS, DISABLE_API_CALL_LOGGING_IN_APIPROXY, ALLOW_NON_RESIDENT_SESSION_ACCESS, USE_ANNOTATION_SCANNING}) {
            if (!"true".equalsIgnoreCase(optionalProperties.getProperty(flag))) continue;
            System.setProperty(flag, "true");
        }
    }

    String getApplicationPath(String[] args) {
        String fixedPath = this.getFlag(args, "fixed_application_path", null);
        if (fixedPath != null) {
            return fixedPath;
        }
        return this.getApplicationRoot(args) + "/" + System.getenv("GAE_APPLICATION") + "/" + System.getenv("GAE_VERSION") + "." + System.getenv("GAE_DEPLOYMENT_ID");
    }
}

