/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.BaseAsyncDatastoreServiceImpl;
import com.google.appengine.api.datastore.Batcher;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.IndexTranslator;
import com.google.appengine.api.datastore.InternalTransactionV3;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryRunnerV3;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.base.protos.api.ApiBasePb;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;

class AsyncDatastoreServiceImpl
extends BaseAsyncDatastoreServiceImpl {
    private final V3KeyBatcher<DatastoreV3Pb.DeleteResponse, DatastoreV3Pb.DeleteRequest> deleteBatcher = new V3KeyBatcher<DatastoreV3Pb.DeleteResponse, DatastoreV3Pb.DeleteRequest>(){

        @Override
        void addToBatch(OnestoreEntity.Reference value, DatastoreV3Pb.DeleteRequest batch) {
            batch.addKey(value);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxBatchWriteEntities;
        }

        @Override
        protected Future<DatastoreV3Pb.DeleteResponse> makeCall(DatastoreV3Pb.DeleteRequest batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreServiceImpl.this.apiConfig, DatastoreV3Pb.DatastoreService_3.Method.Delete, batch, new DatastoreV3Pb.DeleteResponse());
        }
    };
    private final V3KeyBatcher<DatastoreV3Pb.GetResponse, DatastoreV3Pb.GetRequest> getByKeyBatcher = new V3KeyBatcher<DatastoreV3Pb.GetResponse, DatastoreV3Pb.GetRequest>(){

        @Override
        void addToBatch(OnestoreEntity.Reference value, DatastoreV3Pb.GetRequest batch) {
            batch.addKey(value);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxBatchReadEntities;
        }

        @Override
        protected Future<DatastoreV3Pb.GetResponse> makeCall(DatastoreV3Pb.GetRequest batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreServiceImpl.this.apiConfig, DatastoreV3Pb.DatastoreService_3.Method.Get, batch, new DatastoreV3Pb.GetResponse());
        }
    };
    private final V3Batcher<DatastoreV3Pb.GetResponse, DatastoreV3Pb.GetRequest, OnestoreEntity.Reference, OnestoreEntity.Reference> getByReferenceBatcher = new V3Batcher<DatastoreV3Pb.GetResponse, DatastoreV3Pb.GetRequest, OnestoreEntity.Reference, OnestoreEntity.Reference>(){

        @Override
        final Object getGroup(OnestoreEntity.Reference value) {
            return value.getPath().getElement(0);
        }

        @Override
        final OnestoreEntity.Reference toPb(OnestoreEntity.Reference value) {
            return value;
        }

        @Override
        void addToBatch(OnestoreEntity.Reference value, DatastoreV3Pb.GetRequest batch) {
            batch.addKey(value);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxBatchReadEntities;
        }

        @Override
        protected Future<DatastoreV3Pb.GetResponse> makeCall(DatastoreV3Pb.GetRequest batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreServiceImpl.this.apiConfig, DatastoreV3Pb.DatastoreService_3.Method.Get, batch, new DatastoreV3Pb.GetResponse());
        }
    };
    private final V3Batcher<DatastoreV3Pb.PutResponse, DatastoreV3Pb.PutRequest, Entity, OnestoreEntity.EntityProto> putBatcher = new V3Batcher<DatastoreV3Pb.PutResponse, DatastoreV3Pb.PutRequest, Entity, OnestoreEntity.EntityProto>(){

        @Override
        Object getGroup(Entity value) {
            return value.getKey().getRootKey();
        }

        @Override
        void addToBatch(OnestoreEntity.EntityProto value, DatastoreV3Pb.PutRequest batch) {
            batch.addEntity(value);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxBatchWriteEntities;
        }

        @Override
        protected Future<DatastoreV3Pb.PutResponse> makeCall(DatastoreV3Pb.PutRequest batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreServiceImpl.this.apiConfig, DatastoreV3Pb.DatastoreService_3.Method.Put, batch, new DatastoreV3Pb.PutResponse());
        }

        @Override
        OnestoreEntity.EntityProto toPb(Entity value) {
            return EntityTranslator.convertToPb(value);
        }
    };
    private final ApiProxy.ApiConfig apiConfig;

    public AsyncDatastoreServiceImpl(DatastoreServiceConfig datastoreServiceConfig, ApiProxy.ApiConfig apiConfig, TransactionStack defaultTxnProvider) {
        super(datastoreServiceConfig, defaultTxnProvider, new QueryRunnerV3(datastoreServiceConfig, apiConfig));
        this.apiConfig = apiConfig;
    }

    @Override
    protected TransactionImpl.InternalTransaction doBeginTransaction(TransactionOptions options) {
        DatastoreV3Pb.Transaction remoteTxn = new DatastoreV3Pb.Transaction();
        DatastoreV3Pb.BeginTransactionRequest request = new DatastoreV3Pb.BeginTransactionRequest();
        request.setApp(this.datastoreServiceConfig.getAppIdNamespace().getAppId());
        request.setAllowMultipleEg(options.isXG());
        if (options.previousTransaction() != null) {
            try {
                request.setPreviousTransaction(InternalTransactionV3.toProto(options.previousTransaction()));
            }
            catch (RuntimeException e) {
                this.logger.log(Level.FINE, "previousTransaction threw an exception, ignoring as it is likely caused by a failed beginTransaction.", e);
            }
        }
        if (options.transactionMode() != null) {
            switch (options.transactionMode()) {
                case READ_ONLY: {
                    request.setMode(DatastoreV3Pb.BeginTransactionRequest.TransactionMode.READ_ONLY);
                    break;
                }
                case READ_WRITE: {
                    request.setMode(DatastoreV3Pb.BeginTransactionRequest.TransactionMode.READ_WRITE);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unrecognized transaction mode: " + (Object)((Object)options.transactionMode())));
                }
            }
        }
        Future<DatastoreV3Pb.Transaction> future = DatastoreApiHelper.makeAsyncCall(this.apiConfig, DatastoreV3Pb.DatastoreService_3.Method.BeginTransaction, request, remoteTxn);
        return new InternalTransactionV3(this.apiConfig, request.getApp(), future);
    }

    @Override
    protected final Future<Map<Key, Entity>> doBatchGet(@Nullable Transaction txn, final Set<Key> keysToGet, final Map<Key, Entity> resultMap) {
        final DatastoreV3Pb.GetRequest baseReq = new DatastoreV3Pb.GetRequest();
        baseReq.setAllowDeferred(true);
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(InternalTransactionV3.toProto(txn));
        }
        if (this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
            baseReq.setFailoverMs(-1L);
            baseReq.setStrong(false);
        }
        final boolean shouldUseMultipleBatches = txn == null && this.datastoreServiceConfig.getReadPolicy().getConsistency() != ReadPolicy.Consistency.EVENTUAL;
        Iterator<DatastoreV3Pb.GetRequest> batches = this.getByKeyBatcher.getBatches(keysToGet, baseReq, baseReq.getSerializedSize(), shouldUseMultipleBatches);
        List futures = this.getByKeyBatcher.makeCalls(batches);
        return this.registerInTransaction(txn, new FutureHelper.MultiFuture<DatastoreV3Pb.GetResponse, Map<Key, Entity>>(futures){
            private Map<OnestoreEntity.Reference, Key> keyMapIgnoringAppId;

            @Override
            public Map<Key, Entity> get() throws InterruptedException, ExecutionException {
                try {
                    this.aggregate(this.futures, null, null);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
                return resultMap;
            }

            @Override
            public Map<Key, Entity> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                this.aggregate(this.futures, timeout, unit);
                return resultMap;
            }

            private void aggregate(Iterable<Future<DatastoreV3Pb.GetResponse>> currentFutures, @Nullable Long timeout, @Nullable TimeUnit timeoutUnit) throws ExecutionException, InterruptedException, TimeoutException {
                while (true) {
                    LinkedList<OnestoreEntity.Reference> deferredRefs = Lists.newLinkedList();
                    for (Future<DatastoreV3Pb.GetResponse> currentFuture : currentFutures) {
                        DatastoreV3Pb.GetResponse resp = this.getFutureWithOptionalTimeout(currentFuture, timeout, timeoutUnit);
                        this.addEntitiesToResultMap(resp);
                        deferredRefs.addAll(resp.deferreds());
                    }
                    if (deferredRefs.isEmpty()) break;
                    Iterator<DatastoreV3Pb.GetRequest> followupBatches = AsyncDatastoreServiceImpl.this.getByReferenceBatcher.getBatches(deferredRefs, baseReq, baseReq.getSerializedSize(), shouldUseMultipleBatches);
                    currentFutures = AsyncDatastoreServiceImpl.this.getByReferenceBatcher.makeCalls(followupBatches);
                }
            }

            private DatastoreV3Pb.GetResponse getFutureWithOptionalTimeout(Future<DatastoreV3Pb.GetResponse> future, @Nullable Long timeout, @Nullable TimeUnit timeoutUnit) throws ExecutionException, InterruptedException, TimeoutException {
                if (timeout == null) {
                    return future.get();
                }
                return future.get(timeout, timeoutUnit);
            }

            private void addEntitiesToResultMap(DatastoreV3Pb.GetResponse response) {
                for (DatastoreV3Pb.GetResponse.Entity entityResult : response.entitys()) {
                    if (!entityResult.hasEntity()) continue;
                    Entity responseEntity = EntityTranslator.createFromPb(entityResult.getEntity());
                    Key responseKey = responseEntity.getKey();
                    if (!keysToGet.contains(responseKey)) {
                        responseKey = this.findKeyFromRequestIgnoringAppId(entityResult.getEntity().getKey());
                    }
                    resultMap.put(responseKey, responseEntity);
                }
            }

            private Key findKeyFromRequestIgnoringAppId(OnestoreEntity.Reference referenceFromResponse) {
                Key result;
                if (this.keyMapIgnoringAppId == null) {
                    this.keyMapIgnoringAppId = Maps.newHashMap();
                    for (Key requestKey : keysToGet) {
                        OnestoreEntity.Reference requestKeyAsRefWithoutApp = KeyTranslator.convertToPb(requestKey).clearApp();
                        this.keyMapIgnoringAppId.put(requestKeyAsRefWithoutApp, requestKey);
                    }
                }
                if ((result = this.keyMapIgnoringAppId.get(referenceFromResponse.clearApp())) == null) {
                    throw new DatastoreFailureException("Internal error");
                }
                return result;
            }
        });
    }

    @Override
    protected Future<List<Key>> doBatchPut(@Nullable Transaction txn, final List<Entity> entities) {
        DatastoreV3Pb.PutRequest baseReq = new DatastoreV3Pb.PutRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(InternalTransactionV3.toProto(txn));
        }
        boolean group = !baseReq.hasTransaction();
        final ArrayList<Integer> order = Lists.newArrayListWithCapacity(entities.size());
        Iterator<DatastoreV3Pb.PutRequest> batches = this.putBatcher.getBatches(entities, baseReq, baseReq.getSerializedSize(), group, order);
        List futures = this.putBatcher.makeCalls(batches);
        return this.registerInTransaction(txn, new Batcher.ReorderingMultiFuture<DatastoreV3Pb.PutResponse, List<Key>>(futures, order){

            @Override
            protected List<Key> aggregate(DatastoreV3Pb.PutResponse intermediateResult, Iterator<Integer> indexItr, List<Key> result) {
                for (OnestoreEntity.Reference reference : intermediateResult.keys()) {
                    int index = indexItr.next();
                    Key key = ((Entity)entities.get(index)).getKey();
                    KeyTranslator.updateKey(reference, key);
                    result.set(index, key);
                }
                return result;
            }

            @Override
            protected List<Key> initResult() {
                ArrayList<Object> result = new ArrayList<Object>(Collections.nCopies(order.size(), null));
                return result;
            }
        });
    }

    @Override
    protected Future<Void> doBatchDelete(@Nullable Transaction txn, Collection<Key> keys) {
        DatastoreV3Pb.DeleteRequest baseReq = new DatastoreV3Pb.DeleteRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(InternalTransactionV3.toProto(txn));
        }
        boolean group = !baseReq.hasTransaction();
        Iterator<DatastoreV3Pb.DeleteRequest> batches = this.deleteBatcher.getBatches(keys, baseReq, baseReq.getSerializedSize(), group);
        List futures = this.deleteBatcher.makeCalls(batches);
        return this.registerInTransaction(txn, new FutureHelper.MultiFuture<DatastoreV3Pb.DeleteResponse, Void>(futures){

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                for (Future future : this.futures) {
                    future.get();
                }
                return null;
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                for (Future future : this.futures) {
                    future.get(timeout, unit);
                }
                return null;
            }
        });
    }

    static OnestoreEntity.Reference buildAllocateIdsRef(Key parent, String kind, AppIdNamespace appIdNamespace) {
        if (parent != null && !parent.isComplete()) {
            throw new IllegalArgumentException("parent key must be complete");
        }
        Key key = new Key(kind, parent, 0L, "ignored", appIdNamespace);
        return KeyTranslator.convertToPb(key);
    }

    @Override
    public Future<KeyRange> allocateIds(final Key parent, final String kind, long num) {
        if (num <= 0L) {
            throw new IllegalArgumentException("num must be > 0");
        }
        if (num > 1000000000L) {
            throw new IllegalArgumentException("num must be < 1 billion");
        }
        final AppIdNamespace appIdNamespace = this.datastoreServiceConfig.getAppIdNamespace();
        OnestoreEntity.Reference allocateIdsRef = AsyncDatastoreServiceImpl.buildAllocateIdsRef(parent, kind, appIdNamespace);
        DatastoreV3Pb.AllocateIdsRequest req = new DatastoreV3Pb.AllocateIdsRequest().setSize(num).setModelKey(allocateIdsRef);
        DatastoreV3Pb.AllocateIdsResponse resp = new DatastoreV3Pb.AllocateIdsResponse();
        Future<DatastoreV3Pb.AllocateIdsResponse> future = DatastoreApiHelper.makeAsyncCall(this.apiConfig, DatastoreV3Pb.DatastoreService_3.Method.AllocateIds, req, resp);
        return new FutureWrapper<DatastoreV3Pb.AllocateIdsResponse, KeyRange>(future){

            @Override
            protected KeyRange wrap(DatastoreV3Pb.AllocateIdsResponse resp) throws Exception {
                return new KeyRange(parent, kind, resp.getStart(), resp.getEnd(), appIdNamespace);
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    @Override
    public Future<DatastoreService.KeyRangeState> allocateIdRange(final KeyRange range) {
        Key parent = range.getParent();
        final String kind = range.getKind();
        final long start = range.getStart().getId();
        long end = range.getEnd().getId();
        DatastoreV3Pb.AllocateIdsRequest req = new DatastoreV3Pb.AllocateIdsRequest().setModelKey(AsyncDatastoreServiceImpl.buildAllocateIdsRef(parent, kind, null)).setMax(end);
        DatastoreV3Pb.AllocateIdsResponse resp = new DatastoreV3Pb.AllocateIdsResponse();
        Future<DatastoreV3Pb.AllocateIdsResponse> future = DatastoreApiHelper.makeAsyncCall(this.apiConfig, DatastoreV3Pb.DatastoreService_3.Method.AllocateIds, req, resp);
        return new FutureWrapper<DatastoreV3Pb.AllocateIdsResponse, DatastoreService.KeyRangeState>(future){

            @Override
            protected DatastoreService.KeyRangeState wrap(DatastoreV3Pb.AllocateIdsResponse resp) throws Exception {
                Query query = new Query(kind).setKeysOnly();
                query.addFilter("__key__", Query.FilterOperator.GREATER_THAN_OR_EQUAL, range.getStart());
                query.addFilter("__key__", Query.FilterOperator.LESS_THAN_OR_EQUAL, range.getEnd());
                List<Entity> collision = AsyncDatastoreServiceImpl.this.prepare(query).asList(FetchOptions.Builder.withLimit(1));
                if (!collision.isEmpty()) {
                    return DatastoreService.KeyRangeState.COLLISION;
                }
                boolean raceCondition = start < resp.getStart();
                return raceCondition ? DatastoreService.KeyRangeState.CONTENTION : DatastoreService.KeyRangeState.EMPTY;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    @Override
    public Future<Map<Index, Index.IndexState>> getIndexes() {
        ApiBasePb.StringProto req = ApiBasePb.StringProto.newBuilder().setValue(this.datastoreServiceConfig.getAppIdNamespace().getAppId()).build();
        return new FutureWrapper<DatastoreV3Pb.CompositeIndices, Map<Index, Index.IndexState>>(DatastoreApiHelper.makeAsyncCall(this.apiConfig, DatastoreV3Pb.DatastoreService_3.Method.GetIndices, req, new DatastoreV3Pb.CompositeIndices())){

            @Override
            protected Map<Index, Index.IndexState> wrap(DatastoreV3Pb.CompositeIndices indices) throws Exception {
                LinkedHashMap<Index, Index.IndexState> answer = new LinkedHashMap<Index, Index.IndexState>();
                block6: for (OnestoreEntity.CompositeIndex ci : indices.indexs()) {
                    Index index = IndexTranslator.convertFromPb(ci);
                    switch (ci.getStateEnum()) {
                        case DELETED: {
                            answer.put(index, Index.IndexState.DELETING);
                            continue block6;
                        }
                        case ERROR: {
                            answer.put(index, Index.IndexState.ERROR);
                            continue block6;
                        }
                        case READ_WRITE: {
                            answer.put(index, Index.IndexState.SERVING);
                            continue block6;
                        }
                        case WRITE_ONLY: {
                            answer.put(index, Index.IndexState.BUILDING);
                            continue block6;
                        }
                    }
                    AsyncDatastoreServiceImpl.this.logger.log(Level.WARNING, "Unrecognized index state for " + index);
                }
                return answer;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    private abstract class V3KeyBatcher<S extends ProtocolMessage<S>, R extends ProtocolMessage<R>>
    extends V3Batcher<S, R, Key, OnestoreEntity.Reference> {
        private V3KeyBatcher() {
        }

        @Override
        final Object getGroup(Key value) {
            return value.getRootKey();
        }

        @Override
        final OnestoreEntity.Reference toPb(Key value) {
            return KeyTranslator.convertToPb(value);
        }
    }

    private abstract class V3Batcher<S extends ProtocolMessage<S>, R extends ProtocolMessage<R>, F, T extends ProtocolMessage<T>>
    extends BaseAsyncDatastoreServiceImpl.BaseRpcBatcher<S, R, F, T> {
        private V3Batcher() {
            super(AsyncDatastoreServiceImpl.this);
        }

        @Override
        final R newBatch(R baseBatch) {
            return (R)((ProtocolMessage)baseBatch).clone();
        }
    }
}

