/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.MultiQueryComponent;
import com.google.appengine.api.datastore.MultiQueryIterator;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QuerySplitComponent;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class MultiQueryBuilder
implements Iterable<List<List<Query.FilterPredicate>>> {
    final List<Query.FilterPredicate> baseFilters;
    final List<MultiQueryComponent> components;
    final int parallelQuerySize;

    MultiQueryBuilder(List<Query.FilterPredicate> baseFilters, List<MultiQueryComponent> components, int parallelQuerySize) {
        this.baseFilters = Preconditions.checkNotNull(baseFilters);
        this.components = components;
        this.parallelQuerySize = parallelQuerySize;
    }

    public MultiQueryBuilder(List<Query.FilterPredicate> baseFilters, List<QuerySplitComponent> splitComponents, boolean hasSort) {
        this.baseFilters = Preconditions.checkNotNull(baseFilters);
        if (splitComponents.isEmpty()) {
            this.components = Collections.emptyList();
            this.parallelQuerySize = 1;
        } else {
            this.components = Lists.newArrayListWithCapacity(splitComponents.size());
            Collections.sort(splitComponents);
            MultiQueryComponent.Order applyToRemaining = hasSort ? null : MultiQueryComponent.Order.SERIAL;
            int currentSortIndex = 0;
            int totalParallelQueries = 1;
            for (QuerySplitComponent component : splitComponents) {
                if (applyToRemaining == null && component.getSortIndex() != currentSortIndex) {
                    if (component.getSortIndex() == currentSortIndex + 1) {
                        ++currentSortIndex;
                    } else {
                        applyToRemaining = MultiQueryComponent.Order.PARALLEL;
                    }
                }
                this.components.add(new MultiQueryComponent(applyToRemaining != null ? applyToRemaining : MultiQueryComponent.Order.SERIAL, component.getFilters()));
                if (applyToRemaining != MultiQueryComponent.Order.PARALLEL) continue;
                totalParallelQueries *= component.getFilters().size();
            }
            this.parallelQuerySize = totalParallelQueries;
        }
    }

    @Override
    public Iterator<List<List<Query.FilterPredicate>>> iterator() {
        if (this.components.isEmpty()) {
            return Iterators.singletonIterator(Collections.singletonList(this.baseFilters));
        }
        return new MultiQueryIterator(this.baseFilters, this.components);
    }

    public List<Query.FilterPredicate> getBaseFilters() {
        return this.baseFilters;
    }

    public boolean isSingleton() {
        return this.components.isEmpty();
    }

    public int getParallelQuerySize() {
        return this.parallelQuerySize;
    }

    public String toString() {
        return "MultiQueryBuilder [baseFilters=" + this.baseFilters + ", components=" + this.components + "]";
    }
}

