/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.MultiQueryComponent;
import com.google.appengine.api.datastore.Query;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;

class MultiQueryIterator
implements Iterator<List<List<Query.FilterPredicate>>> {
    private final List<MultiQueryComponent> components;
    private final List<Integer> componentSubIndex;
    private final Deque<List<Query.FilterPredicate>> filtersStack = Queues.newArrayDeque();
    private int componentIndex = 0;
    private int parallelCount = 0;
    private boolean moreResults = true;

    public MultiQueryIterator(List<Query.FilterPredicate> baseFilters, List<MultiQueryComponent> components) {
        this.components = components;
        this.filtersStack.push(baseFilters);
        this.componentSubIndex = new ArrayList<Integer>(components.size());
        for (MultiQueryComponent component : components) {
            this.componentSubIndex.add(0);
        }
    }

    private void pushFilters(List<Query.FilterPredicate> componentFilters) {
        List< @Nullable Query.FilterPredicate> baseFilters = this.filtersStack.getFirst();
        ArrayList< @Nullable Query.FilterPredicate> filters = new ArrayList<Query.FilterPredicate>(baseFilters.size() + componentFilters.size());
        filters.addAll(baseFilters);
        filters.addAll(componentFilters);
        this.filtersStack.push(filters);
    }

    private boolean advanceSerialComponents() {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            boolean isLastFilter;
            MultiQueryComponent component = this.components.get(i);
            if (component.getOrder() == MultiQueryComponent.Order.PARALLEL) continue;
            boolean bl = isLastFilter = this.componentSubIndex.get(i) + 1 == component.getFilters().size();
            if (isLastFilter) {
                this.componentSubIndex.set(i, 0);
                continue;
            }
            this.componentSubIndex.set(i, this.componentSubIndex.get(i) + 1);
            return true;
        }
        return false;
    }

    private void buildNextResult(List<List<Query.FilterPredicate>> result, int minIndex) {
        while (this.componentIndex >= minIndex) {
            if (this.componentIndex >= this.components.size()) {
                result.add(this.filtersStack.peek());
                --this.componentIndex;
                continue;
            }
            MultiQueryComponent component = this.components.get(this.componentIndex);
            if (component.getOrder() == MultiQueryComponent.Order.PARALLEL) {
                ++this.parallelCount;
                ++this.componentIndex;
                for (List<Query.FilterPredicate> componentFilters : component.getFilters()) {
                    this.pushFilters(componentFilters);
                    this.buildNextResult(result, this.componentIndex);
                    this.filtersStack.pop();
                }
                --this.parallelCount;
                this.componentIndex -= 2;
                continue;
            }
            if (this.filtersStack.size() <= this.componentIndex + 1) {
                this.pushFilters(component.getFilters().get(this.componentSubIndex.get(this.componentIndex)));
                ++this.componentIndex;
                continue;
            }
            this.filtersStack.pop();
            boolean isLastFilter = this.componentSubIndex.get(this.componentIndex) + 1 == component.getFilters().size();
            --this.componentIndex;
            if (this.parallelCount != 0 || isLastFilter) continue;
            break;
        }
        ++this.componentIndex;
    }

    @Override
    public boolean hasNext() {
        return this.moreResults;
    }

    @Override
    public List<List<Query.FilterPredicate>> next() {
        if (!this.moreResults) {
            throw new NoSuchElementException();
        }
        ArrayList<List<Query.FilterPredicate>> result = Lists.newArrayList();
        this.buildNextResult(result, 0);
        this.moreResults = this.advanceSerialComponents();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

