/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.base;

import com.google.apphosting.base.AutoValue_VersionId;
import com.google.auto.value.AutoValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
public abstract class VersionId {
    public static final String DEFAULT_ENGINE_ID = "default";
    private static final int ENGINE_ID_MAX_LENGTH = 63;
    private static final int ENGINE_VERSION_ID_MAX_LENGTH = 100;
    private static final int MINOR_VERSION_ID_LENGTH = 20;
    private static final String ENGINE_ID_RE = String.format("[a-z\\d][a-z\\d\\-]{0,%d}", 62);
    private static final String ENGINE_VERSION_ID_RE = String.format("[a-z\\d][a-z\\d\\-]{0,%d}", 99);
    private static final String MAJOR_VERSION_RE = String.format("(?:(?:(%s):)?)(%s)", ENGINE_ID_RE, ENGINE_VERSION_ID_RE);
    private static final String FULL_VERSION_RE = String.format("(%s)(\\.(\\d{1,%d}))?", MAJOR_VERSION_RE, 20);
    private static final Pattern FULL_VERSION_PATTERN = Pattern.compile(FULL_VERSION_RE);

    private static VersionId from(String versionId) {
        if (versionId == null) {
            throw new NullPointerException();
        }
        Matcher matcher = FULL_VERSION_PATTERN.matcher(versionId);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Malformed versionId: " + versionId);
        }
        String engineId = matcher.group(2) == null ? DEFAULT_ENGINE_ID : matcher.group(2);
        return new AutoValue_VersionId(versionId, matcher.group(1), engineId, matcher.group(3), matcher.group(5));
    }

    public abstract @Nullable String getVersionId();

    public abstract String getMajorVersion();

    public abstract String getEngineId();

    public abstract String getEngineVersionId();

    public abstract @Nullable String getMinorVersion();

    public static VersionId parse(String versionId) {
        return VersionId.from(versionId);
    }
}

