/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.runtime.anyrpc.APIHostClientInterface;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.lang.reflect.Method;
import java.util.OptionalInt;

public class ApiHostClientFactory {
    public APIHostClientInterface newAPIHost(String trustedHost, OptionalInt maxConcurrentRpcs) {
        HostAndPort hostAndPort = HostAndPort.fromString(trustedHost);
        Preconditions.checkArgument(hostAndPort.hasPort(), "Missing port number: %s", (Object)trustedHost);
        Preconditions.checkArgument(!hostAndPort.getHost().isEmpty(), "Missing host: %s", (Object)trustedHost);
        return this.httpApiHostClient(hostAndPort, maxConcurrentRpcs);
    }

    private APIHostClientInterface httpApiHostClient(HostAndPort hostAndPort, OptionalInt maxConcurrentRpcs) {
        try {
            Class<?> httpApiHostClientClass = Class.forName("com.google.apphosting.runtime.http.HttpApiHostClientFactory");
            Method create = httpApiHostClientClass.getMethod("create", HostAndPort.class, OptionalInt.class);
            return (APIHostClientInterface)create.invoke(null, hostAndPort, maxConcurrentRpcs);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

