/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.appengine.tools.development.TimedFuture;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.ApiStats;
import com.google.apphosting.api.CloudTrace;
import com.google.apphosting.api.CloudTraceContext;
import com.google.apphosting.base.protos.HttpPb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.base.protos.Status;
import com.google.apphosting.base.protos.TraceId;
import com.google.apphosting.runtime.ApiDeadlineOracle;
import com.google.apphosting.runtime.AppLogsWriter;
import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.AutoBuilder_ApiProxyImpl_Builder;
import com.google.apphosting.runtime.BackgroundRequestCoordinator;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.RequestManager;
import com.google.apphosting.runtime.RequestState;
import com.google.apphosting.runtime.SystemService;
import com.google.apphosting.runtime.TraceContextHelper;
import com.google.apphosting.runtime.TraceWriter;
import com.google.apphosting.runtime.anyrpc.APIHostClientInterface;
import com.google.apphosting.runtime.anyrpc.AnyRpcCallback;
import com.google.apphosting.runtime.anyrpc.AnyRpcClientContext;
import com.google.apphosting.runtime.timer.CpuRatioTimer;
import com.google.apphosting.utils.runtime.ApiProxyUtils;
import com.google.auto.value.AutoBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.flogger.GoogleLogger;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ForwardingFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class ApiProxyImpl
implements ApiProxy.Delegate<EnvironmentImpl> {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    static final String USER_ID_KEY = "com.google.appengine.api.users.UserService.user_id_key";
    static final String USER_ORGANIZATION_KEY = "com.google.appengine.api.users.UserService.user_organization";
    static final String LOAS_PEER_USERNAME = "com.google.net.base.peer.loas_peer_username";
    static final String LOAS_SECURITY_LEVEL = "com.google.net.base.peer.loas_security_level";
    static final String IS_TRUSTED_IP = "com.google.appengine.runtime.is_trusted_ip";
    static final String API_DEADLINE_KEY = "com.google.apphosting.api.ApiProxy.api_deadline_key";
    static final String BACKGROUND_THREAD_REQUEST_DEADLINE_KEY = "com.google.apphosting.api.ApiProxy.background_thread_request_deadline_key";
    public static final String BACKEND_ID_KEY = "com.google.appengine.backend.id";
    public static final String INSTANCE_ID_KEY = "com.google.appengine.instance.id";
    static final String REQUEST_ID_HASH = "com.google.apphosting.api.ApiProxy.request_id_hash";
    static final String REQUEST_LOG_ID = "com.google.appengine.runtime.request_log_id";
    static final String DEFAULT_VERSION_HOSTNAME = "com.google.appengine.runtime.default_version_hostname";
    static final String GAIA_ID = "com.google.appengine.runtime.gaia_id";
    static final String GAIA_AUTHUSER = "com.google.appengine.runtime.gaia_authuser";
    static final String GAIA_SESSION = "com.google.appengine.runtime.gaia_session";
    static final String APPSERVER_DATACENTER = "com.google.appengine.runtime.appserver_datacenter";
    static final String APPSERVER_TASK_BNS = "com.google.appengine.runtime.appserver_task_bns";
    public static final String CLOUD_SQL_JDBC_CONNECTIVITY_ENABLED_KEY = "com.google.appengine.runtime.new_database_connectivity";
    private static final long DEFAULT_BYTE_COUNT_BEFORE_FLUSHING = 102400L;
    private static final int DEFAULT_MAX_LOG_LINE_SIZE = 16384;
    private static final int API_DEADLINE_PADDING = 500;
    private static final long ATTRIBUTE_TO_DEADLINE_MILLIS = 50L;
    private static final Number DEFAULT_BACKGROUND_THREAD_REQUEST_DEADLINE = 30000L;
    private static final String DEADLINE_REACHED_REASON = "the overall HTTP request deadline was reached";
    private static final String DEADLINE_REACHED_SLOT_REASON = "the overall HTTP request deadline was reached while waiting for concurrent API calls";
    private static final String INTERRUPTED_REASON = "the thread was interrupted";
    private static final String INTERRUPTED_SLOT_REASON = "the thread was interrupted while waiting for concurrent API calls";
    static final String DATACENTER = "com.google.apphosting.api.ApiProxy.datacenter";
    private final APIHostClientInterface apiHost;
    private final ApiDeadlineOracle deadlineOracle;
    private final String externalDatacenterName;
    private final long byteCountBeforeFlushing;
    private final int maxLogLineSize;
    private final Duration maxLogFlushTime;
    private final BackgroundRequestCoordinator coordinator;
    private RequestManager requestManager;
    private final boolean cloudSqlJdbcConnectivityEnabled;
    private final boolean disableApiCallLogging;
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private final boolean logToLogservice;

    public static Builder builder() {
        return new AutoBuilder_ApiProxyImpl_Builder().setByteCountBeforeFlushing(102400L).setMaxLogLineSize(16384).setMaxLogFlushTime(Duration.ZERO).setCloudSqlJdbcConnectivityEnabled(false).setDisableApiCallLogging(false).setLogToLogservice(true);
    }

    ApiProxyImpl(@Nullable APIHostClientInterface apiHost, @Nullable ApiDeadlineOracle deadlineOracle, @Nullable String externalDatacenterName, long byteCountBeforeFlushing, int maxLogLineSize, Duration maxLogFlushTime, @Nullable BackgroundRequestCoordinator coordinator, boolean cloudSqlJdbcConnectivityEnabled, boolean disableApiCallLogging, boolean logToLogservice) {
        this.apiHost = apiHost;
        this.deadlineOracle = deadlineOracle;
        this.externalDatacenterName = externalDatacenterName;
        this.byteCountBeforeFlushing = byteCountBeforeFlushing;
        this.maxLogLineSize = maxLogLineSize;
        this.maxLogFlushTime = maxLogFlushTime;
        this.coordinator = coordinator;
        this.cloudSqlJdbcConnectivityEnabled = cloudSqlJdbcConnectivityEnabled;
        this.disableApiCallLogging = disableApiCallLogging;
        this.logToLogservice = logToLogservice;
    }

    public void setRequestManager(RequestManager requestManager) {
        this.requestManager = requestManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disable() {
        AtomicBoolean atomicBoolean = this.enabled;
        synchronized (atomicBoolean) {
            if (this.enabled.get()) {
                this.apiHost.disable();
                this.enabled.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enable() {
        AtomicBoolean atomicBoolean = this.enabled;
        synchronized (atomicBoolean) {
            if (!this.enabled.get()) {
                this.apiHost.enable();
                this.enabled.set(true);
            }
        }
    }

    public byte[] makeSyncCall(EnvironmentImpl environment, String packageName, String methodName, byte[] request) {
        return AccessController.doPrivileged(() -> this.doSyncCall(environment, packageName, methodName, request));
    }

    public Future<byte[]> makeAsyncCall(EnvironmentImpl environment, String packageName, String methodName, byte[] request, ApiProxy.ApiConfig apiConfig) {
        return AccessController.doPrivileged(() -> this.doAsyncCall(environment, packageName, methodName, request, apiConfig.getDeadlineInSeconds()));
    }

    private byte[] doSyncCall(EnvironmentImpl environment, String packageName, String methodName, byte[] requestBytes) {
        double deadlineInSeconds = this.getApiDeadline(packageName, environment);
        Future<byte[]> future = this.doAsyncCall(environment, packageName, methodName, requestBytes, deadlineInSeconds);
        try {
            byte[] byArray = future.get((long)(deadlineInSeconds * 1000.0), TimeUnit.MILLISECONDS);
            return byArray;
        }
        catch (InterruptedException ex) {
            long remainingMillis = environment.getRemainingMillis();
            String msg = String.format("Caught InterruptedException; %d millis %s soft deadline", Math.abs(remainingMillis), remainingMillis > 0L ? "until" : "since");
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("%s", msg);
            if (remainingMillis <= 50L) {
                throw new ApiProxy.CancelledException(packageName, methodName, DEADLINE_REACHED_REASON);
            }
            throw new ApiProxy.CancelledException(packageName, methodName, INTERRUPTED_REASON);
        }
        catch (CancellationException ex) {
            long remainingMillis = environment.getRemainingMillis();
            if (remainingMillis <= 50L) {
                String msg = String.format("Caught CancellationException; %d millis %s soft deadline; attributing to deadline", Math.abs(remainingMillis), remainingMillis > 0L ? "until" : "since");
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("%s", msg);
                throw new ApiProxy.CancelledException(packageName, methodName, DEADLINE_REACHED_REASON);
            }
            String msg = String.format("Caught CancellationException; %d millis %s soft deadline; this is unexpected", Math.abs(remainingMillis), remainingMillis > 0L ? "until" : "since");
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(ex)).log("%s", msg);
            throw new ApiProxy.CancelledException(packageName, methodName);
        }
        catch (TimeoutException ex) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withCause(ex)).log("API call exceeded deadline");
            throw new ApiProxy.ApiDeadlineExceededException(packageName, methodName);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ApiProxy.ApiProxyException) {
                ApiProxy.ApiProxyException apiProxyException = (ApiProxy.ApiProxyException)cause;
                throw apiProxyException.copy(Thread.currentThread().getStackTrace());
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(cause)).log("Error thrown from API call.");
                throw (Error)cause;
            }
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(cause)).log("Checked exception thrown from API call.");
            throw new RuntimeException(cause);
        }
        finally {
            if (Thread.interrupted()) {
                ((GoogleLogger.Api)logger.atWarning()).log("Thread %s was interrupted but we did not receive an InterruptedException.  Resetting interrupt bit.", Thread.currentThread());
            }
        }
    }

    private Future<byte[]> doAsyncCall(EnvironmentImpl environment, String packageName, String methodName, byte[] requestBytes, Double requestDeadlineInSeconds) {
        long apiSlotWaitTime;
        CloudTraceContext parentContext;
        TraceWriter traceWriter = environment.getTraceWriter();
        CloudTraceContext currentContext = null;
        if (traceWriter != null && TraceContextHelper.isStackTraceEnabled(currentContext = traceWriter.startApiSpan(parentContext = CloudTrace.getCurrentContext((ApiProxy.Environment)environment), packageName, methodName)) && environment.getTraceExceptionGenerator() != null) {
            StackTraceElement[] stackTrace = environment.getTraceExceptionGenerator().getExceptionWithRequestId(new Exception(), environment.getRequestId()).getStackTrace();
            traceWriter.addStackTrace(currentContext, stackTrace);
        }
        if (packageName.equals("channel")) {
            packageName = "xmpp";
        }
        double deadlineInSeconds = this.deadlineOracle.getDeadline(packageName, environment.isOfflineRequest(), requestDeadlineInSeconds);
        RuntimePb.APIRequest.Builder apiRequest = RuntimePb.APIRequest.newBuilder().setApiPackage(packageName).setCall(methodName).setSecurityTicket(environment.getSecurityTicket()).setPb(ByteString.copyFrom(requestBytes));
        if (currentContext != null) {
            apiRequest.setTraceContext(TraceContextHelper.toProto2(currentContext));
        }
        AnyRpcClientContext rpc = this.apiHost.newClientContext();
        try {
            apiSlotWaitTime = environment.apiRpcStarting(deadlineInSeconds);
            deadlineInSeconds -= (double)apiSlotWaitTime / 1000.0;
            if (deadlineInSeconds < 0.0) {
                throw new InterruptedException("Deadline was used up while waiting for API RPC slot");
            }
        }
        catch (InterruptedException ex) {
            long remainingMillis = environment.getRemainingMillis();
            String msg = String.format("Interrupted waiting for an API RPC slot with %d millis %s soft deadline", Math.abs(remainingMillis), remainingMillis > 0L ? "until" : "since");
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("%s", msg);
            if (remainingMillis <= 50L) {
                return this.createCancelledFuture(packageName, methodName, DEADLINE_REACHED_SLOT_REASON);
            }
            return this.createCancelledFuture(packageName, methodName, INTERRUPTED_SLOT_REASON);
        }
        try {
            return this.finishAsyncApiCallSetup(rpc, apiRequest.build(), currentContext, environment, packageName, methodName, deadlineInSeconds, apiSlotWaitTime);
        }
        catch (Error | RuntimeException e) {
            environment.apiRpcFinished();
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Exception in API call setup");
            return Futures.immediateFailedFuture(e);
        }
    }

    private Future<byte[]> finishAsyncApiCallSetup(AnyRpcClientContext rpc, RuntimePb.APIRequest apiRequest, CloudTraceContext currentContext, EnvironmentImpl environment, final String packageName, final String methodName, double deadlineInSeconds, long apiSlotWaitTime) {
        rpc.setDeadline(deadlineInSeconds);
        if (!this.disableApiCallLogging) {
            ((GoogleLogger.Api)logger.atInfo()).log("Beginning API call to %s.%s with deadline %g", packageName, methodName, deadlineInSeconds);
            if (apiSlotWaitTime > 0L) {
                ((GoogleLogger.Api)logger.atInfo()).log("Had to wait %dms for previous API calls to complete", apiSlotWaitTime);
            }
        }
        SettableFuture<byte[]> settableFuture = SettableFuture.create();
        long deadlineMillis = (long)(deadlineInSeconds * 1000.0);
        TimedFuture<byte[]> timedFuture = new TimedFuture<byte[]>(settableFuture, deadlineMillis + 500L){

            @Override
            protected RuntimeException createDeadlineException() {
                return new ApiProxy.ApiDeadlineExceededException(packageName, methodName);
            }
        };
        AsyncApiFuture rpcCallback = new AsyncApiFuture(deadlineMillis, (Future<byte[]>)timedFuture, settableFuture, rpc, environment, currentContext, packageName, methodName, this.disableApiCallLogging);
        this.apiHost.call(rpc, apiRequest, rpcCallback);
        settableFuture.addListener(environment::apiRpcFinished, MoreExecutors.directExecutor());
        environment.addAsyncFuture(rpcCallback);
        return rpcCallback;
    }

    private Future<byte[]> createCancelledFuture(final String packageName, final String methodName, final String reason) {
        return new Future<byte[]>(){

            @Override
            public byte[] get() {
                throw new ApiProxy.CancelledException(packageName, methodName, reason);
            }

            @Override
            public byte[] get(long deadline, TimeUnit unit) {
                throw new ApiProxy.CancelledException(packageName, methodName, reason);
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public boolean isCancelled() {
                return true;
            }

            @Override
            public boolean cancel(boolean shouldInterrupt) {
                return false;
            }
        };
    }

    public void log(EnvironmentImpl environment, ApiProxy.LogRecord record) {
        if (this.logToLogservice && environment != null) {
            environment.addLogRecord(record);
        }
    }

    public void flushLogs(EnvironmentImpl environment) {
        if (this.logToLogservice && environment != null) {
            environment.flushLogs();
        }
    }

    public List<Thread> getRequestThreads(EnvironmentImpl environment) {
        if (environment == null) {
            return Collections.emptyList();
        }
        return this.requestManager.getRequestThreads(environment.getAppVersion().getKey());
    }

    public EnvironmentImpl createEnvironment(AppVersion appVersion, RuntimePb.UPRequest upRequest, MutableUpResponse upResponse, @Nullable TraceWriter traceWriter, CpuRatioTimer requestTimer, String requestId, List<Future<?>> asyncFutures, Semaphore outstandingApiRpcSemaphore, ThreadGroup requestThreadGroup, RequestState requestState, @Nullable Long millisUntilSoftDeadline) {
        return new EnvironmentImpl(appVersion, upRequest, upResponse, traceWriter, requestTimer, requestId, this.externalDatacenterName, asyncFutures, outstandingApiRpcSemaphore, this.byteCountBeforeFlushing, this.maxLogLineSize, Ints.checkedCast(this.maxLogFlushTime.getSeconds()), requestThreadGroup, requestState, this.coordinator, this.cloudSqlJdbcConnectivityEnabled, millisUntilSoftDeadline);
    }

    private double getApiDeadline(String packageName, EnvironmentImpl env) {
        Number userDeadline = (Number)env.getAttributes().get(API_DEADLINE_KEY);
        return this.deadlineOracle.getDeadline(packageName, env.isOfflineRequest(), userDeadline);
    }

    private static PrivilegedAction<Void> runWithThreadContext(Runnable runnable, ApiProxy.Environment environment, CloudTraceContext parentThreadContext) {
        return () -> {
            CloudTrace.setCurrentContext((ApiProxy.Environment)environment, (CloudTraceContext)parentThreadContext);
            try {
                runnable.run();
            }
            finally {
                CloudTrace.setCurrentContext((ApiProxy.Environment)environment, null);
            }
            return null;
        };
    }

    private static final class BackgroundThreadFactory
    implements ThreadFactory {
        private final BackgroundRequestCoordinator coordinator;
        private final SystemService systemService;

        public BackgroundThreadFactory(BackgroundRequestCoordinator coordinator) {
            this.coordinator = coordinator;
            this.systemService = new SystemService();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            EnvironmentImpl environment = (EnvironmentImpl)ApiProxy.getCurrentEnvironment();
            if (environment == null) {
                throw new NullPointerException("Operation not allowed in a thread that is neither the original request thread nor a thread created by ThreadManager");
            }
            CloudTraceContext parentThreadContext = CloudTrace.getCurrentContext((ApiProxy.Environment)environment);
            AccessControlContext context = AccessController.getContext();
            Runnable contextRunnable = () -> {
                Void cfr_ignored_0 = (Void)AccessController.doPrivileged(ApiProxyImpl.runWithThreadContext(runnable, (ApiProxy.Environment)environment, parentThreadContext), context);
            };
            String requestId = this.systemService.startBackgroundRequest();
            Number deadline = MoreObjects.firstNonNull((Number)environment.getAttributes().get(ApiProxyImpl.BACKGROUND_THREAD_REQUEST_DEADLINE_KEY), DEFAULT_BACKGROUND_THREAD_REQUEST_DEADLINE);
            try {
                return this.coordinator.waitForThreadStart(requestId, contextRunnable, deadline.longValue());
            }
            catch (TimeoutException ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Timeout while waiting for background thread startup:");
                return null;
            }
            catch (InterruptedException ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Interrupted while waiting for background thread startup:");
                Thread.currentThread().interrupt();
                throw new ApiProxy.CancelledException("system", "StartBackgroundRequest");
            }
        }
    }

    private static final class CurrentRequestThreadFactory
    implements ThreadFactory {
        private static final ThreadFactory SINGLETON = new CurrentRequestThreadFactory();

        private CurrentRequestThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            EnvironmentImpl environment = (EnvironmentImpl)ApiProxy.getCurrentEnvironment();
            if (environment == null) {
                throw new NullPointerException("Operation not allowed in a thread that is neither the original request thread nor a thread created by ThreadManager");
            }
            ThreadGroup requestThreadGroup = environment.getRequestThreadGroup();
            RequestState requestState = environment.getRequestState();
            CloudTraceContext parentThreadContext = CloudTrace.getCurrentContext((ApiProxy.Environment)environment);
            AccessControlContext context = AccessController.getContext();
            Runnable contextRunnable = () -> {
                Void cfr_ignored_0 = (Void)AccessController.doPrivileged(ApiProxyImpl.runWithThreadContext(runnable, (ApiProxy.Environment)environment, parentThreadContext), context);
            };
            return AccessController.doPrivileged(() -> new CurrentRequestThread(requestThreadGroup, contextRunnable, runnable, requestState, (ApiProxy.Environment)environment));
        }
    }

    static class CurrentRequestThread
    extends Thread {
        private final Runnable userRunnable;
        private final RequestState requestState;
        private final ApiProxy.Environment environment;

        CurrentRequestThread(ThreadGroup requestThreadGroup, Runnable runnable, Runnable userRunnable, RequestState requestState, ApiProxy.Environment environment) {
            super(requestThreadGroup, runnable);
            this.userRunnable = userRunnable;
            this.requestState = requestState;
            this.environment = environment;
        }

        Runnable userRunnable() {
            return this.userRunnable;
        }

        @Override
        public synchronized void start() {
            if (!this.requestState.getAllowNewRequestThreadCreation()) {
                throw new IllegalStateException("Cannot create new threads after request thread stops.");
            }
            this.requestState.recordRequestThread(this);
            boolean started = false;
            try {
                super.start();
                started = true;
            }
            finally {
                if (!started) {
                    this.requestState.forgetRequestThread(this);
                }
            }
        }

        @Override
        public void run() {
            try {
                ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)this.environment);
                super.run();
            }
            finally {
                this.requestState.forgetRequestThread(this);
            }
        }
    }

    public static final class EnvironmentImpl
    implements ApiProxy.EnvironmentWithTrace {
        static final String DEFAULT_NAMESPACE_HEADER = "X-AppEngine-Default-Namespace";
        static final String CURRENT_NAMESPACE_HEADER = "X-AppEngine-Current-Namespace";
        private static final String CURRENT_NAMESPACE_KEY = "com.google.appengine.api.NamespaceManager.currentNamespace";
        private static final String APPS_NAMESPACE_KEY = "com.google.appengine.api.NamespaceManager.appsNamespace";
        private static final String REQUEST_THREAD_FACTORY_ATTR = "com.google.appengine.api.ThreadManager.REQUEST_THREAD_FACTORY";
        private static final String BACKGROUND_THREAD_FACTORY_ATTR = "com.google.appengine.api.ThreadManager.BACKGROUND_THREAD_FACTORY";
        private final AppVersion appVersion;
        private final RuntimePb.UPRequest upRequest;
        private final CpuRatioTimer requestTimer;
        private final Map<String, Object> attributes;
        private final String requestId;
        private final List<Future<?>> asyncFutures;
        private final AppLogsWriter appLogsWriter;
        @Nullable
        private final TraceWriter traceWriter;
        @Nullable
        private final TraceExceptionGenerator traceExceptionGenerator;
        private final Semaphore outstandingApiRpcSemaphore;
        private final ThreadGroup requestThreadGroup;
        private final RequestState requestState;
        private final Optional<String> traceId;
        private final Optional<String> spanId;
        @Nullable
        private final Long millisUntilSoftDeadline;

        EnvironmentImpl(AppVersion appVersion, RuntimePb.UPRequest upRequest, MutableUpResponse upResponse, @Nullable TraceWriter traceWriter, CpuRatioTimer requestTimer, String requestId, String externalDatacenterName, List<Future<?>> asyncFutures, Semaphore outstandingApiRpcSemaphore, long byteCountBeforeFlushing, int maxLogLineSize, int maxLogFlushSeconds, ThreadGroup requestThreadGroup, RequestState requestState, BackgroundRequestCoordinator coordinator, boolean cloudSqlJdbcConnectivityEnabled, @Nullable Long millisUntilSoftDeadline) {
            this.appVersion = appVersion;
            this.upRequest = upRequest;
            this.requestTimer = requestTimer;
            this.requestId = requestId;
            this.asyncFutures = asyncFutures;
            this.attributes = EnvironmentImpl.createInitialAttributes(upRequest, externalDatacenterName, coordinator, cloudSqlJdbcConnectivityEnabled);
            this.outstandingApiRpcSemaphore = outstandingApiRpcSemaphore;
            this.requestState = requestState;
            this.millisUntilSoftDeadline = millisUntilSoftDeadline;
            this.traceId = this.buildTraceId();
            this.spanId = this.buildSpanId();
            for (HttpPb.ParsedHttpHeader header : upRequest.getRequest().getHeadersList()) {
                if (header.getKey().equals(DEFAULT_NAMESPACE_HEADER)) {
                    this.attributes.put(APPS_NAMESPACE_KEY, header.getValue());
                    continue;
                }
                if (!header.getKey().equals(CURRENT_NAMESPACE_HEADER)) continue;
                this.attributes.put(CURRENT_NAMESPACE_KEY, header.getValue());
            }
            new ApiStatsImpl(this);
            boolean isLongRequest = this.attributes.containsKey(ApiProxyImpl.BACKEND_ID_KEY) || this.isOfflineRequest();
            this.appLogsWriter = new AppLogsWriter(upResponse, byteCountBeforeFlushing, maxLogLineSize, isLongRequest ? maxLogFlushSeconds : 0);
            this.traceWriter = traceWriter;
            this.traceExceptionGenerator = TraceContextHelper.needsStackTrace(upRequest.getTraceContext()) ? new TraceExceptionGenerator() : null;
            if (traceWriter != null && traceWriter.getTraceContext() != null) {
                new CloudTraceImpl(this);
            }
            this.requestThreadGroup = requestThreadGroup;
        }

        private Optional<String> buildTraceId() {
            if (this.upRequest.hasTraceContext()) {
                try {
                    TraceId.TraceIdProto traceIdProto = TraceId.TraceIdProto.parseFrom(this.upRequest.getTraceContext().getTraceId(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
                    String traceIdString = String.format("%016x%016x", traceIdProto.getHi(), traceIdProto.getLo());
                    return Optional.of(traceIdString);
                }
                catch (InvalidProtocolBufferException e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Unable to parse Trace ID:");
                    return Optional.empty();
                }
            }
            return Optional.empty();
        }

        private Optional<String> buildSpanId() {
            if (this.upRequest.hasTraceContext() && this.upRequest.getTraceContext().hasSpanId()) {
                String spanIdString = String.format("%016x", this.upRequest.getTraceContext().getSpanId());
                return Optional.of(spanIdString);
            }
            return Optional.empty();
        }

        long apiRpcStarting(double deadlineInSeconds) throws InterruptedException {
            if (deadlineInSeconds >= Double.MAX_VALUE) {
                this.outstandingApiRpcSemaphore.acquire();
                return 0L;
            }
            long startTime = System.nanoTime();
            long deadlineInMillis = Math.round(deadlineInSeconds * 1000.0);
            boolean acquired = this.outstandingApiRpcSemaphore.tryAcquire(deadlineInMillis, TimeUnit.MILLISECONDS);
            long elapsed = (System.nanoTime() - startTime) / 1000000L;
            if (!acquired || elapsed >= deadlineInMillis) {
                if (acquired) {
                    this.outstandingApiRpcSemaphore.release();
                }
                throw new InterruptedException("Deadline passed while waiting for API slot");
            }
            return elapsed;
        }

        void apiRpcFinished() {
            this.outstandingApiRpcSemaphore.release();
        }

        void addAsyncFuture(Future<?> future) {
            this.asyncFutures.add(future);
        }

        boolean removeAsyncFuture(Future<?> future) {
            return this.asyncFutures.remove(future);
        }

        private static Map<String, Object> createInitialAttributes(RuntimePb.UPRequest upRequest, String externalDatacenterName, BackgroundRequestCoordinator coordinator, boolean cloudSqlJdbcConnectivityEnabled) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put(ApiProxyImpl.USER_ID_KEY, upRequest.getObfuscatedGaiaId());
            attributes.put(ApiProxyImpl.USER_ORGANIZATION_KEY, upRequest.getUserOrganization());
            attributes.put("com.google.appengine.api.users.UserService.federated_identity", "");
            attributes.put("com.google.appengine.api.users.UserService.federated_authority", "");
            attributes.put("com.google.appengine.api.users.UserService.is_federated_user", false);
            if (upRequest.getIsTrustedApp()) {
                attributes.put(ApiProxyImpl.LOAS_PEER_USERNAME, upRequest.getPeerUsername());
                attributes.put(ApiProxyImpl.LOAS_SECURITY_LEVEL, upRequest.getSecurityLevel());
                attributes.put(ApiProxyImpl.IS_TRUSTED_IP, upRequest.getRequest().getTrusted());
                long gaiaId = upRequest.getGaiaId();
                attributes.put(ApiProxyImpl.GAIA_ID, gaiaId == 0L ? "" : Long.toString(gaiaId));
                attributes.put(ApiProxyImpl.GAIA_AUTHUSER, upRequest.getAuthuser());
                attributes.put(ApiProxyImpl.GAIA_SESSION, upRequest.getGaiaSession());
                attributes.put(ApiProxyImpl.APPSERVER_DATACENTER, upRequest.getAppserverDatacenter());
                attributes.put(ApiProxyImpl.APPSERVER_TASK_BNS, upRequest.getAppserverTaskBns());
            }
            if (externalDatacenterName != null) {
                attributes.put(ApiProxyImpl.DATACENTER, externalDatacenterName);
            }
            if (upRequest.hasEventIdHash()) {
                attributes.put(ApiProxyImpl.REQUEST_ID_HASH, upRequest.getEventIdHash());
            }
            if (upRequest.hasRequestLogId()) {
                attributes.put(ApiProxyImpl.REQUEST_LOG_ID, upRequest.getRequestLogId());
            }
            if (upRequest.hasDefaultVersionHostname()) {
                attributes.put(ApiProxyImpl.DEFAULT_VERSION_HOSTNAME, upRequest.getDefaultVersionHostname());
            }
            attributes.put(REQUEST_THREAD_FACTORY_ATTR, CurrentRequestThreadFactory.SINGLETON);
            attributes.put(BACKGROUND_THREAD_FACTORY_ATTR, new BackgroundThreadFactory(coordinator));
            attributes.put(ApiProxyImpl.CLOUD_SQL_JDBC_CONNECTIVITY_ENABLED_KEY, cloudSqlJdbcConnectivityEnabled);
            return Collections.synchronizedMap(attributes);
        }

        public void addLogRecord(ApiProxy.LogRecord record) {
            this.appLogsWriter.addLogRecordAndMaybeFlush(record);
        }

        public void flushLogs() {
            this.appLogsWriter.flushAndWait();
        }

        public TraceWriter getTraceWriter() {
            return this.traceWriter;
        }

        public String getAppId() {
            return this.upRequest.getAppId();
        }

        public String getModuleId() {
            return this.upRequest.getModuleId();
        }

        public String getVersionId() {
            return this.upRequest.getModuleVersionId();
        }

        public Optional<String> getTraceId() {
            return this.traceId;
        }

        public Optional<String> getSpanId() {
            return this.spanId;
        }

        public AppVersion getAppVersion() {
            return this.appVersion;
        }

        public boolean isLoggedIn() {
            return this.upRequest.getEmail().length() > 0;
        }

        public boolean isAdmin() {
            return this.upRequest.getIsAdmin();
        }

        public String getEmail() {
            return this.upRequest.getEmail();
        }

        public String getAuthDomain() {
            return this.upRequest.getAuthDomain();
        }

        @Deprecated
        public String getRequestNamespace() {
            String appsNamespace = (String)this.attributes.get(APPS_NAMESPACE_KEY);
            return appsNamespace == null ? "" : appsNamespace;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        String getSecurityTicket() {
            return this.upRequest.getSecurityTicket();
        }

        boolean isOfflineRequest() {
            return this.upRequest.getRequest().getIsOffline();
        }

        String getRequestId() {
            return this.requestId;
        }

        CpuRatioTimer getRequestTimer() {
            return this.requestTimer;
        }

        ThreadGroup getRequestThreadGroup() {
            return this.requestThreadGroup;
        }

        RequestState getRequestState() {
            return this.requestState;
        }

        public long getRemainingMillis() {
            if (this.millisUntilSoftDeadline == null) {
                return Long.MAX_VALUE;
            }
            return this.millisUntilSoftDeadline - this.requestTimer.getWallclockTimer().getNanoseconds() / 1000000L;
        }

        @VisibleForTesting
        AppLogsWriter getAppLogsWriter() {
            return this.appLogsWriter;
        }

        public TraceExceptionGenerator getTraceExceptionGenerator() {
            return this.traceExceptionGenerator;
        }
    }

    private static final class ApiStatsImpl
    extends ApiStats {
        private long apiTime;
        private final EnvironmentImpl env;

        @CanIgnoreReturnValue
        ApiStatsImpl(EnvironmentImpl env) {
            super((ApiProxy.Environment)env);
            this.env = env;
        }

        public long getApiTimeInMegaCycles() {
            return this.apiTime;
        }

        public long getCpuTimeInMegaCycles() {
            return this.env.getRequestTimer().getCycleCount() / 1000000L;
        }

        private void increaseApiTimeInMegacycles(long delta) {
            this.apiTime += delta;
        }
    }

    private static final class CloudTraceImpl
    extends CloudTrace {
        private final TraceWriter writer;

        @CanIgnoreReturnValue
        CloudTraceImpl(EnvironmentImpl env) {
            super((ApiProxy.Environment)env);
            this.writer = env.getTraceWriter();
            CloudTrace.setCurrentContext((ApiProxy.Environment)env, (CloudTraceContext)this.writer.getTraceContext());
        }

        @Nullable
        protected CloudTraceContext getDefaultContext() {
            return this.writer == null ? null : this.writer.getTraceContext();
        }

        @Nullable
        protected CloudTraceContext startChildSpanImpl(CloudTraceContext parent, String name) {
            return this.writer == null ? null : this.writer.startChildSpan(parent, name);
        }

        protected void setLabelImpl(CloudTraceContext context, String key, String value) {
            if (this.writer != null) {
                this.writer.setLabel(context, key, value);
            }
        }

        protected void endSpanImpl(CloudTraceContext context) {
            if (this.writer != null) {
                this.writer.endSpan(context);
            }
        }
    }

    private static class AsyncApiFuture
    extends ForwardingFuture<byte[]>
    implements AnyRpcCallback<RuntimePb.APIResponse>,
    ApiProxy.ApiResultFuture<byte[]> {
        private final long deadlineMillis;
        private static final long NO_VALUE = -1L;
        private final AnyRpcClientContext rpc;
        private final EnvironmentImpl environment;
        private final CloudTraceContext context;
        private final String packageName;
        private final String methodName;
        private final AtomicLong cpuTimeInMegacycles;
        private final AtomicLong wallclockTimeInMillis;
        private final SettableFuture<byte[]> settable;
        private final Future<byte[]> delegate;
        private final boolean disableApiCallLogging;

        AsyncApiFuture(long deadlineMillis, Future<byte[]> delegate, SettableFuture<byte[]> settable, AnyRpcClientContext rpc, EnvironmentImpl environment, @Nullable CloudTraceContext currentContext, String packageName, String methodName, boolean disableApiCallLogging) {
            this.deadlineMillis = deadlineMillis;
            this.wallclockTimeInMillis = new AtomicLong(-1L);
            this.cpuTimeInMegacycles = new AtomicLong(-1L);
            this.delegate = delegate;
            this.settable = settable;
            this.rpc = rpc;
            this.environment = environment;
            this.context = currentContext;
            this.packageName = packageName;
            this.methodName = methodName;
            this.disableApiCallLogging = disableApiCallLogging;
        }

        @Override
        protected final Future<byte[]> delegate() {
            return this.delegate;
        }

        public long getCpuTimeInMegaCycles() {
            if (!this.isDone()) {
                throw new IllegalStateException("API call has not completed yet.");
            }
            this.cpuTimeInMegacycles.compareAndSet(-1L, 0L);
            return this.cpuTimeInMegacycles.get();
        }

        public long getWallclockTimeInMillis() {
            if (!this.isDone()) {
                throw new IllegalStateException("API call has not completed yet.");
            }
            this.wallclockTimeInMillis.compareAndSet(-1L, this.deadlineMillis);
            return this.wallclockTimeInMillis.get();
        }

        private void endApiSpan() {
            TraceWriter traceWriter = this.environment.getTraceWriter();
            if (traceWriter != null && this.context != null) {
                traceWriter.endApiSpan(this.context);
            }
        }

        @Override
        public void success(RuntimePb.APIResponse response) {
            RuntimePb.APIResponse apiResponse = response;
            this.wallclockTimeInMillis.compareAndSet(-1L, System.currentTimeMillis() - this.rpc.getStartTimeMillis());
            if (apiResponse.hasCpuUsage()) {
                this.cpuTimeInMegacycles.compareAndSet(-1L, apiResponse.getCpuUsage());
                ((ApiStatsImpl)ApiStats.get((ApiProxy.Environment)this.environment)).increaseApiTimeInMegacycles(this.cpuTimeInMegacycles.get());
            }
            this.endApiSpan();
            if (apiResponse.getError() == 0) {
                if (!this.disableApiCallLogging) {
                    ((GoogleLogger.Api)logger.atInfo()).log("API call completed normally with status: %s", this.rpc.getStatus());
                }
                this.settable.set(apiResponse.getPb().toByteArray());
            } else {
                this.settable.setException((Throwable)ApiProxyUtils.getApiError(this.packageName, this.methodName, apiResponse, logger));
            }
            this.environment.removeAsyncFuture(this);
        }

        @Override
        public void failure() {
            this.wallclockTimeInMillis.set(System.currentTimeMillis() - this.rpc.getStartTimeMillis());
            this.endApiSpan();
            this.setRpcError(this.rpc.getStatus(), this.rpc.getApplicationError(), this.rpc.getErrorDetail(), this.rpc.getException());
            this.environment.removeAsyncFuture(this);
        }

        private void setRpcError(Status.StatusProto status, int applicationError, String errorDetail, Throwable cause) {
            ((GoogleLogger.Api)logger.atWarning()).log("APIHost::Call RPC failed : %s : %s", (Object)status, (Object)errorDetail);
            this.settable.setException((Throwable)ApiProxyUtils.getRpcError(this.packageName, this.methodName, status, applicationError, errorDetail, cause));
        }

        @Override
        public boolean cancel(boolean mayInterrupt) {
            if (mayInterrupt && super.cancel(mayInterrupt)) {
                this.rpc.startCancel();
                return true;
            }
            return false;
        }
    }

    private static class TraceExceptionGenerator {
        private static final String FRAME_CLASS = "com.google.appengine.runtime.Request";
        private static final String FRAME_METHOD_PREFIX = "process-";
        private static final String FRAME_FILE = "Request.java";

        private TraceExceptionGenerator() {
        }

        public <T extends Throwable> T getExceptionWithRequestId(T exception, String requestId) {
            StackTraceElement[] frames = exception.getStackTrace();
            StackTraceElement[] newFrames = new StackTraceElement[frames.length + 1];
            newFrames[0] = new StackTraceElement(FRAME_CLASS, FRAME_METHOD_PREFIX + requestId, FRAME_FILE, -1);
            System.arraycopy(frames, 0, newFrames, 1, frames.length);
            exception.setStackTrace(newFrames);
            return exception;
        }
    }

    @AutoBuilder
    public static abstract class Builder {
        public abstract Builder setApiHost(APIHostClientInterface var1);

        public abstract Builder setDeadlineOracle(ApiDeadlineOracle var1);

        public abstract ApiDeadlineOracle deadlineOracle();

        public abstract Builder setExternalDatacenterName(String var1);

        public abstract String externalDatacenterName();

        public abstract Builder setByteCountBeforeFlushing(long var1);

        public abstract long byteCountBeforeFlushing();

        public abstract Builder setMaxLogLineSize(int var1);

        public abstract Builder setMaxLogFlushTime(Duration var1);

        public abstract Duration maxLogFlushTime();

        public abstract Builder setCoordinator(BackgroundRequestCoordinator var1);

        public abstract BackgroundRequestCoordinator coordinator();

        public abstract Builder setCloudSqlJdbcConnectivityEnabled(boolean var1);

        public abstract boolean cloudSqlJdbcConnectivityEnabled();

        public abstract Builder setDisableApiCallLogging(boolean var1);

        public abstract boolean disableApiCallLogging();

        public abstract Builder setLogToLogservice(boolean var1);

        public abstract ApiProxyImpl build();
    }
}

