/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.appengine.api.utils.SystemProperty;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.base.AppId;
import com.google.apphosting.base.AppVersionKey;
import com.google.apphosting.base.protos.AppinfoPb;
import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.ApplicationEnvironment;
import com.google.apphosting.runtime.AutoBuilder_AppVersionFactory_Builder;
import com.google.apphosting.runtime.ClassPathUtils;
import com.google.apphosting.runtime.FileEncodingSetter;
import com.google.apphosting.runtime.NetworkServiceDiverter;
import com.google.apphosting.runtime.NullSandboxPlugin;
import com.google.apphosting.runtime.SessionsConfig;
import com.google.apphosting.runtime.StreamHandlerFactory;
import com.google.apphosting.runtime.ThreadGroupPool;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import com.google.apphosting.utils.config.ClassPathBuilder;
import com.google.auto.value.AutoBuilder;
import com.google.common.base.Ascii;
import com.google.common.base.Strings;
import com.google.common.flogger.GoogleLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class AppVersionFactory {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final boolean USE_DEFAULT_VALUES_FOR_GAE_ENV_VARS = Boolean.getBoolean("com.google.appengine.runtime.use.default.values.for.gae.env.vars");
    private static final String GAE_ENV = "GAE_ENV";
    private static final String GAE_RUNTIME = "GAE_RUNTIME";
    private final NullSandboxPlugin sandboxPlugin;
    private final File sharedDirectory;
    private final String runtimeVersion;
    private final boolean defaultToNativeUrlStreamHandler;
    private final boolean forceUrlfetchUrlStreamHandler;
    private final boolean ignoreDaemonThreads;
    private final boolean useEnvVarsFromAppInfo;
    private final String fixedApplicationPath;

    public static Builder builder() {
        return new AutoBuilder_AppVersionFactory_Builder();
    }

    public static Builder builderForTest() {
        return AppVersionFactory.builder().setDefaultToNativeUrlStreamHandler(true).setForceUrlfetchUrlStreamHandler(false).setIgnoreDaemonThreads(true).setUseEnvVarsFromAppInfo(false).setFixedApplicationPath(null);
    }

    public AppVersionFactory(NullSandboxPlugin sandboxPlugin, File sharedDirectory, String runtimeVersion, boolean defaultToNativeUrlStreamHandler, boolean forceUrlfetchUrlStreamHandler, boolean ignoreDaemonThreads, boolean useEnvVarsFromAppInfo, @Nullable String fixedApplicationPath) {
        this.sandboxPlugin = sandboxPlugin;
        this.sharedDirectory = sharedDirectory;
        this.runtimeVersion = runtimeVersion;
        this.defaultToNativeUrlStreamHandler = defaultToNativeUrlStreamHandler;
        this.forceUrlfetchUrlStreamHandler = forceUrlfetchUrlStreamHandler;
        this.ignoreDaemonThreads = ignoreDaemonThreads;
        this.useEnvVarsFromAppInfo = useEnvVarsFromAppInfo;
        this.fixedApplicationPath = fixedApplicationPath;
    }

    public AppEngineWebXml readAppEngineWebXml(AppinfoPb.AppInfo appInfo) throws FileNotFoundException {
        File rootDirectory = this.getRootDirectory(appInfo);
        AppEngineWebXmlReader reader = new AppEngineWebXmlReader(rootDirectory.getPath()){

            @Override
            protected boolean allowMissingThreadsafeElement() {
                return true;
            }
        };
        AppEngineWebXml appEngineWebXml = reader.readAppEngineWebXml();
        ((GoogleLogger.Api)logger.atFine()).log("Loaded appengine-web.xml: %s", appEngineWebXml);
        return appEngineWebXml;
    }

    public AppVersion createAppVersion(AppinfoPb.AppInfo appInfo, AppEngineWebXml appEngineWebXml, ApplicationEnvironment.RuntimeConfiguration configuration) throws IOException {
        String deadline;
        boolean useNative;
        String preventInlining;
        String forceCloudsqlReadahead;
        AppVersionKey appVersionKey = AppVersionKey.fromAppInfo(appInfo);
        File rootDirectory = this.getRootDirectory(appInfo);
        ((GoogleLogger.Api)logger.atFine()).log("Loaded appengine-web.xml: %s", appEngineWebXml);
        Map<String, String> sysProps = this.createSystemProperties(appEngineWebXml, appInfo);
        Map<String, String> envVars = this.createEnvironmentVariables(appEngineWebXml, appInfo);
        ThreadGroup rootThreadGroup = new ThreadGroup("App Engine: " + appVersionKey);
        FileEncodingSetter.set(sysProps);
        String supportExtendedAttachments = System.getProperty("appengine.mail.supportExtendedAttachmentEncodings");
        if (supportExtendedAttachments != null) {
            sysProps.put("appengine.mail.supportExtendedAttachmentEncodings", supportExtendedAttachments);
        }
        if ((forceCloudsqlReadahead = System.getProperty("appengine.jdbc.forceReadaheadOnCloudsqlSocket")) != null) {
            sysProps.put("appengine.jdbc.forceReadaheadOnCloudsqlSocket", forceCloudsqlReadahead);
        }
        if ((preventInlining = System.getProperty("appengine.mail.filenamePreventsInlining")) != null) {
            sysProps.put("appengine.mail.filenamePreventsInlining", preventInlining);
        }
        ApplicationEnvironment environment = new ApplicationEnvironment(appInfo.getAppId(), appInfo.getVersionId(), sysProps, envVars, rootDirectory, configuration);
        String urlStreamHandlerType = appEngineWebXml.getUrlStreamHandlerType();
        if (urlStreamHandlerType == null && this.defaultToNativeUrlStreamHandler) {
            urlStreamHandlerType = "native";
        }
        if (this.forceUrlfetchUrlStreamHandler) {
            urlStreamHandlerType = "urlfetch";
        }
        if (!(useNative = NetworkServiceDiverter.useNativeUrlStreamHandler(urlStreamHandlerType))) {
            URL.setURLStreamHandlerFactory(new StreamHandlerFactory());
        }
        if ((deadline = sysProps.get("appengine.api.urlfetch.defaultDeadline")) != null) {
            try {
                Double.parseDouble(deadline);
            }
            catch (NumberFormatException e) {
                ((GoogleLogger.Api)logger.atInfo()).log("Invalid value for %s property", "appengine.api.urlfetch.defaultDeadline");
            }
            System.setProperty("appengine.api.urlfetch.defaultDeadline", deadline);
        }
        ClassLoader classLoader = this.createClassLoader(environment, rootDirectory, appInfo, appEngineWebXml);
        SessionsConfig sessionsConfig = new SessionsConfig(appEngineWebXml.getSessionsEnabled(), appEngineWebXml.getAsyncSessionPersistence(), appEngineWebXml.getAsyncSessionPersistenceQueueName());
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = (thread, ex) -> ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Uncaught exception from %s", thread);
        ThreadGroupPool threadGroupPool = ThreadGroupPool.builder().setParentThreadGroup(rootThreadGroup).setThreadGroupNamePrefix("Request #").setUncaughtExceptionHandler(uncaughtExceptionHandler).setIgnoreDaemonThreads(this.ignoreDaemonThreads).build();
        this.suppressJaxbWarningReflectionIsNotAllowed(classLoader);
        AppVersionFactory.setApplicationDirectory(rootDirectory.getAbsolutePath());
        return AppVersion.builder().setAppVersionKey(appVersionKey).setAppInfo(appInfo).setRootDirectory(rootDirectory).setClassLoader(classLoader).setEnvironment(environment).setSessionsConfig(sessionsConfig).setPublicRoot(appEngineWebXml.getPublicRoot()).setThreadGroupPool(threadGroupPool).build();
    }

    public AppVersion createAppVersionForTest(AppinfoPb.AppInfo appInfo) throws IOException {
        AppEngineWebXml appEngineWebXml = this.readAppEngineWebXml(appInfo);
        return this.createAppVersion(appInfo, appEngineWebXml, ApplicationEnvironment.RuntimeConfiguration.DEFAULT_FOR_TEST);
    }

    private File getRootDirectory(AppinfoPb.AppInfo appInfo) throws FileNotFoundException {
        if (Strings.isNullOrEmpty(this.fixedApplicationPath)) {
            AppVersionKey appVersionKey = AppVersionKey.fromAppInfo(appInfo);
            return this.getRootDirectory(appVersionKey);
        }
        File rootDirectory = new File(this.fixedApplicationPath);
        if (!rootDirectory.isDirectory()) {
            throw new FileNotFoundException("Application directory not found or is not a directory: " + this.fixedApplicationPath);
        }
        return rootDirectory;
    }

    private File getRootDirectory(AppVersionKey appVersionKey) throws FileNotFoundException {
        File root = new File(new File(this.sharedDirectory, appVersionKey.getAppId()), appVersionKey.getVersionId());
        if (!root.isDirectory()) {
            throw new FileNotFoundException(root.toString());
        }
        return root.getAbsoluteFile();
    }

    private Map<String, String> createSystemProperties(AppEngineWebXml appEngineWebXml, AppinfoPb.AppInfo appInfo) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(appEngineWebXml.getSystemProperties());
        props.put(SystemProperty.environment.key(), SystemProperty.Environment.Value.Production.value());
        props.put(SystemProperty.version.key(), this.runtimeVersion);
        AppId appId = AppId.parse(appInfo.getAppId());
        props.put(SystemProperty.applicationId.key(), appId.getLongAppId());
        props.put(SystemProperty.applicationVersion.key(), appInfo.getVersionId());
        return props;
    }

    private Map<String, String> createEnvironmentVariables(AppEngineWebXml appEngineWebXml, AppinfoPb.AppInfo appInfo) {
        HashMap<String, String> envVars = new HashMap<String, String>();
        envVars.putAll(appEngineWebXml.getEnvironmentVariables());
        if (this.useEnvVarsFromAppInfo) {
            for (AppinfoPb.AppInfo.EnvironmentVariable envVar : appInfo.getEnvironmentVariableList()) {
                envVars.put(envVar.getName(), envVar.getValue());
            }
        }
        String gaeEnv = System.getenv(GAE_ENV);
        if (USE_DEFAULT_VALUES_FOR_GAE_ENV_VARS && gaeEnv == null) {
            gaeEnv = "standard";
        }
        if (gaeEnv != null) {
            envVars.putIfAbsent(GAE_ENV, gaeEnv);
        }
        String gaeRuntime = System.getenv(GAE_RUNTIME);
        if (USE_DEFAULT_VALUES_FOR_GAE_ENV_VARS && gaeRuntime == null) {
            gaeRuntime = appInfo.getRuntimeId();
        }
        if (gaeRuntime != null) {
            envVars.putIfAbsent(GAE_RUNTIME, gaeRuntime);
        }
        return Collections.unmodifiableMap(envVars);
    }

    private ClassLoader createClassLoader(ApplicationEnvironment environment, File root, AppinfoPb.AppInfo appInfo, AppEngineWebXml appEngineWebXml) throws IOException {
        ClassPathUtils classPathUtils = this.sandboxPlugin.getClassPathUtils();
        ClassPathBuilder classPathBuilder = new ClassPathBuilder(appEngineWebXml.getClassLoaderConfig());
        try {
            File classes = new File(new File(root, "WEB-INF"), "classes");
            if (classes.isDirectory()) {
                classPathBuilder.addClassesUrl(classes.toURI().toURL());
            }
        }
        catch (MalformedURLException ex) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Could not add WEB-INF/classes");
        }
        String apiVersion = appInfo.getApiVersion();
        if (!(apiVersion.isEmpty() || Ascii.equalsIgnoreCase(apiVersion, "none") || Ascii.equalsIgnoreCase(apiVersion, "user_defined"))) {
            if (classPathUtils == null) {
                ((GoogleLogger.Api)logger.atInfo()).log("Ignoring API version setting %s", apiVersion);
            } else {
                File apiJar = classPathUtils.getFrozenApiJar();
                if (apiJar != null) {
                    ((GoogleLogger.Api)logger.atInfo()).log("Adding API jar %s for version %s", (Object)apiJar, (Object)apiVersion);
                    try {
                        classPathBuilder.addAppengineJar(new URL("file", "", apiJar.getAbsolutePath()));
                    }
                    catch (MalformedURLException ex) {
                        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Could not parse URL for %s, ignoring.", apiJar);
                    }
                    File appengineApiLegacyJar = classPathUtils.getAppengineApiLegacyJar();
                    if (appengineApiLegacyJar != null) {
                        ((GoogleLogger.Api)logger.atInfo()).log("Adding appengine-api-legacy jar %s", appengineApiLegacyJar);
                        try {
                            classPathBuilder.addAppengineJar(new URL("file", "", appengineApiLegacyJar.getAbsolutePath()));
                        }
                        catch (MalformedURLException ex) {
                            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Could not parse URL for %s, ignoring.", appengineApiLegacyJar);
                        }
                    }
                } else {
                    ((GoogleLogger.Api)logger.atWarning()).log("The Java runtime is not adding an API jar for this application, as the Java api_version defined in app.yaml or appinfo is unknown: %s", apiVersion);
                }
            }
        }
        if (!appInfo.getFileList().isEmpty()) {
            for (AppinfoPb.AppInfo.File appFile : appInfo.getFileList()) {
                File file = new File(root, appFile.getPath());
                if (appFile.getPath().startsWith("WEB-INF/lib/_ah")) {
                    try {
                        classPathBuilder.addClassesUrl(new URL("file", "", file.getAbsolutePath()));
                    }
                    catch (MalformedURLException ex) {
                        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Could not get URL for file: %s", file);
                    }
                    continue;
                }
                if (!appFile.getPath().startsWith("WEB-INF/lib/")) continue;
                try {
                    classPathBuilder.addAppJar(new URL("file", "", file.getAbsolutePath()));
                }
                catch (MalformedURLException ex) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Could not get URL for file: %s", file);
                }
            }
        } else {
            Path pathToLib = FileSystems.getDefault().getPath(root.getAbsolutePath(), "WEB-INF", "lib");
            if (pathToLib.toFile().isDirectory()) {
                try (Stream<Path> stream = Files.walk(pathToLib, 1, FileVisitOption.FOLLOW_LINKS);){
                    stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                        if (path.getFileName().toString().startsWith("_ah")) {
                            try {
                                classPathBuilder.addClassesUrl(new URL("file", "", path.toString()));
                            }
                            catch (MalformedURLException ex) {
                                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Could not get URL for file: %s", path);
                            }
                        } else {
                            try {
                                classPathBuilder.addAppJar(new URL("file", "", path.toString()));
                            }
                            catch (MalformedURLException ex) {
                                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Could not get URL for file: %s", path);
                            }
                        }
                    });
                }
            }
        }
        switch (appEngineWebXml.getUseGoogleConnectorJ()) {
            case NOT_STATED_BY_USER: {
                environment.setUseGoogleConnectorJ(null);
                break;
            }
            case TRUE: {
                environment.setUseGoogleConnectorJ(true);
                break;
            }
            case FALSE: {
                environment.setUseGoogleConnectorJ(false);
            }
        }
        return this.sandboxPlugin.createApplicationClassLoader(this.getUrls(classPathBuilder), root, environment);
    }

    private URL[] getUrls(ClassPathBuilder classPathBuilder) {
        URL[] urls = classPathBuilder.getUrls();
        String message = classPathBuilder.getLogMessage();
        if (!message.isEmpty()) {
            ApiProxy.log((ApiProxy.LogRecord)new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.warn, System.currentTimeMillis() * 1000L, message));
        }
        return urls;
    }

    private void suppressJaxbWarningReflectionIsNotAllowed(ClassLoader classLoader) {
        if (System.getSecurityManager() != null) {
            try {
                Class<?> accessorClass = classLoader.loadClass("com.sun.xml.bind.v2.runtime.reflect.Accessor");
                Field accessWarned = accessorClass.getDeclaredField("accessWarned");
                accessWarned.setAccessible(true);
                accessWarned.setBoolean(null, true);
            }
            catch (Exception e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("failed to suppress JAXB warning reflectively");
            }
        }
    }

    private static void setApplicationDirectory(String path) throws IOException {
        System.setProperty("user.dir", path);
        if (!Boolean.getBoolean("com.google.apphosting.runtime.disableChdir")) {
            NullSandboxPlugin.chdir(path);
            File gotCwd = new File(".").getCanonicalFile();
            File wantCwd = new File(path).getCanonicalFile();
            if (!gotCwd.equals(wantCwd)) {
                ((GoogleLogger.Api)logger.atWarning()).log("Want current directory to be %s but it is %s", (Object)wantCwd, (Object)gotCwd);
            }
        }
    }

    @AutoBuilder
    public static abstract class Builder {
        public abstract Builder setSandboxPlugin(NullSandboxPlugin var1);

        public abstract Builder setSharedDirectory(File var1);

        public abstract Builder setRuntimeVersion(String var1);

        public abstract Builder setDefaultToNativeUrlStreamHandler(boolean var1);

        public abstract Builder setForceUrlfetchUrlStreamHandler(boolean var1);

        public abstract Builder setIgnoreDaemonThreads(boolean var1);

        public abstract Builder setUseEnvVarsFromAppInfo(boolean var1);

        public abstract Builder setFixedApplicationPath(String var1);

        public abstract AppVersionFactory build();
    }
}

