/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.runtime.ThreadGroupPool;

class AutoBuilder_ThreadGroupPool_Builder
extends ThreadGroupPool.Builder {
    private ThreadGroup parentThreadGroup;
    private String threadGroupNamePrefix;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private Boolean ignoreDaemonThreads;

    AutoBuilder_ThreadGroupPool_Builder() {
    }

    @Override
    public ThreadGroupPool.Builder setParentThreadGroup(ThreadGroup parentThreadGroup) {
        if (parentThreadGroup == null) {
            throw new NullPointerException("Null parentThreadGroup");
        }
        this.parentThreadGroup = parentThreadGroup;
        return this;
    }

    @Override
    public ThreadGroupPool.Builder setThreadGroupNamePrefix(String threadGroupNamePrefix) {
        if (threadGroupNamePrefix == null) {
            throw new NullPointerException("Null threadGroupNamePrefix");
        }
        this.threadGroupNamePrefix = threadGroupNamePrefix;
        return this;
    }

    @Override
    public ThreadGroupPool.Builder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        if (uncaughtExceptionHandler == null) {
            throw new NullPointerException("Null uncaughtExceptionHandler");
        }
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    @Override
    public ThreadGroupPool.Builder setIgnoreDaemonThreads(boolean ignoreDaemonThreads) {
        this.ignoreDaemonThreads = ignoreDaemonThreads;
        return this;
    }

    @Override
    public ThreadGroupPool build() {
        if (this.parentThreadGroup == null || this.threadGroupNamePrefix == null || this.uncaughtExceptionHandler == null || this.ignoreDaemonThreads == null) {
            StringBuilder missing = new StringBuilder();
            if (this.parentThreadGroup == null) {
                missing.append(" parentThreadGroup");
            }
            if (this.threadGroupNamePrefix == null) {
                missing.append(" threadGroupNamePrefix");
            }
            if (this.uncaughtExceptionHandler == null) {
                missing.append(" uncaughtExceptionHandler");
            }
            if (this.ignoreDaemonThreads == null) {
                missing.append(" ignoreDaemonThreads");
            }
            throw new IllegalStateException("Missing required properties:" + missing);
        }
        return new ThreadGroupPool(this.parentThreadGroup, this.threadGroupNamePrefix, this.uncaughtExceptionHandler, this.ignoreDaemonThreads);
    }
}

